/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.migration.translation.SchemaDetails;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.navigator.SchemaDetailsRenderer;
import oracle.dbtools.raptor.controls.display.IModifyToolbar;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.controls.Toolbar;
import oracle.javatools.db.DBException;

public class ModelChooserToolbar
implements IModifyToolbar {
    public static final String BABELFISH_TAG = "BABELFISH:";
    JComboBox m_captureModelSelectBox = null;
    String _defaultConn = null;
    String INSERT_SCHEMADETAILS_CHOICE_SQL = "MERGE INTO md_additional_properties p  USING (select null id ,:conn_id connection_id_fk,:ref_id_fk ref_id_fk,'MD_SCHEMAS' ref_type,1 property_order,:targetSchemaName prop_key,:schemaDetailsStr value from dual) d  ON (p.prop_key = d.prop_key)  WHEN MATCHED THEN   UPDATE SET p.value = d.value,              p.connection_id_fk  =d.connection_id_fk,              p.ref_id_fk = d.ref_id_fk  WHEN NOT MATCHED THEN   INSERT (id ,connection_id_fk,ref_id_fk,ref_type, property_order,prop_key,value )   VALUES (null ,d.connection_id_fk,d.ref_id_fk,d.ref_type,d.property_order,d.prop_key,d.value)";
    Map<String, Object> _binds = null;

    public void modifyToolbar(Toolbar toolbar) {
        this.addModelCombo(toolbar, true);
    }

    protected void addModelCombo(Toolbar toolbar, boolean bl) {
        JComponent jComponent;
        toolbar.addSeparator();
        if (bl) {
            toolbar.add(Box.createHorizontalGlue());
            jComponent = new JPanel(new BorderLayout());
            jComponent.setOpaque(false);
            toolbar.add((Component)jComponent);
            jComponent.setVisible(false);
        }
        toolbar.add((Component)new JLabel("Model Schema:"));
        toolbar.add(Box.createHorizontalStrut(10));
        jComponent = this.getCaptureModelSelector();
        jComponent.setToolTipText("Choose Source Connection");
        toolbar.add((Component)jComponent);
    }

    public JComboBox getCaptureModelSelector() {
        Vector<SchemaDetails> vector = new Vector<SchemaDetails>();
        vector.add(new SchemaDetails());
        if (MigrationAddin.isRepositoryOpen()) {
            vector.addAll(this.getSchemas());
        }
        Integer[] integerArray = new Integer[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            integerArray[i] = new Integer(i);
        }
        this.m_captureModelSelectBox = new JComboBox<Integer>(integerArray);
        this.m_captureModelSelectBox.setRenderer(new SchemaDetailsRenderer(vector));
        this.m_captureModelSelectBox.setSize(new Dimension(40, 20));
        this.m_captureModelSelectBox.setPreferredSize(this.m_captureModelSelectBox.getSize());
        this.m_captureModelSelectBox.setMaximumSize(this.m_captureModelSelectBox.getPreferredSize());
        this.m_captureModelSelectBox.setToolTipText("Captured Schema");
        this.m_captureModelSelectBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Integer n = (Integer)ModelChooserToolbar.this.m_captureModelSelectBox.getSelectedItem();
                SchemaDetails schemaDetails = ((SchemaDetailsRenderer)ModelChooserToolbar.this.m_captureModelSelectBox.getRenderer()).getSchemaDetails(n);
                String string = (String)ModelChooserToolbar.this._binds.get("OBJECT_OWNER");
                String string2 = (String)ModelChooserToolbar.this._binds.get("OBJECT_NAME");
                String string3 = "\"" + string + "\"." + "\"" + string2 + "\"";
                this.saveSchemaDetails(schemaDetails, string3);
            }

            private void saveSchemaDetails(SchemaDetails schemaDetails, String string) {
                DBUtil dBUtil = DBUtil.getInstance((String)MigrationAddin.getRepositoryConnectionName());
                Connections.getInstance().lock(MigrationAddin.getRepositoryConnectionName());
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("conn_id", schemaDetails.getCapConnId());
                hashMap.put("ref_id_fk", schemaDetails.getCapSchemaId());
                hashMap.put("targetSchemaName", ModelChooserToolbar.BABELFISH_TAG + string);
                hashMap.put("schemaDetailsStr", schemaDetails.getPersistString());
                int n = dBUtil.executeUpdate(ModelChooserToolbar.this.INSERT_SCHEMADETAILS_CHOICE_SQL, hashMap);
                try {
                    Connections.getInstance().getConnection(MigrationAddin.getRepositoryConnectionName()).commit();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                catch (DBException dBException) {
                    dBException.printStackTrace();
                }
                Connections.getInstance().unlock(MigrationAddin.getRepositoryConnectionName());
            }
        });
        return this.m_captureModelSelectBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<SchemaDetails> getSchemas() {
        Vector<SchemaDetails> vector;
        block9: {
            vector = new Vector<SchemaDetails>();
            try {
                String string = "select capprojectname||':'||capconnname||':'||capqualifiedname label, capschemaid,capcatalogid,capconnid,  conschemaid,concatalogid,conconnid,capprojectid from mgv_derived_details where capobjtype='MD_SCHEMAS' AND conschemaid IS NOT NULL";
                DBUtil dBUtil = DBUtil.getInstance((String)MigrationAddin.getRepositoryConnectionName());
                Connections.getInstance().lock(MigrationAddin.getRepositoryConnectionName());
                ResultSet resultSet = dBUtil.executeOracleQuery(string, null);
                if (resultSet == null) break block9;
                String string2 = null;
                Object var20_6 = null;
                try {
                    while (resultSet.next()) {
                        string2 = resultSet.getString("label");
                        long l = resultSet.getLong("capschemaid");
                        long l2 = resultSet.getLong("capcatalogid");
                        long l3 = resultSet.getLong("capconnid");
                        long l4 = resultSet.getLong("conschemaid");
                        long l5 = resultSet.getLong("concatalogid");
                        long l6 = resultSet.getLong("conconnid");
                        long l7 = resultSet.getLong("capprojectid");
                        l = resultSet.getLong("capschemaid");
                        l = resultSet.getLong("capschemaid");
                        vector.add(new SchemaDetails(string2, l7, l3, l2, l, l6, l5, l4));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
            }
            finally {
                Connections.getInstance().unlock(MigrationAddin.getRepositoryConnectionName());
            }
        }
        return vector;
    }

    public void modifyToolbar(Toolbar toolbar, Map<String, Object> map) {
        this._binds = map;
        this.modifyToolbar(toolbar);
    }
}

