/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorController;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.ui.CustomTree;
import oracle.ide.controller.Controller;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;

public class MigrationProjectNavigatorWindow
extends NavigatorWindow {
    private MouseAdapter _mouseTrap = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (DBConfig.getInstance().getBoolean("OPEN_ON_SINGLE_CLICK").booleanValue() || mouseEvent.getClickCount() == 2) {
                Object object = mouseEvent.getSource();
                ViewableElement viewableElement = null;
                if (object instanceof CustomTree) {
                    MigrationProjectsFolderNode migrationProjectsFolderNode;
                    CustomTree customTree = (CustomTree)object;
                    TreePath treePath = customTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null) {
                        viewableElement = MigrationProjectNavigatorWindow.this.getLastObject(customTree);
                    }
                    if ((migrationProjectsFolderNode = MigrationProjectsFolderNode.getInstance()).equals(viewableElement) && !MigrationAddin.isRepositoryOpen()) {
                        mouseEvent.consume();
                    }
                }
            }
        }
    };

    public MigrationProjectNavigatorWindow(ViewId viewId) {
        super(viewId);
    }

    protected Controller createController() {
        return new MigrationProjectNavigatorController(this);
    }

    protected Element getRootElement() {
        return MigrationProjectsFolderNode.getInstance();
    }

    protected void initCustomItems() {
        NavigatorTree navigatorTree = this.getTree();
        CustomTree customTree = navigatorTree.getTree();
        boolean bl = true;
        for (MouseListener mouseListener : customTree.getMouseListeners()) {
            if (mouseListener != this._mouseTrap) continue;
            bl = false;
            break;
        }
        if (bl) {
            customTree.addMouseListener((MouseListener)this._mouseTrap);
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_migration_projects_html");
    }

    public boolean canCollapse(NavigatorTreeNode navigatorTreeNode) {
        NavigatorTree navigatorTree = this.getTree();
        return navigatorTree.getRoot() != navigatorTreeNode;
    }

    public String getTitleName() {
        return MigrationAddinArb.getString("MIGRATION_NAV_TITLE");
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public Icon getTabIcon() {
        return MigrationAddin.migrationIcon;
    }

    private ViewableElement getLastObject(CustomTree customTree) {
        Element element;
        ViewableElement viewableElement = null;
        if (customTree.getSelectionCount() > 0 && (element = ((NavigatorTreeNode)customTree.getLastSelectedPathComponent()).getElement()) instanceof ViewableElement) {
            viewableElement = (ViewableElement)element;
        }
        return viewableElement;
    }
}

