/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationOverlayClient;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorWindow;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedObjectsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ConvertedModelsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.migration.workbench.core.repository.DeleteCapturedConnection;
import oracle.dbtools.migration.workbench.core.repository.DeleteConvertedConnection;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.db.DBAdapter;
import oracle.dbtools.raptor.navigator.db.DBTreeUpdater;
import oracle.dbtools.raptor.navigator.db.DBViewControllerImpl;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.db.UIUpdater;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.db.ConnectionException;

public class MigrationProjectNavigatorController
implements Controller {
    private int cmdDebugId = Ide.findOrCreateCmdID((String)"DebugSelectionCommand");
    private int cmdRunId = Ide.findOrCreateCmdID((String)"RunSelectionCommand");
    public static final int COLLAPSEALL_CONNECTIONS_ID = Ide.findOrCreateCmdID((String)"MigrationProjectNavigator.COLLAPSEALL_CONNECTIONS");

    public MigrationProjectNavigatorController(final MigrationProjectNavigatorWindow migrationProjectNavigatorWindow) {
        IdeAction ideAction;
        IdeAction ideAction2;
        DBAdapter.registerTreeUpdater((UIUpdater)new DBTreeUpdater("sqldev.migration", migrationProjectNavigatorWindow){

            protected NavigatorTreeNode getConnectionNode(String string) {
                return migrationProjectNavigatorWindow.getTree().getRoot();
            }
        });
        L l = new L();
        Node.addNodeListenerForType(MigrationProjectsFolderNode.class, (NodeListener)l);
        Node.addNodeListenerForType(ConvertedModelsFolderNode.class, (NodeListener)l);
        Node.addNodeListenerForType(CapturedObjectsFolderNode.class, (NodeListener)l);
        IdeAction ideAction3 = IdeAction.find((int)20);
        if (ideAction3 != null) {
            ideAction3.addController((Controller)this);
        }
        if ((ideAction2 = IdeAction.find((int)this.cmdDebugId)) != null) {
            ideAction2.addController((Controller)this);
        }
        if ((ideAction = IdeAction.find((int)this.cmdRunId)) != null) {
            ideAction.addController((Controller)this);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        Element element = context.getElement();
        int n = ideAction.getCommandId();
        if (n == 20) {
            if (element instanceof DatabaseConnection) {
                try {
                    DBViewControllerImpl.deleteConnection((DatabaseConnection)((DatabaseConnection)element), (Context)context);
                }
                catch (ConnectionException connectionException) {
                    MessageDialog.error(null, (Object)connectionException.getMessage(), (String)DatabaseNavigatorResources.getString((String)"CONTROLLER_CANNOT_DELETE"), null);
                }
                return true;
            }
            if (element instanceof CapturedConnectionNode || element instanceof ConvertedConnectionNode) {
                this.deleteSelectedNodes(context);
                return true;
            }
        }
        return false;
    }

    private void deleteSelectedNodes(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length > 0) {
            AbstractMenuAction abstractMenuAction = null;
            if (elementArray[0] instanceof CapturedConnectionNode) {
                abstractMenuAction = new DeleteCapturedConnection();
            } else if (elementArray[0] instanceof ConvertedConnectionNode) {
                abstractMenuAction = new DeleteConvertedConnection();
            }
            abstractMenuAction.setContext(context);
            abstractMenuAction.setDBObject(new DBObject(elementArray[0]));
            abstractMenuAction.launch();
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        Element element = context.getElement();
        if (n == 20) {
            if (element instanceof DatabaseConnection) {
                ideAction.setEnabled(true);
                return true;
            }
            if (element instanceof CapturedConnectionNode || element instanceof ConvertedConnectionNode) {
                ideAction.setEnabled(true);
                bl = true;
            }
        }
        if (element instanceof CapturedNode && (n == this.cmdDebugId || n == this.cmdRunId)) {
            ideAction.setEnabled(false);
            bl = true;
        }
        return bl;
    }

    private static final class L
    extends NodeListener {
        private L() {
        }

        public void nodeOpened(NodeEvent nodeEvent) {
            this.updateNodeState(nodeEvent);
        }

        private void updateNodeState(NodeEvent nodeEvent) {
            IconOverlayTracker iconOverlayTracker = MigrationOverlayClient.getTracker();
            if (iconOverlayTracker != null) {
                iconOverlayTracker.validateOverlay((Element)nodeEvent.getNode());
                iconOverlayTracker.repaintOverlays();
            }
        }

        public void nodeClosed(NodeEvent nodeEvent) {
            this.updateNodeState(nodeEvent);
        }
    }
}

