/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.logging;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.util.Messages;

public final class MigrationLogUtil {
    public static final String FILTER_KEY = "MigrationConnectionId";
    public static final String MIGRATIONLOG = "oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle";
    private static DBObjectId s_sessionConnectionId;

    private MigrationLogUtil() {
    }

    public static void logGroup(String string, Level level, String[] stringArray) {
        if (string == null || stringArray == null) {
            throw new IllegalArgumentException(Messages.getString("MigrationLogUtil.4"));
        }
        Logger logger = Logger.getLogger(MIGRATIONLOG);
        LogInfo logInfo = new LogInfo("");
        for (int i = 0; i < stringArray.length; ++i) {
            LogRecord logRecord = new LogRecord(level, stringArray[i]);
            logRecord.setLoggerName(logger.getName());
            logInfo.addChild(logRecord);
        }
        logger.log(Level.INFO, string, logInfo);
    }

    public static void logGroup(String string, String[] stringArray, Level[] levelArray) {
        if (string == null || stringArray == null) {
            throw new IllegalArgumentException(Messages.getString("MigrationLogUtil.6"));
        }
        Logger logger = Logger.getLogger(MIGRATIONLOG);
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            LogRecord logRecord = new LogRecord(levelArray[i], stringArray[i]);
            logRecord.setLoggerName(logger.getName());
            objectArray[i] = logRecord;
        }
        logger.log(Level.INFO, string, objectArray);
    }

    public static void logThrowable(String string, String string2, Throwable throwable) {
        MigrationLogUtil.logThrowable(string, new Object[]{new LogInfo(string2)}, throwable);
    }

    public static void logThrowable(String string, Object[] objectArray, Throwable throwable) {
        Logger logger = Logger.getLogger(MIGRATIONLOG, MIGRATIONLOG);
        if (string == null && throwable != null) {
            string = throwable.toString();
        }
        LogRecord logRecord = new LogRecord(Level.SEVERE, string == null ? "Error unknown" : string);
        logRecord.setParameters(objectArray);
        logRecord.setThrown(throwable);
        logRecord.setLoggerName(logger.getName());
        logRecord.setResourceBundle(ResourceBundle.getBundle(MIGRATIONLOG));
        logger.log(logRecord);
    }

    public static <T> List<T> searchParameterByType(Object[] objectArray, Class<T> clazz) {
        ArrayList<Object> arrayList = null;
        try {
            if (objectArray == null) {
                return Collections.emptyList();
            }
            arrayList = new ArrayList<Object>();
            for (Object object : objectArray) {
                if (clazz == null || object == null || !clazz.isAssignableFrom(object.getClass())) continue;
                arrayList.add(object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static synchronized void startMigrationLogSession(DBObjectId dBObjectId) {
        if (s_sessionConnectionId != null && !s_sessionConnectionId.equals(dBObjectId)) {
            Logger.getLogger(MIGRATIONLOG).log(Level.WARNING, MessageFormat.format(Messages.getString("MigrationLogUtil.7"), s_sessionConnectionId));
        }
        s_sessionConnectionId = dBObjectId;
    }

    public static DBObjectId getCurrentSession() {
        return s_sessionConnectionId;
    }

    public static synchronized void endMigrationLogSession() {
        for (Handler handler : Logger.getLogger(MIGRATIONLOG).getHandlers()) {
            handler.flush();
        }
        s_sessionConnectionId = null;
    }

    public static synchronized void endMigrationLogWizard() {
        for (Handler handler : Logger.getLogger(MIGRATIONLOG).getHandlers()) {
            handler.flush();
        }
        s_sessionConnectionId = null;
    }

    public static void log(Level level, String string, Exception exception) {
    }
}

