/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.logging;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.persistence.Migrlog;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.utils.Connections;

public final class MigrationLogPersistenceHandler
extends Handler {
    private static MigrationLogPersistenceHandler s_self;
    private ArrayList<Migrlog> _miglogs = new ArrayList();
    private static final int CACHESIZE = 20;

    public static synchronized MigrationLogPersistenceHandler getInstance() {
        if (s_self == null) {
            s_self = new MigrationLogPersistenceHandler();
        }
        return s_self;
    }

    private MigrationLogPersistenceHandler() {
    }

    private void insertLogRecursively(LogRecord logRecord, Formatter formatter) {
        Iterator<LogRecord> iterator;
        Migrlog migrlog = new Migrlog(new Timestamp(logRecord.getMillis()), logRecord.getLevel().intValue());
        List<LogInfo> list = MigrationLogUtil.searchParameterByType(logRecord.getParameters(), LogInfo.class);
        migrlog.setParentLogId(null);
        String string = this.getFormatter() == null ? logRecord.getMessage() : this.getFormatter().format(logRecord);
        migrlog.setLogtext(string);
        migrlog.setPhase(this.getPhase(logRecord));
        migrlog.setConnectionId(this.getProjectId(logRecord));
        migrlog.setRefObjectId(null);
        migrlog.setRefObjectType(null);
        if (list.size() > 0 && (iterator = list.get(0).getSourceObject()) instanceof PersistableObject) {
            PersistableObject object = (PersistableObject)((Object)iterator);
            migrlog.setRefObjectId(object.getKey());
            migrlog.setRefObjectType(object.getObjectType());
        }
        this.batchPersist(migrlog);
        if (list.size() == 1) {
            for (LogRecord logRecord2 : list.get(0).getChildRecords()) {
                this.insertLogRecursively(logRecord2, formatter);
            }
        }
    }

    private void batchPersist(Migrlog migrlog) {
        this._miglogs.add(migrlog);
        if (this._miglogs.size() >= 20) {
            this.saveLogs();
        }
    }

    private Connection getConn() {
        return this.getPersistenceManager().getConn();
    }

    private PersistenceManager getPersistenceManager() {
        return MigrationAddin.getLogPersistenceConnection();
    }

    private void saveLogs() {
        PersistLogTask persistLogTask = new PersistLogTask(this._miglogs);
        this._miglogs.clear();
        RaptorTaskManager.getInstance().addTask((RaptorTask)persistLogTask);
    }

    @Override
    public void publish(LogRecord logRecord) {
        this.insertLogRecursively(logRecord, this.getFormatter());
    }

    private String getPhase(LogRecord logRecord) {
        List<LogInfo> list = MigrationLogUtil.searchParameterByType(logRecord.getParameters(), LogInfo.class);
        String string = "";
        if (list.size() == 1) {
            string = list.get(0).getSourceDisplayString();
            return string;
        }
        return string;
    }

    private DBObjectId getProjectId(LogRecord logRecord) {
        List<LogInfo> list = MigrationLogUtil.searchParameterByType(logRecord.getParameters(), LogInfo.class);
        if (list.size() > 0) {
            for (Object object : list.get(0).getSupplementaryInfo()) {
                Object[] objectArray;
                if (!(object instanceof Object[]) || !(objectArray = (Object[])object)[0].equals("MigrationConnectionId")) continue;
                return (DBObjectId)objectArray[1];
            }
        }
        return null;
    }

    @Override
    public void close() throws SecurityException {
        this.saveLogs();
    }

    @Override
    public void flush() {
        this.saveLogs();
    }

    private class PersistLogTask
    extends DatabaseQueryTask<Void> {
        ArrayList<Migrlog> _mlogs;

        PersistLogTask(ArrayList<Migrlog> arrayList) {
            super("Save migration logs", IRaptorTaskRunMode.NO_GUI, false, false);
            this._mlogs = null;
            this._mlogs = (ArrayList)arrayList.clone();
        }

        protected Void doWork() throws TaskException {
            for (Migrlog migrlog : this._mlogs) {
                try {
                    migrlog.save(MigrationLogPersistenceHandler.this.getPersistenceManager());
                }
                catch (PersistenceException persistenceException) {
                    persistenceException.printStackTrace();
                }
                try {
                    MigrationLogPersistenceHandler.this.getPersistenceManager().commit();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            this._mlogs.clear();
            return null;
        }

        public String getConnectionName() {
            return Connections.getInstance().getConnectionName(MigrationLogPersistenceHandler.this.getConn());
        }

        public String getQuery() {
            return null;
        }
    }
}

