/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import javax.swing.tree.TreeNode;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.db.impl.DatabaseObjectTreeNode;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.util.IdeUtil;

public class MongoDBOfflineScriptInitiator
extends AbstractMenuAction
implements LayoutControl {
    static final String COLLECTIONNAMETAG = "<COLLECTION_NAME>";
    static final String DATABASENAMETAG = "<DATABASE_NAME>";
    static final String DATADIRTAG = "<DATA_DIR>";
    static final String EXPORTSTRHEADER = "REM dumps out direct as JSON";
    static final String EXPORTSTR = "mongoexport --db <DATABASE_NAME> --collection <COLLECTION_NAME> --out data/<COLLECTION_NAME>.json --journal";
    static final String EXPORTFILENAMEWIN = "unload.bat";
    static final String EXPORTFILENAMELINUX = "unload.sh";
    static final String IMPORTSCRIPTFILENAME = "load.sql";
    static final String IMPORTSCRIPTSQL = "@<COLLECTION_NAME>.sql";
    static final String DIRFILENAME = "mongodb_dat_dir.sql";
    static final String IMPORTSQL = "/oracle/dbtools/migration/workbench/core/mogo/offline_mongo.sql";
    static final String DIRSQL = "/oracle/dbtools/migration/workbench/core/mogo/mongodb_dat_dir.sql";
    static final String SQLEXT = ".sql";

    public void launch() {
        String string = null;
        String string2 = null;
        String string3 = this.getOutputPath();
        if (string3 == null) {
            return;
        }
        this.writeOracleDirScript(string3);
        Context context = this.getContext();
        NavigatorTreeNode navigatorTreeNode = NavigatorContext.getFirstNavigatorTreeNodeFromContext((Context)context);
        DatabaseConnection databaseConnection = (DatabaseConnection)this.getParentOfType((TreeNode)navigatorTreeNode, DatabaseConnection.class);
        try {
            string2 = ((Connection)databaseConnection.getConnection()).getCatalog();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Element[] elementArray = context.getSelection();
        if (elementArray[0] instanceof DatabaseConnection) {
            Element[] elementArray2 = NavigatorContext.getFirstNavigatorTreeNodeFromContext((Context)context);
            int n = elementArray2.getChildCount();
            if (n == 0) {
                // empty if block
            }
            if ((n = elementArray2.getChildCount()) != 0) {
                TreeNode treeNode = elementArray2.getFirstChild();
                Element element = new ArrayList();
                Enumeration<? extends TreeNode> enumeration = treeNode.children();
                while (enumeration.hasMoreElements()) {
                    element.add(((DatabaseObjectTreeNode)enumeration.nextElement()).getElement());
                }
                elementArray = element.toArray(new Element[element.size()]);
            }
        }
        this.writeStringToFile("@mongodb_dat_dir.sql", string3 + IMPORTSCRIPTFILENAME, null);
        for (Element element : elementArray) {
            if (element instanceof ObjectNode) {
                string = ((ObjectNode)element).getObjectName();
            }
            this.writeExport(string3, string, string2);
            this.writeImportMain(string3, string, string2);
            this.writeImport(string3, string, string2);
        }
    }

    private Object getParentOfType(TreeNode treeNode, Class<?> clazz) {
        if (treeNode == null) {
            return null;
        }
        if (treeNode instanceof NavigatorTreeNode) {
            if (((NavigatorTreeNode)treeNode).getUserObject().getClass() == clazz) {
                return ((NavigatorTreeNode)treeNode).getUserObject();
            }
            return this.getParentOfType(treeNode.getParent(), clazz);
        }
        return this.getParentOfType(treeNode.getParent(), clazz);
    }

    private void writeImportMain(String string, String string2, String string3) {
        String[][] stringArray = new String[][]{{COLLECTIONNAMETAG, string2}, {DATABASENAMETAG, string3}};
        this.writeStringToFile(IMPORTSCRIPTSQL, string + IMPORTSCRIPTFILENAME, stringArray);
    }

    private void writeOracleDirScript(String string) {
        String[][] stringArray = new String[][]{{DATADIRTAG, string}};
        this.writeFileToFile(DIRSQL, string + DIRFILENAME, stringArray);
    }

    private void writeExport(String string, String string2, String string3) {
        String[][] stringArray = new String[][]{{COLLECTIONNAMETAG, string2}, {DATABASENAMETAG, string3}};
        this.writeStringToFile(EXPORTSTR, string + EXPORTFILENAMEWIN, stringArray);
        this.writeStringToFile(EXPORTSTR, string + EXPORTFILENAMELINUX, stringArray);
    }

    private void writeImport(String string, String string2, String string3) {
        String[][] stringArray = new String[][]{{COLLECTIONNAMETAG, string2}, {DATABASENAMETAG, string3}};
        this.writeFileToFile(IMPORTSQL, string + string2 + SQLEXT, stringArray);
    }

    private void writeFileToFile(String string, String string2, String[][] stringArray) {
        this.writeStringToFile(this.URLToString(string), string2, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStringToFile(String string, String string2, String[][] stringArray) {
        OutputStreamWriter outputStreamWriter = null;
        try {
            String string3 = IdeUtil.getIdeEncoding();
            FileOutputStream fileOutputStream = new FileOutputStream(string2, true);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string3);
            String string4 = string;
            if (stringArray != null) {
                string4 = this.replaceStr(string, stringArray);
            }
            outputStreamWriter.write(string4 + "\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private String URLToString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    private String replaceStr(String string, String[][] stringArray) {
        if (stringArray == null) {
            return string;
        }
        for (String[] stringArray2 : stringArray) {
            String string2 = Matcher.quoteReplacement(stringArray2[1]);
            string = string.replaceAll(stringArray2[0], string2);
        }
        return string;
    }

    private String getOutputPath() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.setSelectionScope(1);
        uRLFileChooser.setCheckIfFileExists(true);
        int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), "Generate Offline MongoDB Data Move Scripts");
        if (n == -1) {
            return null;
        }
        String string = uRLFileChooser.getText();
        return string + File.separator;
    }
}

