/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.util.HashSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.dbtools.migration.workbench.core.MigrationRepositoryStateListener;

public class MigrationMenuManager
implements MigrationRepositoryStateListener {
    private HashSet<JMenuItem> m_itemsRequiringRepo = new HashSet();
    private boolean m_connected = false;
    private JMenu m_actualMenu;

    public MigrationMenuManager(JMenu jMenu) {
        this.m_actualMenu = jMenu;
    }

    public JMenuItem addMenuItem(JMenuItem jMenuItem, boolean bl, int n) {
        JMenuItem jMenuItem2 = n == -1 ? this.m_actualMenu.add(jMenuItem) : this.m_actualMenu.insert(jMenuItem, n);
        if (bl) {
            this.m_itemsRequiringRepo.add(jMenuItem);
            jMenuItem.setEnabled(this.m_connected);
        }
        return jMenuItem2;
    }

    private void refresh() {
        for (JMenuItem jMenuItem : this.m_itemsRequiringRepo) {
            jMenuItem.setEnabled(this.m_connected);
        }
    }

    @Override
    public void repositoryClosed() {
        this.m_connected = false;
        this.refresh();
    }

    @Override
    public void repositoryOpened(String string) {
        this.m_connected = true;
        this.refresh();
    }

    public void flagSubMenuItem(JMenuItem jMenuItem, boolean bl) {
        if (bl && !this.m_itemsRequiringRepo.contains(jMenuItem)) {
            this.m_itemsRequiringRepo.add(jMenuItem);
            jMenuItem.setEnabled(this.m_connected);
        }
    }
}

