/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationCmdRegistry;
import oracle.dbtools.migration.workbench.core.Messages;
import oracle.dbtools.migration.workbench.core.MigrationHook;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;

public class MigrationCmdHook {
    private static MigrationCmdHook INSTANCE;
    private static final Logger LOGGER;
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-migration-cmd";
    public static final String DESCRIPTOR_ID = "cmd";
    public static final String CMD_NAME = "name";
    public static final String CMD_CLASS = "clazz";
    public static final ElementName ELEMENT_NAME;
    private HashStructureHookListener s_listener;

    public static synchronized MigrationCmdHook getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MigrationCmdHook();
        }
        return INSTANCE;
    }

    public MigrationCmdHook() {
        this.initListener();
    }

    private synchronized void initListener() {
        if (this.s_listener == null) {
            HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
            this.s_listener = new Listener();
            hashStructureHook.addHashStructureHookListener(this.s_listener);
        }
    }

    static {
        LOGGER = Logger.getLogger(MigrationHook.class.getName());
        ELEMENT_NAME = new ElementName(NS, "sqldev-migration-cmd");
    }

    private final class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processCommands(hashStructureHookEvent.getNewElementHashStructure());
        }

        private void processCommands(HashStructure hashStructure) {
            List list = hashStructure.getAsList(MigrationCmdHook.DESCRIPTOR_ID);
            LOGGER.info(MessageFormat.format(Messages.getString("MigrationHook.0"), list.size()));
            for (HashStructure hashStructure2 : list) {
                String string = hashStructure2.getString(MigrationCmdHook.CMD_NAME);
                String string2 = hashStructure2.getString(MigrationCmdHook.CMD_CLASS);
                LazyClassAdapter lazyClassAdapter = LazyClassAdapter.getInstance((HashStructure)hashStructure2);
                MetaClass metaClass = lazyClassAdapter.getMetaClass(MigrationCmdHook.CMD_CLASS);
                MigrationCmdRegistry.registerCmdHook(string, string2, (MetaClass<? extends MigrationCmd>)metaClass);
                LOGGER.info(MessageFormat.format(Messages.getString("Registered Command Line: {0}"), string));
            }
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processCommands(hashStructureHookEvent.getCombinedHashStructure());
        }
    }
}

