/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.persistence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class Migrlog
extends PersistableObject {
    public static final String TABLE_NAME = "MIGRLOG";
    public static final String COLNAME_PARENT_LOG_ID = "PARENT_LOG_ID";
    public static final String COLNAME_LOG_DATE = "LOG_DATE";
    public static final String COLNAME_SEVERITY = "SEVERITY";
    public static final String COLNAME_LOGTEXT = "LOGTEXT";
    public static final String COLNAME_PHASE = "PHASE";
    public static final String COLNAME_REF_OBJECT_ID = "REF_OBJECT_ID";
    public static final String COLNAME_REF_OBJECT_TYPE = "REF_OBJECT_TYPE";
    public static final String COLNAME_CONNECTION_ID_FK = "CONNECTION_ID_FK";

    public Migrlog(Timestamp timestamp, Integer n) {
        this.setLogDate(timestamp);
        this.setSeverity(n);
    }

    public static Migrlog getExistingInstance(DBObjectId dBObjectId) {
        Migrlog migrlog = new Migrlog();
        migrlog.setKey(dBObjectId);
        return migrlog;
    }

    private Migrlog() {
    }

    public static Migrlog retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        Migrlog migrlog = Migrlog.getExistingInstance(dBObjectId);
        migrlog.retrieve(persistenceManager);
        return migrlog;
    }

    public void setParentLogId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_PARENT_LOG_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    protected void setLogDate(Timestamp timestamp) {
        Field field = new Field(COLNAME_LOG_DATE, "TIMESTAMP", false);
        field.setValue(timestamp);
        this.setField(field);
    }

    protected void setSeverity(Integer n) {
        Field field = new Field(COLNAME_SEVERITY, "INTEGER", false);
        field.setValue(n);
        this.setField(field);
    }

    public void setLogtext(String string) {
        Field field = new Field(COLNAME_LOGTEXT, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setPhase(String string) {
        Field field = new Field(COLNAME_PHASE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setRefObjectId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_REF_OBJECT_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setRefObjectType(String string) {
        Field field = new Field(COLNAME_REF_OBJECT_TYPE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setConnectionId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_CONNECTION_ID_FK, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public DBObjectId getParentLogId() {
        Field field = this.getField(COLNAME_PARENT_LOG_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Timestamp getLogDate() {
        Field field = this.getField(COLNAME_LOG_DATE);
        if (field == null) {
            return null;
        }
        return field.getTimestamp();
    }

    public Integer getSeverity() {
        Field field = this.getField(COLNAME_SEVERITY);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public String getLogtext() {
        Field field = this.getField(COLNAME_LOGTEXT);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getPhase() {
        Field field = this.getField(COLNAME_PHASE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getRefObjectId() {
        Field field = this.getField(COLNAME_REF_OBJECT_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public String getRefObjectType() {
        Field field = this.getField(COLNAME_REF_OBJECT_TYPE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getConnectionId() {
        Field field = this.getField(COLNAME_CONNECTION_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            Object object = new DBObjectId(resultSet.getLong(COLNAME_PARENT_LOG_ID));
            if (resultSet.wasNull()) {
                this.setParentLogId(null);
            } else {
                this.setParentLogId((DBObjectId)object);
            }
            this.setLogDate(resultSet.getTimestamp(COLNAME_LOG_DATE));
            this.setSeverity(resultSet.getInt(COLNAME_SEVERITY));
            object = resultSet.getString(COLNAME_LOGTEXT);
            if (resultSet.wasNull()) {
                this.setLogtext(null);
            } else {
                this.setLogtext((String)object);
            }
            object = resultSet.getString(COLNAME_PHASE);
            if (resultSet.wasNull()) {
                this.setPhase(null);
            } else {
                this.setPhase((String)object);
            }
            object = new DBObjectId(resultSet.getLong(COLNAME_REF_OBJECT_ID));
            if (resultSet.wasNull()) {
                this.setRefObjectId(null);
            } else {
                this.setRefObjectId((DBObjectId)object);
            }
            object = resultSet.getString(COLNAME_REF_OBJECT_TYPE);
            if (resultSet.wasNull()) {
                this.setRefObjectType(null);
            } else {
                this.setRefObjectType((String)object);
            }
            object = new DBObjectId(resultSet.getLong(COLNAME_CONNECTION_ID_FK));
            if (resultSet.wasNull()) {
                this.setConnectionId(null);
            } else {
                this.setConnectionId((DBObjectId)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

