/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MgvAllTablesRec;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.datamove.DataMoveDescriptor;
import oracle.dbtools.migration.datamove.DataMoveException;
import oracle.dbtools.migration.datamove.DataMoveMarshal;
import oracle.dbtools.migration.datamove.DataMoveUtils;
import oracle.dbtools.migration.datamove.offline.Messages;
import oracle.dbtools.migration.datamove.offline.streams.Offline3rdPartyDMSAbstract;
import oracle.dbtools.migration.datamove.offline.streams.OfflineDataMoveStream;
import oracle.dbtools.migration.datamove.online.DataMoveAudience;
import oracle.dbtools.migration.datamove.online.DataMoveEvent;
import oracle.dbtools.migration.datamove.online.DataMoveListener;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

public class OfflineDataMoveWorker
implements Cancelable,
DataMoveMarshal {
    private static Logger LOGGER = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    public static final String MY_ID = "OfflineDataMoveWorker";
    private CloseableIterator<MgvAllTablesRec> m_tables;
    private PersistenceManager m_persistenceManager;
    private PersistenceUtility m_persistenceUtility;
    private DBObjectId m_targetConnectionId;
    private DataMoveAudience m_audience;
    private MdConnection m_mdConnection;
    private Offline3rdPartyDMSAbstract thirdPartyPrintStream;
    private OfflineDataMoveStream stream;

    public OfflineDataMoveWorker(PersistenceManager persistenceManager, MdConnection mdConnection, String string, boolean bl) throws DataMoveException {
        this.setPersistenceManager(persistenceManager);
        this.setPersistenceUtility(PersistenceUtility.getInstance(persistenceManager));
        this.setTargetConnectionId(mdConnection.getKey());
        this.setTargetConnection(mdConnection);
        this.m_audience = new DataMoveAudience();
        this.stream = new OfflineDataMoveStream(string, bl, this.m_mdConnection, this.m_audience);
    }

    public OfflineDataMoveWorker(PersistenceManager persistenceManager, MdConnection mdConnection, String string) throws DataMoveException {
        this(persistenceManager, mdConnection, string, false);
    }

    private void setTargetConnection(MdConnection mdConnection) {
        this.m_mdConnection = mdConnection;
    }

    public void addListener(DataMoveListener dataMoveListener) {
        this.m_audience.addListener(dataMoveListener);
    }

    private void setTargetConnectionId(DBObjectId dBObjectId) {
        this.m_targetConnectionId = dBObjectId;
    }

    private void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() throws PersistenceException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        MdSchema mdSchema = null;
        MdCatalog mdCatalog = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.m_tables = this.getPersistenceUtility().getTablesForConnectionId(this.m_targetConnectionId);
        DataMoveDescriptor dataMoveDescriptor = null;
        DataMoveEvent dataMoveEvent = new DataMoveEvent(3, Messages.getString("OfflineDataMoveWorker.1"), Messages.getString("OfflineDataMoveWorker.2"));
        this.m_audience.fireListeners(dataMoveEvent);
        this.stream.start(this.m_mdConnection, this.m_persistenceManager);
        do {
            try {
                if (dataMoveDescriptor == null) {
                    dataMoveDescriptor = this.getDescriptor();
                }
                if (dataMoveDescriptor == null) break;
                this.stream.setDescriptor(dataMoveDescriptor);
                if (dataMoveDescriptor.getSourceTable() != null) {
                    mdSchema = MdSchema.retrieveExistingInstance(this.m_persistenceManager, dataMoveDescriptor.getTargetTable().getSchemaId());
                    String string5 = string3 = mdSchema != null ? mdSchema.getName() : null;
                }
                if (mdSchema != null) {
                    mdCatalog = MdCatalog.retrieveExistingInstance(this.m_persistenceManager, mdSchema.getCatalogId());
                    string = mdCatalog != null ? mdCatalog.getCatalogName() : null;
                }
                string = this.processSourceName(string);
                string3 = this.processSourceName(string3);
                if (string == null || !string.equals(string2)) {
                    if (string2 != null && string4 != null) {
                        this.stream.endDatabase();
                        bl = false;
                    }
                    this.stream.startDatabase(string, string3);
                    bl = true;
                }
                if (string3 == null || !string3.equals(string4)) {
                    if (string2 != null && string4 != null) {
                        this.stream.endSchema();
                        bl2 = false;
                    }
                    this.stream.startSchema(string, string3);
                    bl2 = true;
                }
                if (this.getPersistenceUtility().isDBObjectEnabled(dataMoveDescriptor.getTargetTable().getKey().getId())) {
                    this.stream.startTable(dataMoveDescriptor.getTargetTableName(true));
                    bl3 = true;
                    this.stream.endTable();
                }
                bl3 = false;
                dataMoveDescriptor = this.getDescriptor();
            }
            catch (NoSuchObjectException noSuchObjectException) {
                noSuchObjectException.printStackTrace();
                LOGGER.log(Level.WARNING, noSuchObjectException.getMessage());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                LOGGER.log(Level.WARNING, throwable.getMessage());
                dataMoveDescriptor = null;
            }
            finally {
                string2 = string;
                string4 = string3;
            }
        } while (dataMoveDescriptor != null);
        if (bl3) {
            this.stream.endTable();
        }
        if (bl2) {
            this.stream.endSchema();
        }
        if (bl) {
            this.stream.endDatabase();
        }
        this.stream.finished();
    }

    private String processSourceName(String string) {
        string = string.replaceAll(" ", "_");
        string = string.replaceAll(File.separator + File.separator, "_");
        return string;
    }

    protected PersistenceUtility getPersistenceUtility() {
        return this.m_persistenceUtility;
    }

    protected void setPersistenceUtility(PersistenceUtility persistenceUtility) {
        this.m_persistenceUtility = persistenceUtility;
    }

    @Override
    public void signalCancel() {
    }

    @Override
    public DataMoveDescriptor getDescriptor() {
        if (!this.m_tables.hasNext()) {
            return null;
        }
        MgvAllTablesRec mgvAllTablesRec = (MgvAllTablesRec)this.m_tables.next();
        try {
            DataMoveDescriptor dataMoveDescriptor = DataMoveUtils.loadDescriptor(this.m_persistenceManager, mgvAllTablesRec.getTableId(), this.m_targetConnectionId);
            return dataMoveDescriptor;
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable("OfflineDataMove.RETRIEVE_DESCRIPTOR_FAILED", Messages.getString("OfflineDataMoveWorker.12"), (Throwable)persistenceException);
            return null;
        }
    }
}

