/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.dbtools.migration.convert.DataTypeMappingRule;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.convert.ValidDataTypeSpecification;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSupportedDataTypesMap
implements SupportedDataTypesMap {
    private HashMap<DataTypeSpecification, ArrayList<DataTypeSpecification>> m_theMap;
    private List<ValidDataTypeSpecification> m_validDataTypes;

    public XMLSupportedDataTypesMap(InputStream inputStream) throws SAXException, IOException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(true);
        dOMParser.parse(inputStream);
        this.m_theMap = new HashMap();
        this.m_validDataTypes = new ArrayList<ValidDataTypeSpecification>();
        XMLDocument xMLDocument = dOMParser.getDocument();
        Node node = xMLDocument.getChildNodes().item(0);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            XMLNode[] xMLNodeArray;
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("DataTypeMapping")) continue;
            Node node3 = XMLHelper.getChildNode((Node)node2, (String)"sourceDataType");
            ArrayList<DataTypeSpecification> arrayList = new ArrayList<DataTypeSpecification>();
            DataTypeSpecification dataTypeSpecification = XMLSupportedDataTypesMap.parseDataTypeNode(node3);
            ValidDataTypeSpecification validDataTypeSpecification = this.parseValidityDataNode(node3);
            this.m_validDataTypes.add(validDataTypeSpecification);
            Node node4 = XMLHelper.getChildNode((Node)node2, (String)"targetTypeCollection");
            for (XMLNode xMLNode : xMLNodeArray = XMLHelper.getChildNodes((Node)node4, (String)"targetType")) {
                DataTypeSpecification dataTypeSpecification2 = XMLSupportedDataTypesMap.parseDataTypeNode((Node)xMLNode);
                arrayList.add(dataTypeSpecification2);
            }
            this.m_theMap.put(dataTypeSpecification, arrayList);
        }
    }

    private ValidDataTypeSpecification parseValidityDataNode(Node node) {
        String string;
        Object object;
        Object object2;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = XMLHelper.getAttributeNode((Node)node, (String)"name");
        Node node2 = XMLHelper.getChildNode((Node)node, (String)"precisionRange");
        if (node2 != null) {
            object2 = XMLHelper.getAttributeNode((Node)node2, (String)"max");
            object = XMLHelper.getAttributeNode((Node)node2, (String)"min");
            string = XMLHelper.getAttributeNode((Node)node2, (String)"nullable");
            if (object2 != null && ((String)object2).trim().length() > 0) {
                n = new Integer((String)object2);
            }
            if (object != null && ((String)object).trim().length() > 0) {
                n2 = new Integer((String)object);
            }
            if (string != null && string.trim().length() > 0) {
                bl = Boolean.parseBoolean(string);
            }
        }
        if ((object2 = XMLHelper.getChildNode((Node)node, (String)"scaleRange")) != null) {
            object = XMLHelper.getAttributeNode((Node)object2, (String)"max");
            string = XMLHelper.getAttributeNode((Node)object2, (String)"min");
            String string3 = XMLHelper.getAttributeNode((Node)object2, (String)"nullable");
            if (object != null && ((String)object).trim().length() > 0) {
                n3 = new Integer((String)object);
            }
            if (string != null && string.trim().length() > 0) {
                n4 = new Integer(string);
            }
            if (string3 != null && string3.trim().length() > 0) {
                bl2 = Boolean.parseBoolean(string3);
            }
        }
        object = new ValidDataTypeSpecification(string2);
        ((ValidDataTypeSpecification)object).setMaxPrecision(n);
        ((ValidDataTypeSpecification)object).setMaxScale(n3);
        ((ValidDataTypeSpecification)object).setMinPrecision(n2);
        ((ValidDataTypeSpecification)object).setMinScale(n4);
        ((ValidDataTypeSpecification)object).setPrecisionMandatory(bl);
        ((ValidDataTypeSpecification)object).setScaleMandatory(bl2);
        return object;
    }

    @Override
    public DataTypeMappingRule[] getRulesForDataType(DataTypeSpecification dataTypeSpecification) {
        DataTypeMappingRule[] dataTypeMappingRuleArray;
        if (this.m_theMap.containsKey(dataTypeSpecification)) {
            ArrayList<DataTypeSpecification> arrayList = this.m_theMap.get(dataTypeSpecification);
            dataTypeMappingRuleArray = new DataTypeMappingRule[arrayList.size()];
            int n = 0;
            for (DataTypeSpecification dataTypeSpecification2 : arrayList) {
                dataTypeMappingRuleArray[n++] = new DataTypeMappingRule(dataTypeSpecification, dataTypeSpecification2);
            }
        } else {
            dataTypeMappingRuleArray = new DataTypeMappingRule[]{new DataTypeMappingRule(dataTypeSpecification, dataTypeSpecification)};
        }
        return dataTypeMappingRuleArray;
    }

    @Override
    public DataTypeSpecification[] getSourceDataTypes() {
        Set<DataTypeSpecification> set = this.m_theMap.keySet();
        return set.toArray(new DataTypeSpecification[set.size()]);
    }

    private static DataTypeSpecification parseDataTypeNode(Node node) {
        String string = XMLHelper.getAttributeNode((Node)node, (String)"name");
        String string2 = XMLHelper.getAttributeNode((Node)node, (String)"precision");
        Integer n = string2 != null && string2.trim().length() > 0 ? new Integer(string2) : null;
        string2 = XMLHelper.getAttributeNode((Node)node, (String)"scale");
        Integer n2 = string2 != null && string2.trim().length() > 0 ? new Integer(string2) : null;
        DataTypeSpecification dataTypeSpecification = new DataTypeSpecification(string, n, n2);
        return dataTypeSpecification;
    }

    @Override
    public ValidDataTypeSpecification[] getValidDataTypes() {
        return this.m_validDataTypes.toArray(new ValidDataTypeSpecification[0]);
    }
}

