/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.convert.ObjectNameEntity;
import oracle.dbtools.migration.workbench.core.MigrationAddin;

public class ObjectIdentifierTranslationCache {
    private DBObjectId _convConnId;
    private static final int DEFAULT_MAX_CACHE_ENTRIES = 10000;
    private HashMap<ObjectNameEntity, ObjectNameEntity> _derivativeCache = new HashMap();
    private LinkedList<ObjectNameEntity> _fifoList = new LinkedList();
    private int _maxCacheEntries;
    private boolean _cacheComplete;
    private String ALL_CAPT_TO_CONV_NAMES_QUERY = "select capschemaname, conschemaname, capmainobjname, conmainobjname, capmainobjtype, conmainobjtype, capobjname, conobjname, capobjtype, conobjtype from  mgv_derived_details where conconnid = ? ";
    private String CAPT_TO_CONV_NAME_QUERY = "select conschemaname, conmainobjname, conmainobjtype, conobjname, conobjtype from  mgv_derived_details where conconnid = ? and capschemaname= ? and capmainobjtype = ? and capmainobjname = ? and capobjtype = ? and capobjname = ?";

    public synchronized ObjectNameEntity getTransformedObjectIdentifier(String string, String string2, String string3, String string4, String string5) throws PersistenceException {
        ObjectNameEntity objectNameEntity = null;
        ObjectNameEntity objectNameEntity2 = null;
        if (string != null && string2 != null && string3 != null && string4 != null && string5 != null && (objectNameEntity2 = this._derivativeCache.get(objectNameEntity = new ObjectNameEntity(string, string3, string2, string5, string4, false))) == null) {
            objectNameEntity2 = this.fetchTransformedObjectIdentifier(string, string2, string3, string4, string5);
        }
        return objectNameEntity2;
    }

    synchronized void purgeCache() {
        this._fifoList.clear();
        this._derivativeCache.clear();
    }

    ObjectIdentifierTranslationCache(DBObjectId dBObjectId) {
        this(dBObjectId, 10000);
    }

    ObjectIdentifierTranslationCache(DBObjectId dBObjectId, int n) {
        this._convConnId = dBObjectId;
        this._maxCacheEntries = n;
    }

    synchronized void initCache() throws PersistenceException {
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        ObjectNameEntity objectNameEntity = null;
        ObjectNameEntity objectNameEntity2 = null;
        Connection connection = persistenceManager.getConn();
        if (connection != null) {
            try {
                preparedStatement = connection.prepareStatement(this.ALL_CAPT_TO_CONV_NAMES_QUERY);
                preparedStatement.setLong(1, this._convConnId.getId());
                resultSet = preparedStatement.executeQuery();
                while (!this.cacheFull() && (this._cacheComplete = resultSet.next())) {
                    string = resultSet.getString(1);
                    string2 = resultSet.getString(2);
                    string3 = resultSet.getString(3);
                    string4 = resultSet.getString(4);
                    string5 = resultSet.getString(5);
                    string6 = resultSet.getString(6);
                    string7 = resultSet.getString(7);
                    string8 = resultSet.getString(8);
                    string9 = resultSet.getString(9);
                    string10 = resultSet.getString(10);
                    if (string == null || string2 == null || string3 == null || string4 == null || string5 == null || string6 == null || string7 == null || string8 == null || string9 == null || string10 == null) continue;
                    objectNameEntity = new ObjectNameEntity(string, string3, string5, string7, string9, false);
                    objectNameEntity2 = new ObjectNameEntity(string2, string4, string6, string8, string10, true);
                    this._derivativeCache.put(objectNameEntity, objectNameEntity2);
                    this._fifoList.add(objectNameEntity);
                }
            }
            catch (SQLException sQLException) {
                throw new PersistenceException(sQLException);
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private synchronized boolean cacheFull() {
        boolean bl = false;
        if (this._derivativeCache.size() >= this._maxCacheEntries) {
            bl = true;
        }
        return bl;
    }

    private synchronized ObjectNameEntity fetchTransformedObjectIdentifier(String string, String string2, String string3, String string4, String string5) throws PersistenceException {
        ObjectNameEntity objectNameEntity = null;
        ObjectNameEntity objectNameEntity2 = null;
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ObjectNameEntity objectNameEntity3 = null;
        Object var12_12 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        Connection connection = persistenceManager.getConn();
        if (!this._cacheComplete && connection != null) {
            try {
                preparedStatement = connection.prepareStatement(this.CAPT_TO_CONV_NAME_QUERY);
                preparedStatement.setLong(1, this._convConnId.getId());
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string2);
                preparedStatement.setString(4, string3);
                preparedStatement.setString(5, string4);
                preparedStatement.setString(6, string5);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string6 = resultSet.getString(1);
                    string7 = resultSet.getString(2);
                    string8 = resultSet.getString(3);
                    string9 = resultSet.getString(4);
                    string10 = resultSet.getString(5);
                    objectNameEntity3 = this._fifoList.removeFirst();
                    this._derivativeCache.remove(objectNameEntity3);
                    objectNameEntity3 = null;
                    objectNameEntity = new ObjectNameEntity(string, string3, string2, string5, string4, false);
                    objectNameEntity2 = new ObjectNameEntity(string6, string7, string8, string9, string10, true);
                    this._fifoList.add(objectNameEntity);
                    this._derivativeCache.put(objectNameEntity, objectNameEntity2);
                }
            }
            catch (SQLException sQLException) {
                throw new PersistenceException(sQLException);
            }
            finally {
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        return objectNameEntity2;
    }
}

