/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.util.HashMap;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.capture.ListCapturedModelsCmd;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationCmdRegistry;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.ConverterWorker;
import oracle.dbtools.migration.convert.DataTypeConversionMap;
import oracle.dbtools.migration.convert.ListConvertedModelsCmd;
import oracle.dbtools.migration.convert.Messages;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationFilterUtil;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.raptor.utils.Connections;

public class ConvertCmd
extends MigrationCmd {
    public static final String CMDNAME = "convert";
    private ConvertDetails m_convertDetails = null;

    public ConvertCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
        this.m_convertDetails = new ConvertDetails(migrationDetails);
    }

    @Override
    protected void executeImpl() throws CMDLineError {
        this.verifyRepository();
        this.runConvert(this.getCaptureDetails());
    }

    private ConvertDetails getCaptureDetails() {
        return this.m_convertDetails;
    }

    private void runConvert(ConvertDetails convertDetails) {
        ListCapturedModelsCmd listCapturedModelsCmd = null;
        Long l = null;
        MdConnection mdConnection = null;
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        DBObjectId dBObjectId = null;
        DBObjectId dBObjectId2 = null;
        DBObjectId dBObjectId3 = null;
        String string = "";
        MigrationPlugin migrationPlugin = null;
        SupportedDataTypesMap supportedDataTypesMap = null;
        ConverterWorker converterWorker = null;
        boolean bl = false;
        DataTypeConversionMap dataTypeConversionMap = null;
        try {
            Object object;
            Object object2;
            Object object3;
            String string2;
            if (persistenceManager == null) {
                string2 = MigrationAddin.getDefaultMigrationRepository();
                object3 = Connections.getInstance().getConnection(string2);
                MigrationAddin.openRepository(string2);
                persistenceManager = MigrationAddin.getPersistenceManager();
            }
            if (this.getMigrationDetails().getCurrentCapturedModel() == null) {
                int n = -1;
                listCapturedModelsCmd = (ListCapturedModelsCmd)MigrationCmdRegistry.getMigrationCmd("lscaptured", this.getMigrationDetails(), this.getCmdout(), true);
                listCapturedModelsCmd.execute();
                object3 = this.getMigrationDetails().get("model");
                if (listCapturedModelsCmd.hasSingleCapturedModel() || object3 != null && "latest".equalsIgnoreCase(((String)object3).trim())) {
                    l = listCapturedModelsCmd.getLatestCapturedModel();
                } else if (object3 != null) {
                    n = Integer.parseInt((String)object3);
                    l = listCapturedModelsCmd.getModelIdForIndex(n);
                } else if (!listCapturedModelsCmd.hasSingleCapturedModel() && object3 == null) {
                    listCapturedModelsCmd.printModelList();
                    n = this.getCmdout().promptForModelSelection();
                    l = listCapturedModelsCmd.getModelIdForIndex(n);
                } else {
                    throw new IllegalStateException("There are no valid captured models in the repository");
                }
                if (l != null) {
                    this.getMigrationDetails().setCurrentCaptureModel(Long.toString(l));
                } else {
                    throw new IllegalStateException("Unable to locate captured model corresponding to id: " + n);
                }
            }
            string2 = this.getMigrationDetails().getCurrentCapturedModel();
            dBObjectId = new DBObjectId(Long.parseLong(string2));
            mdConnection = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId);
            long l2 = 0L;
            if (mdConnection != null) {
                string = MigrationUtils.getPluginIdForConnection(mdConnection);
                dBObjectId3 = mdConnection.getProjectId();
                migrationPlugin = MigrationAddin.findPlugin(string);
                supportedDataTypesMap = migrationPlugin.getSupportedDataTypesMap();
                object2 = ConvertUtils.getMapForProjectId(persistenceManager, dBObjectId3);
                if (object2 == null) {
                    dataTypeConversionMap = ConvertUtils.getDefaultMapFromSupportedMap(supportedDataTypesMap);
                    dBObjectId2 = ConvertUtils.persistMap(persistenceManager, dBObjectId3, "SQLServerDataMap", dataTypeConversionMap);
                } else {
                    dBObjectId2 = ((PersistableObject)object2).getKey();
                }
                converterWorker = new ConverterWorker(persistenceManager, mdConnection.getKey(), migrationPlugin.getConverter(), dBObjectId2, MigrationFilterUtil.getFullFilter());
                bl = converterWorker.runConvert();
                object = new ListConvertedModelsCmd(this.getMigrationDetails(), this.getCmdout(), true);
                ((MigrationCmd)object).execute();
                l2 = ((ListConvertedModelsCmd)object).getLatestConvertedModel();
                this.getMigrationDetails().setCurrentConvertedModel(new Long(l2).toString());
            }
            if (this.getMigrationDetails().getCurrentConvertedModel() != null) {
                object2 = MigrationFilterUtil.getFullFilter();
                object = this.getMigrationDetails().getCurrentConvertedModel();
                DBObjectId dBObjectId4 = new DBObjectId(Long.parseLong((String)object));
                MdConnection mdConnection2 = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId4);
                ConverterWorker converterWorker2 = new ConverterWorker(persistenceManager, mdConnection.getKey(), migrationPlugin.getConverter(), null, (MigrationObjectFilterList)object2, mdConnection2);
                String[] stringArray = new String[]{"ALL_OBJECTS"};
                bl = converterWorker2.runTranslate(stringArray);
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        if (!bl) {
            this.getCmdout().printMessage(Messages.getString("ConvertFailed"));
        }
    }

    class ConvertDetails {
        MigrationDetails m_details = null;
        HashMap<Integer, Long> m_modelList = new HashMap();

        ConvertDetails(MigrationDetails migrationDetails) {
            this.m_details = migrationDetails;
        }

        public String getModel() {
            return this.m_details.get("model");
        }

        public boolean isRepositorySpecified() {
            return this.m_details.contains("repo");
        }

        public String getRepositorySpecified() {
            return this.getNameAndPassword(this.m_details.get("repo"))[0];
        }

        public boolean isRepositoryPasswordSpecified() {
            return this.isPasswordSpecified(this.m_details.get("repo"));
        }

        private boolean isPasswordSpecified(String string) {
            return string.indexOf("/") != -1;
        }

        private String[] getNameAndPassword(String string) {
            int n = string.indexOf("/");
            if (n == -1) {
                return new String[]{string, null};
            }
            return new String[]{string.substring(0, n), string.substring(n + 1)};
        }

        public String getRepositoryPassword() {
            return this.getNameAndPassword(this.m_details.get("repo"))[1];
        }

        public boolean isLogSpecified() {
            return this.m_details.contains("log");
        }

        public String getLog() {
            return this.m_details.get("log");
        }

        public boolean isValid() {
            if (this.isRepositorySpecified() && this.getRepositorySpecified() == null) {
                return false;
            }
            return !this.isLogSpecified() || this.getLog() != null;
        }
    }
}

