/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.sql.Connection;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.CMDUtil;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class RunSQLCmd
extends MigrationCmd {
    public static final String CMDNAME = "runsql";
    RunSQLDetails m_runSQLDetails = null;

    public RunSQLCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
        this.setupPreferences();
        this.m_runSQLDetails = new RunSQLDetails(migrationDetails);
        this.m_isPersistenceManagerRequired = false;
    }

    public RunSQLCmd(String string, String string2, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, null, cMDOut, bl);
        this.setupPreferences();
        this.m_runSQLDetails = new RunSQLDetails(string, string2);
    }

    private void setupPreferences() {
        Preferences preferences = Preferences.getPreferences();
        DBConfig dBConfig = DBConfig.getInstance((PropertyStorage)preferences);
        ResultSetFormatter.setMaxRows((int)4000);
    }

    @Override
    protected void executeImpl() throws CMDLineError {
        String string = null;
        if (this.m_runSQLDetails.isSQLFile()) {
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(this.m_runSQLDetails.getSQLFile());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            String string2 = Connections.getInstance().getConnectionName(this.m_runSQLDetails.getConnection());
            ScriptUtils.runAsScript((Reader)fileReader, (String)string2, null, (Boolean)true);
        } else {
            string = ScriptUtils.runSqlReturnResult((String)this.m_runSQLDetails.getSQLString(), (Connection)this.m_runSQLDetails.getConnection());
        }
        this.getCmdout().printResult(string);
    }

    private class RunSQLDetails {
        MigrationDetails m_md = null;
        String m_connName = null;
        String m_sql = null;

        public RunSQLDetails(MigrationDetails migrationDetails) {
            this.m_md = migrationDetails;
        }

        public RunSQLDetails(String string, String string2) {
            this.m_connName = string;
            this.m_sql = string2;
        }

        public String getSQLString() {
            if (this.m_sql == null) {
                this.m_sql = this.m_md.get("sql");
            }
            return this.m_sql;
        }

        public File getSQLFile() {
            if (this.isSQLFile()) {
                return new File(this.m_md.get("sql"));
            }
            return null;
        }

        public boolean isSQLFile() {
            String string = this.getSQLString();
            File file = new File(string);
            return file.isFile();
        }

        public Connection getConnection() throws CMDLineError {
            Connection connection = CMDUtil.getConnectionFromSimpleName(this.getConnectionName());
            return connection;
        }

        public String getConnectionName() {
            if (this.m_connName == null) {
                String[] stringArray = this.m_md.get("conn").split(",");
                if (stringArray != null && stringArray.length == 1) {
                    return stringArray[0];
                }
                this.m_connName = this.getSuperConnection(stringArray);
                if (this.m_connName == null) {
                    this.m_connName = this.getTargetConnection(stringArray);
                }
            }
            return this.m_connName;
        }

        private String getTargetConnection(String[] stringArray) {
            for (String string : stringArray) {
                if (!string.toLowerCase().startsWith("target")) continue;
                return string;
            }
            return null;
        }

        private String getSuperConnection(String[] stringArray) {
            for (String string : stringArray) {
                if (!string.toLowerCase().startsWith("super")) continue;
                return string;
            }
            return null;
        }
    }
}

