/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationCmdHelp;
import oracle.dbtools.migration.command_line.MigrationCmdRegistry;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeRunner;
import oracle.ide.IdeStarter;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.adapter.DatabaseProviderClassLoaderFactory;

public class MigrationCmdRunner
extends IdeRunner {
    private MigrationDetails m_migrationDetails = null;
    private CMDOut m_out = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCommand(IdeStarter ideStarter) {
        MigrationCmdRunner.setupSQLDeveloper();
        IdeArgs ideArgs = Ide.getIdeArgs();
        String[] stringArray = ideArgs.getArgs();
        this.m_migrationDetails = new MigrationDetails(stringArray);
        this.m_out = this.m_migrationDetails.getOut();
        if (this.m_migrationDetails.isValid()) {
            try {
                this.execute(this.m_migrationDetails);
            }
            catch (CMDLineError cMDLineError) {
                this.getOut().printError(cMDLineError);
                System.exit(1);
            }
            catch (Exception exception) {
                this.getOut().printError(exception);
                MigrationCmdHelp.help(this.m_migrationDetails, this.getOut());
                System.exit(1);
            }
            finally {
                this.m_out.close();
            }
            System.exit(0);
        } else {
            MigrationCmdHelp.help(this.m_migrationDetails, this.getOut());
            System.exit(1);
        }
    }

    private CMDOut getOut() {
        return this.m_out;
    }

    public static void setupSQLDeveloper() {
        DatabaseProvider.setClassLoaderFactory((DatabaseProviderClassLoaderFactory)new DatabaseProviderClassLoaderFactory(){

            public ClassLoader getClassLoader(String string) {
                return RaptorClassLoader.findClassLoader((String)string);
            }
        });
    }

    private void execute(MigrationDetails migrationDetails) throws Exception {
        MigrationCmd migrationCmd = null;
        String[] stringArray = null;
        boolean bl = false;
        if (migrationDetails != null) {
            stringArray = migrationDetails.getAllActionNames();
            if (migrationDetails.contains("help") || migrationDetails.contains("h")) {
                if (stringArray != null && stringArray.length > 0) {
                    MigrationCmdHelp.usages(stringArray, this.getOut());
                } else {
                    MigrationCmdHelp.help(migrationDetails, this.getOut());
                }
                return;
            }
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                bl = false;
                migrationCmd = MigrationCmdRegistry.getMigrationCmd(stringArray[i], migrationDetails, this.getOut(), this.isSilent());
                if (migrationCmd == null) {
                    throw new CMDLineError(stringArray[i], "Invalid Command", null);
                }
                migrationCmd.execute();
                bl = true;
            }
        }
    }

    private boolean isSilent() {
        return false;
    }
}

