/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationDetails;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;

public class MigrationCmdHelp {
    public static final String HELP = "help";

    public static void usages(String[] stringArray, CMDOut cMDOut) {
        StringTemplateGroup stringTemplateGroup = MigrationCmdHelp.getMigrCmdHelp();
        for (String string : stringArray) {
            try {
                stringTemplateGroup.lookupTemplate(string);
            }
            catch (Exception exception) {
                cMDOut.printError("There is no help for \"" + string + "\"");
                continue;
            }
            MigrationCmdHelp.print(string, stringTemplateGroup, cMDOut);
        }
    }

    public static void usage(String string, CMDOut cMDOut) {
        MigrationCmdHelp.print(string, MigrationCmdHelp.getMigrCmdHelp(), cMDOut);
    }

    public static void help(MigrationDetails migrationDetails, CMDOut cMDOut) {
        MigrationCmdHelp.print(HELP, MigrationCmdHelp.getMigrCmdHelp(), cMDOut);
        migrationDetails.printRegisteredActions();
    }

    private static StringTemplateGroup getMigrCmdHelp() {
        Thread.currentThread().setContextClassLoader(MigrationCmdHelp.class.getClassLoader());
        CommonGroupLoader commonGroupLoader = new CommonGroupLoader("oracle/dbtools/migration/command_line/templates", null);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)commonGroupLoader);
        StringTemplateGroup.registerDefaultLexer(DefaultTemplateLexer.class);
        StringTemplateGroup stringTemplateGroup = StringTemplateGroup.loadGroup((String)"MigrationCmdHelp");
        return stringTemplateGroup;
    }

    private static void print(String string, StringTemplateGroup stringTemplateGroup, CMDOut cMDOut) {
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf(string);
        cMDOut.printHelp(stringTemplate.toString());
    }
}

