/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.CMDUtil;
import oracle.dbtools.migration.command_line.ConnectionDetails;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.raptor.utils.Connections;

public class ListConnCmd
extends MigrationCmd {
    public static final String m_cmdName = "lsconn";

    public ListConnCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(m_cmdName, migrationDetails, cMDOut, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void executeImpl() {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray = Connections.getInstance().getConnNames();
        HashMap<Object, DatabaseGroup> hashMap = new HashMap<Object, DatabaseGroup>();
        for (String string : stringArray) {
            DatabaseGroup databaseGroup;
            Connections.getInstance();
            String string2 = Connections.getDisplayName((String)string);
            object3 = Connections.getInstance().getConnectionInfo(string);
            object2 = ((Properties)object3).getProperty("driver");
            object = new DatabaseDetails(string2, (Properties)object3);
            if (hashMap.containsKey(object2)) {
                databaseGroup = (DatabaseGroup)hashMap.get(object2);
                databaseGroup.add((DatabaseDetails)object);
                continue;
            }
            databaseGroup = new DatabaseGroup((String)object2);
            databaseGroup.add((DatabaseDetails)object);
            hashMap.put(object2, databaseGroup);
        }
        String string = "";
        try {
            String string3 = CMDUtil.getRepositoryConnectionName();
        }
        catch (CMDLineError cMDLineError) {
            // empty catch block
        }
        for (DatabaseGroup databaseGroup : hashMap.values()) {
            this.getCmdout().printResult(" ");
            for (DatabaseDetails databaseDetails : databaseGroup.getList()) {
                void var3_7;
                object3 = databaseDetails.getDisplayName();
                object2 = databaseDetails.getProperties();
                object = "";
                Connections.getInstance();
                String string4 = Connections.getConnectionName((String)var3_7);
                if (((String)object3).equals(string4)) {
                    object = "* ";
                }
                this.getCmdout().printResult((String)object + (String)object3 + " : " + this.formatURL((Properties)object2, (String)object3));
            }
        }
    }

    private String formatURL(Properties properties, String string) {
        ConnectionDetails connectionDetails = new ConnectionDetails();
        connectionDetails.setConnName(string);
        connectionDetails.setUsername(properties.getProperty("user"));
        connectionDetails.setPassword("********");
        connectionDetails.setHost(properties.getProperty("hostname"));
        connectionDetails.setPort(properties.getProperty("port"));
        connectionDetails.setSid(properties.getProperty("sid"));
        connectionDetails.setSysdba(properties.getProperty("role") != null && !properties.getProperty("role").trim().equals(""));
        if (properties.getProperty("driver").toLowerCase().indexOf("oracle") != -1) {
            connectionDetails.setDbType("oracle");
        } else if (properties.getProperty("customUrl").toLowerCase().indexOf("sybase") != -1) {
            connectionDetails.setDbType("sybase");
            int n = properties.getProperty("customUrl").lastIndexOf("/");
            String string2 = properties.getProperty("customUrl").substring(n + 1);
            connectionDetails.setService(string2);
        } else if (properties.getProperty("customUrl").toLowerCase().indexOf("sqlserver") != -1) {
            connectionDetails.setDbType("sqlserver");
            int n = properties.getProperty("customUrl").lastIndexOf("/");
            String string3 = properties.getProperty("customUrl").substring(n + 1);
            connectionDetails.setService(string3);
        }
        return connectionDetails.getUrlFormat();
    }

    private class DatabaseGroup {
        String m_group = null;
        ArrayList<DatabaseDetails> m_list = new ArrayList();

        public DatabaseGroup(String string) {
            this.m_group = string;
        }

        public void add(DatabaseDetails databaseDetails) {
            this.m_list.add(databaseDetails);
        }

        public ArrayList<DatabaseDetails> getList() {
            return this.m_list;
        }
    }

    private class DatabaseDetails {
        String m_displayName = null;
        Properties m_connProp = null;

        public DatabaseDetails(String string, Properties properties) {
            this.m_displayName = string;
            this.m_connProp = properties;
        }

        public String getDisplayName() {
            return this.m_displayName;
        }

        public Properties getProperties() {
            return this.m_connProp;
        }
    }
}

