/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLPath;

public class DriverCmd
extends MigrationCmd {
    public static final String CMDNAME = "driver";
    DriverDetails m_driverDetails = null;

    public DriverCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
        this.m_isPersistenceManagerRequired = false;
        this.m_driverDetails = new DriverDetails(migrationDetails);
    }

    @Override
    protected void executeImpl() throws CMDLineError {
        DBConfig dBConfig = DBConfig.getInstance();
        URL[] uRLArray = dBConfig.getThirdPartyPath().getEntries();
        URL[] uRLArray2 = this.m_driverDetails.getDriverPaths();
        String[] stringArray = this.m_driverDetails.getDriverNormalPaths();
        this.onlyAllowFilesWhichExist(stringArray);
        uRLArray2 = this.onlyAllowNewDrivers(uRLArray, uRLArray2);
        URLPath uRLPath = new URLPath(uRLArray);
        uRLPath.add(uRLArray2);
        dBConfig.setThirdPartyPath(uRLPath);
        try {
            Preferences.getPreferences().save();
            this.getCmdout().printResult("Driver Preferences Saved");
        }
        catch (IOException iOException) {
            throw new CMDLineError(CMDNAME, "Problem saving preferences", iOException);
        }
    }

    private void onlyAllowFilesWhichExist(String[] stringArray) throws CMDLineError {
        for (String string : stringArray) {
            File file = new File(string);
            if (file.exists()) continue;
            throw new CMDLineError(CMDNAME, "File does not exist:" + string, null);
        }
    }

    private URL[] onlyAllowNewDrivers(URL[] uRLArray, URL[] uRLArray2) throws CMDLineError {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URL uRL : uRLArray2) {
            boolean bl = false;
            for (URL uRL2 : uRLArray) {
                if (!uRL.getPath().equalsIgnoreCase(uRL2.getPath())) continue;
                this.getCmdout().printMessage("Warning:" + uRL.getPath() + " already exists");
                bl = true;
            }
            if (bl) continue;
            arrayList.add(uRL);
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    private class DriverDetails {
        MigrationDetails m_details = null;

        DriverDetails(MigrationDetails migrationDetails) {
            this.m_details = migrationDetails;
        }

        public String[] getDriverNormalPaths() {
            String string = this.m_details.get("files");
            String[] stringArray = string.split(",");
            return stringArray;
        }

        public URL[] getDriverPaths() {
            String string = this.m_details.get("files");
            String[] stringArray = string.split(",");
            URL[] uRLArray = new URL[stringArray.length];
            int n = 0;
            for (String string2 : stringArray) {
                string2 = string2.replace('\\', '/');
                try {
                    URL uRL;
                    if (!string2.startsWith("/")) {
                        string2 = "/" + string2;
                    }
                    uRLArray[n] = uRL = new URL("jar:file:" + string2 + "!/");
                }
                catch (MalformedURLException malformedURLException) {
                    DriverCmd.this.getCmdout().printError("Problems adding driver:" + string2);
                }
                ++n;
            }
            return uRLArray;
        }
    }
}

