/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import java.io.PrintStream;
import java.sql.ResultSetMetaData;
import java.util.concurrent.TimeUnit;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.Messages;

public class CMDOut {
    boolean[] m_isSilent = null;
    static PrintStream[] m_standardStream = null;
    static PrintStream[] m_errorStream = null;

    public CMDOut(boolean[] blArray, PrintStream[] printStreamArray, PrintStream[] printStreamArray2) {
        this.m_isSilent = blArray;
        m_standardStream = printStreamArray;
        m_errorStream = printStreamArray2;
    }

    public CMDOut(boolean bl, PrintStream printStream, PrintStream printStream2) {
        this.m_isSilent = new boolean[]{bl};
        m_standardStream = new PrintStream[]{printStream};
        m_errorStream = new PrintStream[]{printStream2};
    }

    public void printMessage(String string) {
        this.printStandard(string);
    }

    public void printError(String string) {
        for (int i = 0; i < m_errorStream.length; ++i) {
            PrintStream printStream = m_errorStream[i];
            if (this.m_isSilent[i]) continue;
            printStream.println(string);
        }
    }

    private void printStandard(String string) {
        for (int i = 0; i < m_standardStream.length; ++i) {
            PrintStream printStream = m_standardStream[i];
            if (this.m_isSilent[i]) continue;
            printStream.println(string);
        }
    }

    public void printPrompt(String string) {
        this.printStandard(string);
    }

    public void printHelp(String string) {
        this.printStandard(string);
    }

    public void printResult(String string) {
        this.printStandard(string);
    }

    public void printTableStructure(ResultSetMetaData resultSetMetaData) {
        try {
            int n = resultSetMetaData.getColumnCount();
            this.printResult(resultSetMetaData.getTableName(1) + "(");
            for (int i = 1; i <= n; ++i) {
                this.printResult(resultSetMetaData.getColumnName(i) + " " + resultSetMetaData.getColumnTypeName(i) + ",");
            }
            this.printResult(")\n");
        }
        catch (Exception exception) {
            this.printError(exception);
        }
    }

    public int promptForModelSelection() {
        int n = -1;
        String string = System.console().readLine(" > Supply The model number: ", new Object[]{null});
        n = Integer.parseInt(string);
        return n;
    }

    protected void reportDuration(long l, long l2, String string) {
        long l3 = l2 - l;
        String string2 = String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(l3), TimeUnit.MILLISECONDS.toSeconds(l3) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(l3)));
        this.printMessage(string + " " + Messages.getString("Time") + " = " + string2);
    }

    public void printError(CMDLineError cMDLineError) {
        String string = cMDLineError.getMessage();
        String string2 = cMDLineError.getCmd();
        Exception exception = cMDLineError.getException();
        String string3 = this.getExceptionSummary(exception);
        StringBuffer stringBuffer = new StringBuffer("Error");
        if (string2 != null) {
            stringBuffer.append(":" + string2);
        }
        if (string != null) {
            stringBuffer.append(":" + string);
        }
        if (string3 != null) {
            stringBuffer.append(":" + string3);
        }
        this.printError(stringBuffer.toString());
    }

    public void printError(Exception exception) {
        String string = this.getExceptionSummary(exception);
        this.printError("Error:" + string);
    }

    protected String getExceptionSummary(Exception exception) {
        if (exception == null) {
            return null;
        }
        String string = exception.getMessage();
        return string;
    }

    public void close() {
        for (PrintStream printStream : m_standardStream) {
            printStream.flush();
            printStream.close();
        }
        for (PrintStream printStream : m_errorStream) {
            printStream.flush();
            printStream.close();
        }
    }
}

