/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.CMDUtil;
import oracle.dbtools.migration.command_line.Messages;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.migration.command_line.MigrationRepositoryLister;
import oracle.dbtools.raptor.utils.Connections;

public abstract class AbstractMigrationRepositoryModelListerCmd
extends MigrationCmd
implements MigrationRepositoryLister {
    private LinkedHashMap<Integer, Long> m_modelList = new LinkedHashMap();
    private ArrayList<MigrationModelEntity> _mme = new ArrayList();
    private StringBuffer modelChoices;

    protected AbstractMigrationRepositoryModelListerCmd(String string, MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(string, migrationDetails, cMDOut, bl);
    }

    public abstract String getModelListQuery();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator list() {
        String string = null;
        this.modelChoices = new StringBuffer();
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            String string2 = this.getModelListQuery();
            String string3 = CMDUtil.getRepositoryConnectionName();
            Connection connection = Connections.getInstance().getConnection(string3);
            if (connection == null) {
                this.getCmdout().printMessage(Messages.getString("NoRepos"));
            } else {
                statement = connection.prepareStatement(string2);
                resultSet = statement.executeQuery();
                String string4 = "";
                while (resultSet.next()) {
                    String string5 = "";
                    ++n;
                    String string6 = resultSet.getString("name");
                    long l = resultSet.getLong("id");
                    if (this.getMigrationDetails().contains("model")) {
                        String string7 = this.getMigrationDetails().get("model");
                        if (string7 == null || string7.equalsIgnoreCase("all")) {
                            string5 = this.getModelInfo(resultSet);
                        } else if (string7.equalsIgnoreCase("latest")) {
                            string4 = this.getModelInfo(resultSet);
                        } else {
                            String[] stringArray;
                            for (String string8 : stringArray = string7.split(",")) {
                                int n2 = new Integer(string8);
                                if (n2 != n) continue;
                                string5 = this.getModelInfo(resultSet);
                            }
                        }
                    }
                    this._mme.add(new MigrationModelEntity(string6, l));
                    string = "(" + n + ") --> Model Name : " + string6 + "\n";
                    this.modelChoices.append(string + string5);
                    this.m_modelList.put(n, l);
                }
                this.modelChoices.append(string4);
            }
        }
        catch (Exception exception) {
            this.getCmdout().printError(exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                this.getCmdout().printError(exception);
            }
        }
        return this._mme.iterator();
    }

    private String getModelInfo(ResultSet resultSet) throws CMDLineError {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("\t\tDatabases:" + resultSet.getInt("NUM_CATALOGS") + "\n");
            stringBuffer.append("\t\tUsers:" + resultSet.getInt("NUM_SCHEMAS") + "\n");
            stringBuffer.append("\t\tTables:" + resultSet.getInt("NUM_TABLES") + "\n");
            stringBuffer.append("\t\tColumns:" + resultSet.getInt("NUM_COLUMNS") + "\n");
            stringBuffer.append("\t\tConstraints:" + resultSet.getInt("NUM_CONSTRAINTS") + "\n");
            stringBuffer.append("\t\tIndexes:" + resultSet.getInt("NUM_INDEXES") + "\n");
            stringBuffer.append("\t\tViews:" + resultSet.getInt("NUM_VIEWS") + "\n");
            stringBuffer.append("\t\tProcedures:" + resultSet.getInt("NUM_STORED_PROGRAMS") + "\n");
            stringBuffer.append("\t\tTriggers:" + resultSet.getInt("NUM_TRIGGERS") + "\n");
            stringBuffer.append("\t\t*Customized Indentifiers: Yes/No\n");
        }
        catch (Exception exception) {
            throw new CMDLineError(this.getName(), "Problem retrieving model information", exception);
        }
        return stringBuffer.toString();
    }

    public int getModelCount() {
        return this._mme.size();
    }

    public void printModelList() {
        if (!this.isSilent() && this.modelChoices != null) {
            this.getCmdout().printPrompt(this.modelChoices.toString());
        }
    }

    public Long getModelIdForIndex(int n) {
        return this.m_modelList.get(n);
    }

    public class MigrationModelEntity {
        private String _name;
        private Long _connectionId;

        public MigrationModelEntity(String string, Long l) {
            this._name = string;
            this._connectionId = l;
        }

        public String getMigrationModelName() {
            return this._name;
        }

        public Long getMigrationModelId() {
            return this._connectionId;
        }
    }
}

