/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;

public class SchemaTableTriggersIterator
extends PersistableObjectIterator {
    private static final String QUERY_GET_TABLE_TRIGGERS = "SELECT ID FROM MD_TRIGGERS WHERE TRIGGER_ON_FLAG = 'T' AND TABLE_OR_VIEW_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE SCHEMA_ID = ?)";
    private DBObjectId m_schemaId;
    private MigrationObjectFilter m_filter = null;

    public SchemaTableTriggersIterator(PersistenceManager persistenceManager, DBObjectId dBObjectId, MigrationObjectFilterList migrationObjectFilterList) {
        super(MdTrigger.class, persistenceManager);
        this.m_schemaId = dBObjectId;
        if (migrationObjectFilterList != null) {
            this.m_filter = migrationObjectFilterList.getFilterForType("MD_TRIGGERS");
        }
    }

    @Override
    protected PreparedStatement getPreparedStatement() throws SQLException {
        String string = QUERY_GET_TABLE_TRIGGERS;
        if (this.m_filter != null) {
            string = string + " AND " + this.m_filter.toWhereConditionForMigrationRepository();
        }
        PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement(string);
        preparedStatement.setLong(1, this.m_schemaId.getId());
        return preparedStatement;
    }
}

