/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdUserPrivilege
extends PersistableObject {
    public static final String TABLE_NAME = "MD_USER_PRIVILEGES";
    public static final String COLNAME_USER_ID_FK = "USER_ID_FK";
    public static final String COLNAME_PRIVILEGE_ID_FK = "PRIVILEGE_ID_FK";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UDPATED_BY = "LAST_UDPATED_BY";

    public MdUserPrivilege(DBObjectId dBObjectId) {
        this.setUserId(dBObjectId);
    }

    public static MdUserPrivilege getExistingInstance(DBObjectId dBObjectId) {
        MdUserPrivilege mdUserPrivilege = new MdUserPrivilege();
        mdUserPrivilege.setKey(dBObjectId);
        return mdUserPrivilege;
    }

    private MdUserPrivilege() {
    }

    public static MdUserPrivilege retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdUserPrivilege mdUserPrivilege = MdUserPrivilege.getExistingInstance(dBObjectId);
        mdUserPrivilege.retrieve(persistenceManager);
        return mdUserPrivilege;
    }

    protected void setUserId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_USER_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setPrivilegeId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_PRIVILEGE_ID_FK, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setLastUpdatedOn(Date date) {
        Field field = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setLastUdpatedBy(String string) {
        Field field = new Field(COLNAME_LAST_UDPATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public DBObjectId getUserId() {
        Field field = this.getField(COLNAME_USER_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public DBObjectId getPrivilegeId() {
        Field field = this.getField(COLNAME_PRIVILEGE_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getLastUpdatedOn() {
        Field field = this.getField(COLNAME_LAST_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getLastUdpatedBy() {
        Field field = this.getField(COLNAME_LAST_UDPATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            this.setUserId(new DBObjectId(resultSet.getLong(COLNAME_USER_ID_FK)));
            Object object = new DBObjectId(resultSet.getLong(COLNAME_PRIVILEGE_ID_FK));
            if (resultSet.wasNull()) {
                this.setPrivilegeId(null);
            } else {
                this.setPrivilegeId((DBObjectId)object);
            }
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_CREATED_BY);
            if (resultSet.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_LAST_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_LAST_UDPATED_BY);
            if (resultSet.wasNull()) {
                this.setLastUdpatedBy(null);
            } else {
                this.setLastUdpatedBy((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

