/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdUserDefinedDataType
extends PersistableObject {
    public static final String TABLE_NAME = "MD_USER_DEFINED_DATA_TYPES";
    public static final String COLNAME_SCHEMA_ID_FK = "SCHEMA_ID_FK";
    public static final String COLNAME_DATA_TYPE_NAME = "DATA_TYPE_NAME";
    public static final String COLNAME_DEFINITION = "DEFINITION";
    public static final String COLNAME_NATIVE_SQL = "NATIVE_SQL";
    public static final String COLNAME_NATIVE_KEY = "NATIVE_KEY";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";
    public static final String COLNAME_COMMENTS = "COMMENTS";

    public MdUserDefinedDataType(DBObjectId dBObjectId, String string, String string2, ClobHelper clobHelper) {
        this.setSchemaId(dBObjectId);
        this.setDataTypeName(string);
        this.setDefinition(string2);
        this.setNativeSql(clobHelper);
    }

    public static MdUserDefinedDataType getExistingInstance(DBObjectId dBObjectId) {
        MdUserDefinedDataType mdUserDefinedDataType = new MdUserDefinedDataType();
        mdUserDefinedDataType.setKey(dBObjectId);
        return mdUserDefinedDataType;
    }

    private MdUserDefinedDataType() {
    }

    public static MdUserDefinedDataType retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdUserDefinedDataType mdUserDefinedDataType = MdUserDefinedDataType.getExistingInstance(dBObjectId);
        mdUserDefinedDataType.retrieve(persistenceManager);
        return mdUserDefinedDataType;
    }

    protected void setSchemaId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SCHEMA_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    protected void setDataTypeName(String string) {
        Field field = new Field(COLNAME_DATA_TYPE_NAME, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    protected void setDefinition(String string) {
        Field field = new Field(COLNAME_DEFINITION, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    protected void setNativeSql(String string) {
        Field field = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        ClobHelper clobHelper = new ClobHelper(string);
        field.setValue(clobHelper);
        this.setField(field);
    }

    protected void setNativeSql(ClobHelper clobHelper) {
        Field field = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        field.setValue(clobHelper);
        this.setField(field);
    }

    public void setNativeKey(String string) {
        Field field = new Field(COLNAME_NATIVE_KEY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setLastUpdatedOn(Date date) {
        Field field = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setLastUpdatedBy(String string) {
        Field field = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setComments(String string) {
        Field field = new Field(COLNAME_COMMENTS, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public DBObjectId getSchemaId() {
        Field field = this.getField(COLNAME_SCHEMA_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public String getDataTypeName() {
        Field field = this.getField(COLNAME_DATA_TYPE_NAME);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getDefinition() {
        Field field = this.getField(COLNAME_DEFINITION);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public ClobHelper getNativeSql() {
        Field field = this.getField(COLNAME_NATIVE_SQL);
        if (field == null) {
            return null;
        }
        return field.getClobHelper();
    }

    public String getNativeKey() {
        Field field = this.getField(COLNAME_NATIVE_KEY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getLastUpdatedOn() {
        Field field = this.getField(COLNAME_LAST_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getLastUpdatedBy() {
        Field field = this.getField(COLNAME_LAST_UPDATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getComments() {
        Field field = this.getField(COLNAME_COMMENTS);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            this.setSchemaId(new DBObjectId(resultSet.getLong(COLNAME_SCHEMA_ID_FK)));
            this.setDataTypeName(resultSet.getString(COLNAME_DATA_TYPE_NAME));
            this.setDefinition(resultSet.getString(COLNAME_DEFINITION));
            this.setNativeSql(new ClobHelper(resultSet.getClob(COLNAME_NATIVE_SQL)));
            Object object = resultSet.getString(COLNAME_NATIVE_KEY);
            if (resultSet.wasNull()) {
                this.setNativeKey(null);
            } else {
                this.setNativeKey((String)object);
            }
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_CREATED_BY);
            if (resultSet.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_LAST_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_LAST_UPDATED_BY);
            if (resultSet.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)object);
            }
            object = resultSet.getString(COLNAME_COMMENTS);
            if (resultSet.wasNull()) {
                this.setComments(null);
            } else {
                this.setComments((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    public String getObjectName() {
        return this.getDataTypeName();
    }

    @Override
    public String getObjectNameFieldName() {
        return COLNAME_DATA_TYPE_NAME;
    }

    public void rename(String string) {
        this.setDataTypeName(string);
    }

    @Override
    public String getContainerFieldName() {
        return COLNAME_SCHEMA_ID_FK;
    }

    @Override
    public DBObjectId getContainerId() {
        return this.getSchemaId();
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

