/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.ide.util.Assert;

public class MdIdentityColumn
extends MdColumn {
    public static final String PROPERTY_SEED = "SEEDVALUE";
    public static final String PROPERTY_INCREMENT = "INCREMENT";
    public static final String PROPERTY_LASTVALUE = "LASTVALUE";
    public static final String PROPERTY_REALIDENTITY = "REALIDENTITY";

    public MdIdentityColumn(DBObjectId dBObjectId, String string, Integer n, long l, DBObjectId dBObjectId2) {
        super(dBObjectId, string, n);
        this.addProperty(PROPERTY_SEED, Long.toString(l), dBObjectId2);
    }

    public MdIdentityColumn(DBObjectId dBObjectId, String string, Integer n, long l, long l2, DBObjectId dBObjectId2) {
        this(dBObjectId, string, n, l, dBObjectId2);
        this.addProperty(PROPERTY_INCREMENT, Long.toString(l2), dBObjectId2);
    }

    public MdIdentityColumn(DBObjectId dBObjectId, String string, Integer n, long l, long l2, long l3, DBObjectId dBObjectId2) {
        this(dBObjectId, string, n, l, l2, dBObjectId2);
        this.addProperty(PROPERTY_LASTVALUE, Long.toString(l3), dBObjectId2);
    }

    public Long getSeed() {
        String string = this.getProperty(PROPERTY_SEED);
        if (string != null) {
            try {
                return new Long(string);
            }
            catch (NumberFormatException numberFormatException) {
                Assert.println((String)("Warning: Seed value is not a number " + string));
                return null;
            }
        }
        return null;
    }

    public Long getIncrement() {
        String string = this.getProperty(PROPERTY_INCREMENT);
        if (string != null) {
            try {
                return new Long(string);
            }
            catch (NumberFormatException numberFormatException) {
                Assert.println((String)("Warning: Increment value is not a number " + string));
                return null;
            }
        }
        return null;
    }

    public Long getLastValue() {
        String string = this.getProperty(PROPERTY_LASTVALUE);
        if (string != null) {
            try {
                return new Long(string);
            }
            catch (NumberFormatException numberFormatException) {
                Assert.println((String)("Warning: Increment value is not a number " + string));
                return null;
            }
        }
        return null;
    }

    public boolean hasSeed() {
        return this.getSeed() != null;
    }

    public boolean hasIncrement() {
        return this.getIncrement() != null;
    }

    public boolean hasLastValue() {
        return this.getLastValue() != null;
    }
}

