/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdConstraintDetail
extends PersistableObject {
    public static final String TABLE_NAME = "MD_CONSTRAINT_DETAILS";
    public static final String COLNAME_REF_FLAG = "REF_FLAG";
    public static final String COLNAME_CONSTRAINT_ID_FK = "CONSTRAINT_ID_FK";
    public static final String COLNAME_COLUMN_ID_FK = "COLUMN_ID_FK";
    public static final String COLNAME_COLUMN_PORTION = "COLUMN_PORTION";
    public static final String COLNAME_CONSTRAINT_TEXT = "CONSTRAINT_TEXT";
    public static final String COLNAME_DETAIL_ORDER = "DETAIL_ORDER";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";

    public MdConstraintDetail(DBObjectId dBObjectId, Integer n) {
        this.setConstraintId(dBObjectId);
        this.setDetailOrder(n);
    }

    public static MdConstraintDetail getExistingInstance(DBObjectId dBObjectId) {
        MdConstraintDetail mdConstraintDetail = new MdConstraintDetail();
        mdConstraintDetail.setKey(dBObjectId);
        return mdConstraintDetail;
    }

    private MdConstraintDetail() {
    }

    public static MdConstraintDetail retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdConstraintDetail mdConstraintDetail = MdConstraintDetail.getExistingInstance(dBObjectId);
        mdConstraintDetail.retrieve(persistenceManager);
        return mdConstraintDetail;
    }

    public void setRefFlag(String string) {
        Field field = new Field(COLNAME_REF_FLAG, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    protected void setConstraintId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_CONSTRAINT_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setColumnId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_COLUMN_ID_FK, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setColumnPortion(Integer n) {
        Field field = new Field(COLNAME_COLUMN_PORTION, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setConstraintText(String string) {
        Field field = new Field(COLNAME_CONSTRAINT_TEXT, "CLOBHELPER");
        ClobHelper clobHelper = new ClobHelper(string);
        field.setValue(clobHelper);
        this.setField(field);
    }

    public void setConstraintText(ClobHelper clobHelper) {
        Field field = new Field(COLNAME_CONSTRAINT_TEXT, "CLOBHELPER");
        field.setValue(clobHelper);
        this.setField(field);
    }

    protected void setDetailOrder(Integer n) {
        Field field = new Field(COLNAME_DETAIL_ORDER, "INTEGER", false);
        field.setValue(n);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setLastUpdatedOn(Date date) {
        Field field = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setLastUpdatedBy(String string) {
        Field field = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public String getRefFlag() {
        Field field = this.getField(COLNAME_REF_FLAG);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getConstraintId() {
        Field field = this.getField(COLNAME_CONSTRAINT_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public DBObjectId getColumnId() {
        Field field = this.getField(COLNAME_COLUMN_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Integer getColumnPortion() {
        Field field = this.getField(COLNAME_COLUMN_PORTION);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public ClobHelper getConstraintText() {
        Field field = this.getField(COLNAME_CONSTRAINT_TEXT);
        if (field == null) {
            return null;
        }
        return field.getClobHelper();
    }

    public Integer getDetailOrder() {
        Field field = this.getField(COLNAME_DETAIL_ORDER);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getLastUpdatedOn() {
        Field field = this.getField(COLNAME_LAST_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getLastUpdatedBy() {
        Field field = this.getField(COLNAME_LAST_UPDATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            Object object = resultSet.getString(COLNAME_REF_FLAG);
            if (resultSet.wasNull()) {
                this.setRefFlag(null);
            } else {
                this.setRefFlag((String)object);
            }
            this.setConstraintId(new DBObjectId(resultSet.getLong(COLNAME_CONSTRAINT_ID_FK)));
            object = new DBObjectId(resultSet.getLong(COLNAME_COLUMN_ID_FK));
            if (resultSet.wasNull()) {
                this.setColumnId(null);
            } else {
                this.setColumnId((DBObjectId)object);
            }
            object = resultSet.getInt(COLNAME_COLUMN_PORTION);
            if (resultSet.wasNull()) {
                this.setColumnPortion(null);
            } else {
                this.setColumnPortion((Integer)object);
            }
            object = new ClobHelper(resultSet.getClob(COLNAME_CONSTRAINT_TEXT));
            if (resultSet.wasNull()) {
                this.setConstraintText((ClobHelper)null);
            } else {
                this.setConstraintText((ClobHelper)object);
            }
            this.setDetailOrder(resultSet.getInt(COLNAME_DETAIL_ORDER));
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_CREATED_BY);
            if (resultSet.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_LAST_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_LAST_UPDATED_BY);
            if (resultSet.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    public String getContainerFieldName() {
        return COLNAME_CONSTRAINT_ID_FK;
    }

    @Override
    public DBObjectId getContainerId() {
        return this.getConstraintId();
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

