/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class CapturedConnectionIterator
extends PersistableObjectIterator {
    static final String SQL = "select * from MD_CONNECTIONS where PROJECT_ID_FK = ? and TYPE is NULL";
    private PreparedStatement m_myStatement;

    public CapturedConnectionIterator(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException {
        super(MdConnection.class, persistenceManager);
        try {
            this.m_myStatement = persistenceManager.getPreparedStatement(SQL);
            this.m_myStatement.setLong(1, dBObjectId.getId());
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    @Override
    protected PreparedStatement getPreparedStatement() throws SQLException {
        return this.m_myStatement;
    }
}

