/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool.undo;

import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.item.LinkItem;
import oracle.bali.jle.tool.LinkTool;
import oracle.bali.jle.tool.undo.LocalizedEdit;

public class LinkUndo
extends LocalizedEdit {
    private LayoutItem _source;
    private LayoutItem _dest;
    private Point2D _sourcePt;
    private Point2D _destPt;
    private LinkItem _link;
    private LinkTool _tool;

    public LinkUndo(LinkItem link, LayoutItem source, Point2D sourcePt, LayoutItem dest, Point2D destPt, LinkTool tool) {
        if (link == null || source == null || sourcePt == null || dest == null || destPt == null || tool == null) {
            throw new IllegalArgumentException();
        }
        this._link = link;
        this._source = source;
        this._sourcePt = sourcePt;
        this._dest = dest;
        this._destPt = destPt;
        this._tool = tool;
    }

    public void undo() {
        super.undo();
        LayoutItem parent = this._link.getItemParent();
        parent.removeItem(this._link);
        parent.repaintItem();
    }

    public void redo() {
        super.redo();
        this._link = this._tool.processLink(this._source, this._dest, this._sourcePt, this._destPt);
        this._link.repaintItem();
    }

    public void die() {
        super.die();
        this._source = null;
        this._sourcePt = null;
        this._dest = null;
        this._destPt = null;
        this._link = null;
        this._tool = null;
    }

    public String getBaseKey() {
        return "LINK";
    }
}

