/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool.undo;

import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.tool.undo.LocalizedEdit;

public class DeleteUndo
extends LocalizedEdit {
    private LayoutItem _deleted;
    private LayoutItem _parent;
    private int _index;

    public DeleteUndo(LayoutItem deleted, LayoutItem parent, int index) {
        if (deleted == null) {
            throw new IllegalArgumentException();
        }
        this._deleted = deleted;
        this._parent = parent;
        this._index = index;
    }

    public void undo() {
        super.undo();
        this._parent.addItem(this._deleted, this._index);
        this._parent.repaintItem();
    }

    public void redo() {
        super.redo();
        this._parent.removeItem(this._deleted);
        this._parent.repaintItem();
    }

    public void die() {
        super.die();
        this._deleted = null;
        this._parent = null;
    }

    public String getBaseKey() {
        return "DELETE";
    }

    public LayoutItem getDeletedItem() {
        return this._deleted;
    }
}

