/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.event.UndoableEditEvent;
import oracle.bali.jle.JLEAutoScroller;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.event.Cancelable;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.DefaultLinkPort;
import oracle.bali.jle.item.LinkItem;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.item.TwoPortLinkItem;
import oracle.bali.jle.tool.BaseTool;
import oracle.bali.jle.tool.LinkToolEvent;
import oracle.bali.jle.tool.LinkToolListener;
import oracle.bali.jle.tool.LinkToolValidateEvent;
import oracle.bali.jle.tool.undo.LinkUndo;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.collection.StringKey;
import oracle.bali.share.event.ListenerManager;

public class LinkTool
extends BaseTool {
    public static final Object REJECT_LINK_KEY = new StringKey("REJECT_LINK_KEY");
    public static final Object LINK_PORTS_KEY = new StringKey("LINK_PORTS_KEY");
    private double _startX;
    private double _startY;
    private double _endX;
    private double _endY;
    private boolean _linking;
    private LayoutItem _source;
    private Point2D _srcPt;
    private ListenerManager _listeners;
    private boolean _postUndo;
    private boolean _autoscrolling;

    public void drawHighlight(Graphics g) {
        if (this._linking && !this._autoscrolling) {
            JLECanvas canvas = this.getCanvas();
            Point source = canvas.contentToDevice(this._startX, this._startY);
            Point dest = canvas.contentToDevice(this._endX, this._endY);
            Color oldColor = g.getColor();
            g.setColor(Color.black);
            g.drawLine(source.x, source.y, dest.x, dest.y);
            g.setColor(oldColor);
        }
    }

    public long getDefaultEnabledEvents() {
        return 56L;
    }

    public void pickup(JLECanvas canvas, JLEEventSource eventSource) {
        super.pickup(canvas, eventSource);
        this._endY = 0.0;
        this._startY = 0.0;
        this._endX = 0.0;
        this._startX = 0.0;
        this._autoscrolling = false;
        this._linking = false;
        this._postUndo = canvas.hasUndoableEditListeners();
    }

    public void drop() {
        this._autoscrolling = false;
        this._postUndo = false;
        JLEAutoScroller.getJLEAutoScroller().cancel();
        super.drop();
    }

    protected void processMousePressed(JLEEvent e) {
        if (!this.isPrimaryMouseEvent(e)) {
            return;
        }
        JLECanvas canvas = this.getCanvas();
        this._startX = this._endX = e.getX();
        this._startY = this._endY = e.getY();
        LayoutItem curr = canvas.getHitItem(this._startX, this._startY);
        if (curr != null) {
            this._srcPt = canvas.contentToDeviceDouble(this._startX, this._startY);
            this._srcPt = ItemUtils.deviceToItem(curr, this._srcPt);
            if (!this.isValidLinkSource(curr, this._srcPt)) {
                return;
            }
            this._source = curr;
            e.consume();
        }
    }

    protected void processMouseReleased(JLEEvent e) {
        JLEAutoScroller.getJLEAutoScroller().cancel();
        this._autoscrolling = false;
        JLECanvas canvas = this.getCanvas();
        if (this._source != null) {
            LayoutItem curr;
            for (curr = canvas.getHitItem(this._endX, this._endY); curr != null && !LinkTool.isLinkable(curr); curr = curr.getItemParent()) {
            }
            if (curr != null && curr != this._source && curr.getItemParent() != null) {
                boolean noCancel;
                Point2D destPt = canvas.contentToDeviceDouble(this._endX, this._endY);
                if (this.isValidLinkDestination(curr, destPt = ItemUtils.deviceToItem(curr, destPt), this._source, this._srcPt) && (noCancel = this.fireLinkToolEvent(1, null, this._source, this._srcPt, curr, destPt))) {
                    LinkItem attached = this.processLink(this._source, curr, this._srcPt, destPt);
                    if (this._postUndo) {
                        LinkUndo edit = new LinkUndo(attached, this._source, this._srcPt, curr, destPt, this);
                        canvas.processUndoableEditEvent(new UndoableEditEvent(this, edit));
                    }
                    this.fireLinkToolEvent(2, attached, this._source, this._srcPt, curr, destPt);
                    attached.repaintItem();
                }
            }
        }
        this._linking = false;
        this._source = null;
        this._srcPt = null;
        this._endY = 0.0;
        this._endX = 0.0;
        this._startY = 0.0;
        this._startX = 0.0;
        this.updateImmediately();
    }

    protected void processMouseDragged(JLEEvent e) {
        if (!this.isPrimaryMouseEvent(e)) {
            return;
        }
        this._linking = this._source != null;
        this._endX = e.getX();
        this._endY = e.getY();
        if (this._linking && this._listeners != null) {
            JLECanvas canvas = this.getCanvas();
            this._autoscrolling = JLEAutoScroller.getJLEAutoScroller().checkAutoScroll(canvas, e);
            LayoutItem curr = canvas.getHitItem(this._endX, this._endY);
            Point2D destPt = null;
            if (curr != null && curr != this._source) {
                destPt = canvas.contentToDeviceDouble(this._endX, this._endY);
                destPt = ItemUtils.deviceToItem(curr, destPt);
            }
            this.fireLinkToolEvent(3, null, this._source, this._srcPt, curr, destPt);
        }
        Rectangle2D damaged = GeometryUtils.getDrawRect(this._startX, this._startY, this._endX, this._endY);
        this.addImmediateRect(damaged);
        this.updateImmediately();
    }

    protected void processKeyPressed(JLEEvent e) {
        super.processKeyPressed(e);
        if (e.isConsumed()) {
            return;
        }
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 27: {
                if (this._source == null) break;
                this._linking = false;
                this._source = null;
                this._endY = 0.0;
                this._endX = 0.0;
                this._startY = 0.0;
                this._startX = 0.0;
                this.updateImmediately();
            }
        }
    }

    public static LinkItem attachLinkItem(LayoutItem source, LayoutItem destination) {
        if (source == null || destination == null) {
            throw new IllegalArgumentException();
        }
        LinkPort sourcePort = LinkTool.getClosestPort(destination, source);
        LinkPort destPort = LinkTool.getClosestPort(sourcePort, destination);
        return LinkTool.attachLinkItem(sourcePort, destPort);
    }

    public static LinkItem attachLinkItem(LinkPort source, LinkPort destination) {
        LayoutItem parent;
        if (source == null || destination == null) {
            throw new IllegalArgumentException();
        }
        TwoPortLinkItem link = new TwoPortLinkItem(source, destination);
        for (parent = ItemUtils.getSharedAncestor(source.getItem(), destination.getItem()); parent != null && !parent.allowsChildren(); parent = parent.getItemParent()) {
        }
        if (parent == null) {
            return null;
        }
        parent.addItem(link, 0);
        return link;
    }

    public static LinkPort[] getLinkPorts(LayoutItem source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        Object result = source.getProperty(REJECT_LINK_KEY);
        if (result != PropertyManager.NOT_FOUND_OBJECT) {
            return new LinkPort[0];
        }
        result = source.getProperty(LINK_PORTS_KEY);
        if (result != PropertyManager.NOT_FOUND_OBJECT) {
            return (LinkPort[])result;
        }
        return LinkTool._createDefaultPorts(source);
    }

    public static void setLinkPorts(LayoutItem source, LinkPort[] ports) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        Object result = source.removeProperty(LINK_PORTS_KEY);
        if (result != PropertyManager.NOT_FOUND_OBJECT) {
            LinkPort[] oldPorts = (LinkPort[])result;
            for (int i = 0; i < oldPorts.length; ++i) {
                oldPorts[i].die();
            }
        }
        if (ports == null) {
            return;
        }
        source.putProperty(LINK_PORTS_KEY, ports);
    }

    public static boolean isLinkable(LayoutItem target) {
        if (target == null) {
            return false;
        }
        Object result = target.getProperty(REJECT_LINK_KEY);
        return result == PropertyManager.NOT_FOUND_OBJECT;
    }

    public static void setLinkable(LayoutItem target, boolean isLinkable) {
        if (isLinkable) {
            target.removeProperty(REJECT_LINK_KEY);
        } else {
            target.putProperty(REJECT_LINK_KEY, null);
        }
    }

    public static LinkPort getClosestPort(LinkPort target, LayoutItem portSource) {
        Point2D targetDevice = LinkItem.getPortInDeviceDouble(target);
        return LinkTool._findClosestPort(targetDevice, portSource);
    }

    public static LinkPort getClosestPort(LayoutItem target, LayoutItem portSource) {
        Rectangle2D targetDevice = ItemUtils.itemToDeviceDouble(target.getItemParent(), target.getItemBounds());
        Point2D.Double targetCenter = new Point2D.Double(targetDevice.getX() + targetDevice.getWidth() / 2.0, targetDevice.getY() + targetDevice.getHeight() / 2.0);
        return LinkTool._findClosestPort(targetCenter, portSource);
    }

    public LinkItem processLink(LayoutItem source, LayoutItem dest, Point2D sourcePt, Point2D destPt) {
        return LinkTool.attachLinkItem(source, dest);
    }

    public void addLinkToolListener(LinkToolListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    public void removeBoundsToolListener(LinkToolListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    protected boolean isValidLinkSource(LayoutItem source, Point2D point) {
        return LinkTool.isLinkable(source);
    }

    protected boolean isValidLinkDestination(LayoutItem destination, Point2D dstPt, LayoutItem source, Point2D srcPt) {
        return LinkTool.isLinkable(destination);
    }

    protected boolean fireLinkToolEvent(int id, LinkItem link, LayoutItem sourceItem, Point2D sourcePt, LayoutItem destItem, Point2D destPt) {
        LinkToolEvent event;
        Enumeration listeners;
        Enumeration enumeration = listeners = this._listeners == null ? null : this._listeners.getListeners();
        if (listeners == null) {
            return true;
        }
        boolean cancelable = false;
        switch (id) {
            case 1: {
                event = new LinkToolValidateEvent(this, id, link, sourceItem, sourcePt, destItem, destPt);
                cancelable = true;
                break;
            }
            default: {
                event = new LinkToolEvent(this, id, link, sourceItem, sourcePt, destItem, destPt);
            }
        }
        while (listeners.hasMoreElements()) {
            LinkToolListener listener = (LinkToolListener)listeners.nextElement();
            switch (id) {
                case 1: {
                    listener.linkCreating(event);
                    break;
                }
                case 2: {
                    listener.linkCreated(event);
                    break;
                }
                case 3: {
                    listener.linkPositioning(event);
                }
            }
        }
        return cancelable ? !((Cancelable)((Object)event)).isCancelled() : true;
    }

    private static LinkPort _findClosestPort(Point2D target, LayoutItem portSource) {
        LinkPort[] ports = LinkTool.getLinkPorts(portSource);
        if (ports.length == 0) {
            return null;
        }
        LinkPort closest = ports[0];
        double lowDistance = Double.MAX_VALUE;
        for (int i = 0; i < ports.length; ++i) {
            LinkPort curr = ports[i];
            Point2D devicePoint = ItemUtils.itemToDevice(portSource, curr.getX(), curr.getY());
            double distance = GeometryUtils.segmentLength(devicePoint.getX(), devicePoint.getY(), target.getX(), target.getY());
            if (!(distance < lowDistance)) continue;
            lowDistance = distance;
            closest = curr;
        }
        return closest;
    }

    private static LinkPort[] _createDefaultPorts(LayoutItem source) {
        LinkPort[] ports = new LinkPort[]{new DefaultLinkPort(source, 0), new DefaultLinkPort(source, 1), new DefaultLinkPort(source, 2), new DefaultLinkPort(source, 4), new DefaultLinkPort(source, 5), new DefaultLinkPort(source, 6), new DefaultLinkPort(source, 8), new DefaultLinkPort(source, 9), new DefaultLinkPort(source, 10)};
        source.getPropertyManager().put(LINK_PORTS_KEY, ports);
        return ports;
    }
}

