/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.event.UndoableEditEvent;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseItem;
import oracle.bali.jle.tool.BaseTool;
import oracle.bali.jle.tool.EventPassthroughTool;
import oracle.bali.jle.tool.InlineEditHandler;
import oracle.bali.jle.tool.InlineEditToolEvent;
import oracle.bali.jle.tool.InlineEditToolListener;
import oracle.bali.jle.tool.undo.InlineEditUndo;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.collection.StringKey;
import oracle.bali.share.event.ListenerManager;

public class InlineEditTool
extends BaseTool {
    public static final Object EDIT_HANDLER_KEY = new StringKey("EDIT_HANDLER_KEY");
    private boolean _postUndo;
    private LayoutItem _editing;
    private int _savedIndex;
    private LayoutItem _editControl;
    private InlineEditHandler _handler;
    private EventPassthroughTool _passthrough;
    private boolean _reEnablePassthrough;
    private LayoutItem _firstClick;
    private boolean _commit;
    private Object _oldValue;
    private double _pressX;
    private double _pressY;
    private double _mouseTolX;
    private double _mouseTolY;
    private ListenerManager _listeners;
    private transient boolean _restoreCaching;
    private static double _MOUSE_TOLERANCE = 1.0;

    public InlineEditTool(EventPassthroughTool passthrough) {
        if (passthrough == null) {
            throw new IllegalArgumentException("passthrough can't be null");
        }
        this._passthrough = passthrough;
    }

    public static InlineEditHandler getInlineEditHandler(LayoutItem item) {
        Object result = item.getProperty(EDIT_HANDLER_KEY);
        return result == PropertyManager.NOT_FOUND_OBJECT ? null : (InlineEditHandler)result;
    }

    public static void setInlineEditHandler(LayoutItem item, InlineEditHandler handler) {
        if (item == null) {
            return;
        }
        Object store = handler == null ? PropertyManager.NOT_FOUND_OBJECT : handler;
        item.putProperty(EDIT_HANDLER_KEY, store);
    }

    public void drop() {
        super.drop();
        this._postUndo = false;
    }

    public void pickup(JLECanvas canvas, JLEEventSource eventSource) {
        super.pickup(canvas, eventSource);
        this._mouseTolX = _MOUSE_TOLERANCE * canvas.getEngineUnitsPerPixelX();
        this._mouseTolY = _MOUSE_TOLERANCE * canvas.getEngineUnitsPerPixelY();
        this._postUndo = canvas.hasUndoableEditListeners();
    }

    public long getDefaultEnabledEvents() {
        return 24L;
    }

    public EventPassthroughTool getEventPassthroughTool() {
        return this._passthrough;
    }

    public void processInlineEditStart(LayoutItem item, InlineEditHandler handler, JLEEvent startEvent) {
        if (item == null || handler == null) {
            throw new IllegalArgumentException();
        }
        this._editControl = handler.getEditControlItem();
        LayoutItem parent = item.getItemParent();
        if (parent == null) {
            return;
        }
        this._savedIndex = ItemUtils.getItemIndex(item, parent);
        Rectangle2D bounds = item.getItemBounds();
        parent.removeItem(item);
        parent.repaintItem();
        this._editing = item;
        this._oldValue = handler.startEdit(this, item);
        this.fireInlineEditToolEvent(1, item, this._oldValue);
        this._editControl.setItemSize(bounds.getWidth(), bounds.getHeight());
        this._editControl.setItemLocation(bounds.getX(), bounds.getY());
        parent.addItem(this._editControl);
        if (BaseItem.isZoomCachingAllowed()) {
            this._restoreCaching = true;
            BaseItem.setZoomCachingAllowed(false);
        }
        this._reEnablePassthrough = this._passthrough.isEnabled();
        LayoutItem[] target = new LayoutItem[]{this._editControl};
        this._passthrough.setTargetItems(target);
        this._passthrough.setForcedMouseConsumption(true);
        this._passthrough.setEnabled(true);
        this.getCanvas().setFocusedItem(this._editControl);
        this._passthrough.processJLEEvent(startEvent);
    }

    public void processInlineEditCommit(LayoutItem item, InlineEditHandler handler) {
        if (item == null || handler == null) {
            throw new IllegalArgumentException();
        }
        if (item != this._editing) {
            return;
        }
        Object newVal = handler.commitEdit(this, item);
        this.fireInlineEditToolEvent(3, item, newVal);
        if (this._postUndo) {
            InlineEditUndo edit = new InlineEditUndo(item, this._oldValue, newVal);
            this.getCanvas().processUndoableEditEvent(new UndoableEditEvent(this, edit));
        }
        this._oldValue = null;
        this._restoreItem();
    }

    public void processInlineEditCancel(LayoutItem item, InlineEditHandler handler) {
        if (item == null || handler == null) {
            throw new IllegalArgumentException();
        }
        if (item != this._editing) {
            return;
        }
        handler.cancelEdit(this, item);
        this.fireInlineEditToolEvent(2, item, this._oldValue);
        this._restoreItem();
    }

    public void addInlineEditToolListener(InlineEditToolListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    public void removeInlineEditToolListener(InlineEditToolListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    protected void processMousePressed(JLEEvent e) {
        JLECanvas canvas = this.getCanvas();
        if (canvas == null) {
            return;
        }
        LayoutItem pressed = canvas.getHitItem(e.getX(), e.getY());
        if (this._editing != null && (pressed == null || pressed != this._editControl)) {
            this.processInlineEditCommit(this._editing, this._handler);
            return;
        }
        this._pressX = e.getX();
        this._pressY = e.getY();
    }

    protected void processMouseReleased(JLEEvent e) {
        LayoutItem pressed = this.getCanvas().getHitItem(e.getX(), e.getY());
        if (pressed == null) {
            return;
        }
        InlineEditHandler handler = InlineEditTool.getInlineEditHandler(pressed);
        if (handler == null) {
            return;
        }
        this._handler = handler;
        if (e.isConsumed()) {
            if (this._firstClick == pressed) {
                if (Math.abs(e.getX() - this._pressX) > this._mouseTolX || Math.abs(e.getY() - this._pressY) > this._mouseTolY) {
                    return;
                }
                this._firstClick = null;
                this.processInlineEditStart(pressed, this._handler, new JLEEvent(e.getSource(), 501, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount()));
            } else {
                this._firstClick = pressed;
            }
        } else {
            this._firstClick = null;
            this.processInlineEditStart(pressed, this._handler, new JLEEvent(e.getSource(), 501, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount()));
        }
    }

    protected void processKeyPressed(JLEEvent e) {
        if (this._editing != null && this._handler != null && e.getKeyChar() == '\u001b') {
            e.consume();
            this.processInlineEditCancel(this._editing, this._handler);
        }
    }

    protected void fireInlineEditToolEvent(int id, LayoutItem item, Object value) {
        Enumeration listeners;
        InlineEditToolEvent event = new InlineEditToolEvent(this, id, item, value);
        Enumeration enumeration = listeners = this._listeners == null ? null : this._listeners.getListeners();
        if (listeners == null) {
            return;
        }
        while (listeners.hasMoreElements()) {
            InlineEditToolListener listener = (InlineEditToolListener)listeners.nextElement();
            if (id == 1) {
                listener.itemEditStarting(event);
                continue;
            }
            if (id == 2) {
                listener.itemEditCancelling(event);
                continue;
            }
            if (id != 3) continue;
            listener.itemEditCommitting(event);
        }
    }

    private void _restoreItem() {
        LayoutItem parent = this._editControl.getItemParent();
        parent.removeItem(this._editControl);
        parent.addItem(this._editing, this._savedIndex);
        this._passthrough.setEnabled(this._reEnablePassthrough);
        this._passthrough.setTargetItems(null);
        this._passthrough.setForcedMouseConsumption(false);
        this.getCanvas().getGlassComponent().requestFocus();
        if (this._restoreCaching) {
            BaseItem.setZoomCachingAllowed(true);
            if (this._editing instanceof BaseItem) {
                ((BaseItem)this._editing).invalidateZoomImage();
            }
        }
        this._restoreCaching = false;
        this._editing = null;
        this._editControl = null;
    }
}

