/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Cursor;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.item.BaseItem;
import oracle.bali.jle.tool.BaseTool;
import oracle.bali.jle.util.ItemUtils;

public class EventPassthroughTool
extends BaseTool {
    private long _mask;
    private long _actualMask;
    private LayoutItem _mouseItem;
    private LayoutItem _dragItem;
    private Cursor _cursor;
    private Cursor _defaultCursor;
    private LayoutItem[] _targets;
    private boolean _mouseConsume;
    private boolean _restoreCaching = true;

    public EventPassthroughTool() {
        this(60L);
    }

    public EventPassthroughTool(long passthroughMask) {
        long actualMask = this._mask = passthroughMask;
        if ((passthroughMask & 0x10L) != 0L) {
            actualMask |= 0x20L;
        }
        if ((passthroughMask & 0x20L) != 0L) {
            actualMask |= 0x10L;
        }
        this._actualMask = actualMask;
    }

    public void pickup(JLECanvas canvas, JLEEventSource eventSource) {
        super.pickup(canvas, eventSource);
        this._defaultCursor = canvas.getGlassComponent().getCursor();
        boolean bl = this._restoreCaching = BaseItem.isZoomCachingAllowed() && this.isEnabled();
        if (this._restoreCaching) {
            BaseItem.setZoomCachingAllowed(false);
        }
    }

    public void drop() {
        JLECanvas canvas = this.getCanvas();
        super.drop();
        if (this._restoreCaching) {
            BaseItem.setZoomCachingAllowed(true);
        }
        if (canvas != null) {
            canvas.getGlassComponent().requestFocus();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this._restoreCaching) {
            BaseItem.setZoomCachingAllowed(!enabled);
        }
    }

    public long getDefaultEnabledEvents() {
        return this._actualMask;
    }

    public void setTargetItems(LayoutItem[] targets) {
        if (targets == null || targets.length == 0) {
            this._targets = null;
        } else {
            LayoutItem[] newTargets = new LayoutItem[targets.length];
            System.arraycopy(targets, 0, newTargets, 0, newTargets.length);
            this._targets = newTargets;
        }
    }

    public void addTargetItem(LayoutItem target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        if (this._targets == null) {
            this._targets = new LayoutItem[]{target};
        } else {
            LayoutItem[] newTargets = new LayoutItem[this._targets.length + 1];
            System.arraycopy(this._targets, 0, newTargets, 0, this._targets.length);
            newTargets[this._targets.length] = target;
            this._targets = newTargets;
        }
    }

    public void removeTargetItem(LayoutItem target) {
        if (target == null || this._targets == null) {
            throw new IllegalArgumentException();
        }
        int index = -1;
        for (int i = 0; i < this._targets.length; ++i) {
            if (this._targets[i] != target) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new IllegalArgumentException("not a target: " + target);
        }
        if (this._targets.length == 1) {
            this._targets = null;
            return;
        }
        LayoutItem[] newTargets = new LayoutItem[this._targets.length - 1];
        System.arraycopy(this._targets, 0, newTargets, 0, index);
        if (index < newTargets.length) {
            System.arraycopy(this._targets, index + 1, newTargets, index, newTargets.length - index);
        }
        this._targets = newTargets;
    }

    public LayoutItem[] getTargetItems() {
        if (this._targets != null) {
            LayoutItem[] copy = new LayoutItem[this._targets.length];
            System.arraycopy(this._targets, 0, copy, 0, copy.length);
            return copy;
        }
        return null;
    }

    public void setForcedMouseConsumption(boolean consume) {
        this._mouseConsume = consume;
    }

    public boolean hasForcedMouseConsumption() {
        return this._mouseConsume;
    }

    public void processJLEEvent(JLEEvent e) {
        switch (e.getID()) {
            case 500: {
                this.mouseClicked(e);
                break;
            }
            case 501: {
                this.mousePressed(e);
                break;
            }
            case 502: {
                this.mouseReleased(e);
                break;
            }
            case 504: {
                this.mouseEntered(e);
                break;
            }
            case 505: {
                this.mouseExited(e);
                break;
            }
            case 503: {
                this.mouseMoved(e);
                break;
            }
            case 506: {
                this.mouseDragged(e);
                break;
            }
            case 400: {
                this.keyTyped(e);
                break;
            }
            case 401: {
                this.keyPressed(e);
                break;
            }
            case 402: {
                this.keyReleased(e);
                break;
            }
            case 1004: {
                this.focusGained(e);
                break;
            }
            case 1005: {
                this.focusLost(e);
            }
        }
    }

    protected void processMouseClicked(JLEEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        LayoutItem target = this._checkTarget(e);
        if (target != null) {
            this._redispatchMouseEvent(e, target, e.getID());
        }
    }

    protected void processMousePressed(JLEEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        LayoutItem target = this._checkTarget(e);
        if (target != null) {
            this._redispatchMouseEvent(e, target, e.getID());
            this._dragItem = target;
        }
    }

    protected void processMouseReleased(JLEEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this._dragItem != null) {
            this._redispatchMouseEvent(e, this._dragItem, e.getID());
            this._dragItem = null;
        }
    }

    protected void processMouseEntered(JLEEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this._checkTarget(e);
    }

    protected void processMouseExited(JLEEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this._checkTarget(e);
    }

    protected void processMouseDragged(JLEEvent e) {
        if (!this.isEnabled() || this._dragItem == null) {
            return;
        }
        this._checkTarget(e);
        this._redispatchMouseEvent(e, this._dragItem, e.getID());
    }

    protected void processMouseMoved(JLEEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        LayoutItem oldTarget = this._mouseItem;
        LayoutItem target = this._checkTarget(e);
        if (oldTarget == target) {
            this._redispatchMouseEvent(e, target, e.getID());
        }
        if (target != null) {
            Cursor itemCursor;
            Object result = target.getProperty(LayoutItem.CURSOR_KEY);
            Cursor cursor = itemCursor = result != PropertyManager.NOT_FOUND_OBJECT ? (Cursor)result : this._defaultCursor;
            if (itemCursor != this._cursor) {
                this._cursor = itemCursor;
                this.getCanvas().getGlassComponent().setCursor(itemCursor);
            }
        }
    }

    protected void processKeyTyped(JLEEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        LayoutItem focused = this.getCanvas().getFocusedItem();
        if (focused != null) {
            JLEEvent newE = new JLEEvent(focused, 400, e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar());
            focused.processEvent(newE);
            if (newE.isConsumed()) {
                e.consume();
            }
        }
        if (!e.isConsumed()) {
            super.processKeyTyped(e);
        }
    }

    protected void processKeyPressed(JLEEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        JLECanvas canvas = this.getCanvas();
        if (canvas == null) {
            return;
        }
        LayoutItem focused = canvas.getFocusedItem();
        if (focused != null) {
            JLEEvent newE = new JLEEvent(focused, 401, e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar());
            focused.processEvent(newE);
            if (newE.isConsumed() || this._targets != null) {
                e.consume();
            }
        }
        if (!e.isConsumed()) {
            super.processKeyPressed(e);
        }
    }

    protected void processKeyReleased(JLEEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        LayoutItem focused = this.getCanvas().getFocusedItem();
        if (focused != null) {
            JLEEvent newE = new JLEEvent(focused, 402, e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar());
            focused.processEvent(newE);
            if (newE.isConsumed()) {
                e.consume();
            }
        }
        if (!e.isConsumed()) {
            super.processKeyReleased(e);
        }
    }

    private void _redispatchMouseEvent(JLEEvent e, LayoutItem target, int newID) {
        if (target == null) {
            return;
        }
        JLECanvas canvas = this.getCanvas();
        Point2D deviceCoord = ItemUtils.transformPoint(canvas.getDeviceTransform(), new Point2D.Double(e.getX(), e.getY()), false);
        Point2D targetCoord = ItemUtils.deviceToItem(target, deviceCoord);
        JLEEvent targeted = new JLEEvent(target, newID, e.getWhen(), e.getModifiers(), targetCoord.getX(), targetCoord.getY(), e.getClickCount());
        target.processEvent(targeted);
        if (targeted.isConsumed() || this._mouseConsume) {
            e.consume();
            if (e.getID() == 501) {
                this.getCanvas().getGlassComponent().skipFocusGrab();
            }
        }
    }

    private LayoutItem _checkTarget(JLEEvent evt) {
        JLECanvas canvas = this.getCanvas();
        LayoutItem target = null;
        if (evt.getID() != 505) {
            target = this._findItem(evt);
            if (this._targets != null) {
                boolean found = false;
                for (int i = 0; i < this._targets.length; ++i) {
                    if (target != this._targets[i]) continue;
                    found = true;
                }
                if (!found) {
                    target = null;
                }
            }
        }
        if (target != this._mouseItem) {
            if (this._mouseItem != null && (this._dragItem == null || this._dragItem == this._mouseItem)) {
                this._redispatchMouseEvent(evt, this._mouseItem, 505);
                this._mouseItem = null;
            }
            if (target != null && (this._dragItem == null || this._dragItem == target)) {
                this._redispatchMouseEvent(evt, target, 504);
                this._mouseItem = target;
            }
        }
        return target;
    }

    private LayoutItem _findItem(JLEEvent e) {
        LayoutItem target = this.getCanvas().getItemAt(e.getX(), e.getY());
        return target;
    }
}

