/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Graphics;
import java.awt.Rectangle;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutTool;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventListener;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.Rectangle2D;

public class BaseTool
implements LayoutTool,
JLEEventListener {
    private JLECanvas _canvas;
    private JLEEventSource _eventSource;
    private Rectangle2D _immediate;
    private boolean _consumeKeys;
    private boolean _consumeMouse;
    private boolean _enabled = true;
    private int _mouseMask = 0;
    private int _primaryMouse = 16;
    private static String _sAssertWarning = " - tool should not partially consume event sets";

    public void drawHighlight(Graphics g) {
    }

    public void drop() {
        long eventsToEnable = this.getDefaultEnabledEvents();
        if (eventsToEnable != 0L) {
            this._eventSource.removeJLEEventListener(this);
        }
        this._canvas = null;
    }

    public void pickup(JLECanvas canvas, JLEEventSource eventSource) {
        this._canvas = canvas;
        this._eventSource = eventSource;
        long eventsToEnable = this.getDefaultEnabledEvents();
        if (eventsToEnable != 0L) {
            this._eventSource.addJLEEventListener(this);
            this._eventSource.enableJLEEvents(eventsToEnable);
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void setPrimaryMouseButton(int primary) {
        if (primary != 16 && primary != 8 && primary != 4) {
            throw new IllegalArgumentException();
        }
        this._primaryMouse = primary;
    }

    public int getPrimaryMouseButton() {
        return this._primaryMouse;
    }

    public boolean isPrimaryMouseEvent(JLEEvent event) {
        int type = event.getID();
        if (type == 501 || type == 502 || type == 500 || type == 506) {
            return (event.getModifiers() & this.getPrimaryMouseButton()) != 0;
        }
        return false;
    }

    public JLECanvas getCanvas() {
        return this._canvas;
    }

    public JLEEventSource getEventSource() {
        return this._eventSource;
    }

    public long getDefaultEnabledEvents() {
        return 0L;
    }

    public void yield() {
        JLECanvas canvas = this.getCanvas();
        if (canvas != null) {
            canvas.setTool(canvas.getDefaultTool());
        }
    }

    public boolean isActive() {
        return this.getCanvas() != null;
    }

    public final void mouseClicked(JLEEvent e) {
        if (!this._consumeMouse && !this.isEnabled()) {
            return;
        }
        this.processMouseClicked(e);
        if (this._consumeMouse) {
            e.consume();
        }
    }

    public final void mousePressed(JLEEvent e) {
        this._consumeMouse = false;
        if (!this.isEnabled()) {
            return;
        }
        boolean previouslyConsumed = e.isConsumed();
        this.processMousePressed(e);
        if (previouslyConsumed || !previouslyConsumed && e.isConsumed()) {
            this._consumeMouse = true;
        }
    }

    public final void mouseReleased(JLEEvent e) {
        if (!this._consumeMouse && !this.isEnabled()) {
            return;
        }
        this.processMouseReleased(e);
        if (this._consumeMouse) {
            e.consume();
        }
    }

    public final void mouseEntered(JLEEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.processMouseEntered(e);
    }

    public final void mouseExited(JLEEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.processMouseExited(e);
    }

    public final void mouseDragged(JLEEvent e) {
        if (!this._consumeMouse && !this.isEnabled()) {
            return;
        }
        this.processMouseDragged(e);
        if (this._consumeMouse) {
            e.consume();
        }
    }

    public final void mouseMoved(JLEEvent e) {
        if (!this._consumeMouse && !this.isEnabled()) {
            return;
        }
        this.processMouseMoved(e);
    }

    public final void keyTyped(JLEEvent e) {
        if (!this._consumeKeys && !this.isEnabled()) {
            return;
        }
        this.processKeyTyped(e);
        if (this._consumeKeys) {
            e.consume();
        }
    }

    public final void keyPressed(JLEEvent e) {
        this._consumeKeys = false;
        if (!this.isEnabled()) {
            return;
        }
        boolean previouslyConsumed = e.isConsumed();
        this.processKeyPressed(e);
        if (previouslyConsumed || !previouslyConsumed && e.isConsumed()) {
            this._consumeKeys = true;
        }
    }

    public final void keyReleased(JLEEvent e) {
        if (!this._consumeKeys && !this.isEnabled()) {
            return;
        }
        this.processKeyReleased(e);
        if (this._consumeKeys) {
            e.consume();
        }
        this._consumeKeys = false;
    }

    public final void focusGained(JLEEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.processFocusGained(e);
    }

    public final void focusLost(JLEEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.processFocusLost(e);
    }

    protected void processMouseClicked(JLEEvent e) {
    }

    protected void processMousePressed(JLEEvent e) {
    }

    protected void processMouseReleased(JLEEvent e) {
    }

    protected void processMouseEntered(JLEEvent e) {
    }

    protected void processMouseExited(JLEEvent e) {
    }

    protected void processMouseDragged(JLEEvent e) {
    }

    protected void processMouseMoved(JLEEvent e) {
    }

    protected void processKeyTyped(JLEEvent e) {
    }

    protected void processKeyPressed(JLEEvent e) {
    }

    protected void processKeyReleased(JLEEvent e) {
    }

    protected void processFocusGained(JLEEvent e) {
    }

    protected void processFocusLost(JLEEvent e) {
    }

    protected void updateImmediately() {
        JLECanvas canvas = this.getCanvas();
        if (canvas == null) {
            return;
        }
        Rectangle2D clip = this.getImmediateRect();
        if (clip == null) {
            canvas.paintImmediateInterior();
        } else {
            Rectangle devClip = canvas.contentToDevice(clip.getX(), clip.getY(), clip.getWidth(), clip.getHeight());
            canvas.paintImmediateCanvas(devClip.x, devClip.y, devClip.width + 1, devClip.height + 1);
        }
        this.setImmediateRect(clip);
    }

    protected Rectangle2D getImmediateRect() {
        return this._immediate;
    }

    protected void setImmediateRect(Rectangle2D rect) {
        this._immediate = rect;
    }

    protected void addImmediateRect(Rectangle2D rect) {
        if (rect == null) {
            return;
        }
        if (this._immediate == null) {
            this._immediate = new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        } else {
            Rectangle2D.union(this._immediate, rect, this._immediate);
        }
    }

    protected final void addImmediateRect(double x, double y, double width, double height) {
        this.addImmediateRect(new Rectangle2D.Double(x, y, width, height));
    }
}

