/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.geom.Dimension2D;

public class GridPainter
extends AbstractPainter {
    private double _xInterval;
    private double _yInterval;

    public GridPainter(double hInterval, double vInterval) {
        if (hInterval <= 0.0 || vInterval <= 0.0) {
            throw new IllegalArgumentException();
        }
        this._xInterval = hInterval;
        this._yInterval = vInterval;
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        Dimension2D zoom = (Dimension2D)context.getPaintData((Object)JLECanvas.ZOOM_PROPERTY_KEY);
        Dimension2D eupp = (Dimension2D)context.getPaintData((Object)JLECanvas.UNIT_PROPERTY_KEY);
        double xInterval = this._xInterval * zoom.getWidth() / eupp.getWidth();
        double yInterval = this._yInterval * zoom.getHeight() / eupp.getHeight();
        UIDefaults defaults = context.getPaintUIDefaults();
        g.setColor(defaults.getColor(LookAndFeel.DARK_INTENSITY));
        Rectangle clip = g.getClipBounds();
        int top = clip.y;
        int bottom = clip.y + clip.height - 1;
        int left = clip.x;
        int right = clip.x + clip.width - 1;
        int xCurr = (int)Math.floor((double)left / xInterval);
        int xPosition = (int)Math.round((double)xCurr * xInterval);
        while (xPosition <= right) {
            int yCurr = (int)Math.floor((double)top / yInterval);
            int yPosition = (int)Math.round((double)yCurr * yInterval);
            while (yPosition <= bottom) {
                g.drawLine(xPosition, yPosition, xPosition, yPosition);
                yPosition = (int)Math.round((double)(++yCurr) * yInterval);
            }
            xPosition = (int)Math.round((double)(++xCurr) * xInterval);
        }
        g.setColor(oldColor);
    }

    public Dimension getMinimumSize(PaintContext context) {
        return new Dimension(1, 1);
    }

    public boolean isTransparent(PaintContext context) {
        return true;
    }
}

