/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.item.LinkPortEvent;
import oracle.bali.jle.item.LinkPortListener;
import oracle.bali.share.event.ListenerManager;

public class DefaultLinkPort
implements LinkPort,
PropertyChangeListener {
    private static final int _sDIR_RIGHT = 1;
    private static final int _sDIR_DOWN = 4;
    public static final int UPPER_LEFT = 0;
    public static final int UPPER_CENTER = 1;
    public static final int UPPER_RIGHT = 2;
    public static final int CENTER_LEFT = 4;
    public static final int CENTER = 5;
    public static final int CENTER_RIGHT = 6;
    public static final int LOWER_LEFT = 8;
    public static final int LOWER_CENTER = 9;
    public static final int LOWER_RIGHT = 10;
    private LayoutItem _item;
    private int _type;
    private double _x;
    private double _y;
    private boolean _dead = false;
    private ListenerManager _listeners;

    public DefaultLinkPort(LayoutItem item, int type) {
        if (item == null || type < 0 || type > 10) {
            throw new IllegalArgumentException();
        }
        this._item = item;
        this._type = type;
        this._recalculateLocation();
        PropertyManager pm = this._item.getPropertyManager();
        pm.addPropertyChangeListener(this);
    }

    public LayoutItem getItem() {
        return this._item;
    }

    public void die() {
        this._dead = true;
        PropertyManager pm = this._item.getPropertyManager();
        pm.removePropertyChangeListener(this);
        this.fireLinkPortEvent(2);
        this._listeners = null;
        this._item = null;
        this._y = Double.NaN;
        this._x = Double.NaN;
    }

    public boolean isDead() {
        return this._dead;
    }

    public Point2D getLocation() {
        return new Point2D.Double(this._x, this._y);
    }

    public double getX() {
        return this._x;
    }

    public double getY() {
        return this._y;
    }

    public void addLinkPortListener(LinkPortListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    public void removeLinkPortListener(LinkPortListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    public LinkPortListener[] getLinkPortListeners() {
        if (this._listeners == null) {
            return new LinkPortListener[0];
        }
        Enumeration listeners = this._listeners.getListeners();
        if (listeners == null) {
            return new LinkPortListener[0];
        }
        Vector<LinkPortListener> collect = new Vector<LinkPortListener>();
        while (listeners.hasMoreElements()) {
            LinkPortListener curr = (LinkPortListener)listeners.nextElement();
            collect.addElement(curr);
        }
        Object[] result = new LinkPortListener[collect.size()];
        collect.copyInto(result);
        return result;
    }

    public final boolean isUpper() {
        return this._type / 4 == 0;
    }

    public final boolean isLower() {
        return this._type / 4 == 2;
    }

    public final boolean isLeft() {
        return this._type % 4 == 0;
    }

    public final boolean isRight() {
        return this._type % 4 == 2;
    }

    public boolean isCenter() {
        return this._type == 5;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (LayoutItem.DEVICE_TRANSFORM_KEY.equals(property) || LayoutItem.BOUNDS_KEY.equals(property)) {
            this._recalculateLocation();
        }
    }

    public String toString() {
        String type = null;
        switch (this._type) {
            case 5: {
                type = "Center";
                break;
            }
            case 4: {
                type = "Center Left";
                break;
            }
            case 6: {
                type = "Center Right";
                break;
            }
            case 9: {
                type = "Lower Center";
                break;
            }
            case 8: {
                type = "Lower Left";
                break;
            }
            case 10: {
                type = "Lower Right";
                break;
            }
            case 1: {
                type = "Upper Center";
                break;
            }
            case 0: {
                type = "Upper Left";
                break;
            }
            case 2: {
                type = "Upper Right";
            }
        }
        return "(" + this._x + "," + this._y + ") " + type + " on " + this._item;
    }

    protected void fireLinkPortEvent(int id) {
        Enumeration listeners;
        Enumeration enumeration = listeners = this._listeners == null ? null : this._listeners.getListeners();
        if (listeners == null) {
            return;
        }
        LinkPortEvent event = new LinkPortEvent(this, id);
        while (listeners.hasMoreElements()) {
            LinkPortListener listener = (LinkPortListener)listeners.nextElement();
            switch (id) {
                case 1: {
                    listener.portMoved(event);
                }
            }
        }
    }

    private void _recalculateLocation() {
        Dimension2D size = this._item.getItemSize();
        switch (this._type) {
            case 0: {
                this._x = 0.0;
                this._y = 0.0;
                break;
            }
            case 1: {
                this._x = size.getWidth() / 2.0;
                this._y = 0.0;
                break;
            }
            case 2: {
                this._x = size.getWidth();
                this._y = 0.0;
                break;
            }
            case 4: {
                this._x = 0.0;
                this._y = size.getHeight() / 2.0;
                break;
            }
            case 5: {
                this._x = size.getWidth() / 2.0;
                this._y = size.getHeight() / 2.0;
                break;
            }
            case 6: {
                this._x = size.getWidth();
                this._y = size.getHeight() / 2.0;
                break;
            }
            case 8: {
                this._x = 0.0;
                this._y = size.getHeight();
                break;
            }
            case 9: {
                this._x = size.getWidth() / 2.0;
                this._y = size.getHeight();
                break;
            }
            case 10: {
                this._x = size.getWidth();
                this._y = size.getHeight();
            }
        }
        this.fireLinkPortEvent(1);
    }
}

