/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.bali.jle.PropertyManager;
import oracle.bali.share.collection.StringKey;

public class ListPropertyManager
implements PropertyManager {
    private int _size;
    private Link _firstLink;
    private Link _lastLink;
    private VetoableChangeSupport _vetoSupport;
    private PropertyChangeSupport _changeSupport;
    private Object _source;

    public ListPropertyManager() {
        this(null);
    }

    public ListPropertyManager(Object source) {
        this._source = source == null ? this : source;
    }

    public int size() {
        return this._size;
    }

    public Enumeration keys() {
        return new ListEnumeration(this._firstLink, true);
    }

    public Object get(Object key) {
        Link foundLink = this._find(key);
        if (foundLink == null) {
            return NOT_FOUND_OBJECT;
        }
        return foundLink.value;
    }

    public synchronized Object put(Object key, Object value) {
        String keyString;
        if (key == REJECTED_VALUE || key == NOT_FOUND_OBJECT || value == REJECTED_VALUE) {
            throw new IllegalArgumentException("PM keys cannot be special values");
        }
        if (value == NOT_FOUND_OBJECT) {
            return this.remove(key);
        }
        Link foundLink = this._find(key);
        Object oldValue = foundLink != null ? foundLink.value : NOT_FOUND_OBJECT;
        String string = keyString = key instanceof StringKey ? ((StringKey)key).getString() : key.toString();
        if (this._vetoSupport != null) {
            try {
                this._vetoSupport.fireVetoableChange(keyString, oldValue, value);
            }
            catch (PropertyVetoException e) {
                return REJECTED_VALUE;
            }
        }
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(keyString, oldValue, value);
        }
        if (foundLink == null) {
            this._add(key, value);
            return NOT_FOUND_OBJECT;
        }
        foundLink.value = value;
        return oldValue;
    }

    public synchronized Object remove(Object key) {
        String keyString;
        Link removedLink = this._find(key);
        if (removedLink == null) {
            return NOT_FOUND_OBJECT;
        }
        String string = keyString = key instanceof StringKey ? ((StringKey)key).getString() : key.toString();
        if (this._vetoSupport != null) {
            try {
                this._vetoSupport.fireVetoableChange(keyString, removedLink.value, NOT_FOUND_OBJECT);
            }
            catch (PropertyVetoException e) {
                return REJECTED_VALUE;
            }
        }
        Link nextLink = removedLink.nextLink;
        Link prevLink = removedLink.prevLink;
        if (nextLink != null) {
            nextLink.prevLink = prevLink;
        }
        if (prevLink != null) {
            prevLink.nextLink = nextLink;
        } else {
            this._firstLink = nextLink;
        }
        --this._size;
        removedLink.nextLink = null;
        removedLink.prevLink = null;
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(keyString, removedLink.value, NOT_FOUND_OBJECT);
        }
        return removedLink.value;
    }

    public synchronized void clear() {
        if (this._vetoSupport != null) {
            try {
                this._vetoSupport.fireVetoableChange(null, null, null);
            }
            catch (PropertyVetoException e) {
                return;
            }
        }
        Link curr = this._firstLink;
        while (curr != null) {
            Link next = curr.nextLink;
            curr.nextLink = null;
            curr.prevLink = null;
            curr = next;
        }
        this._size = 0;
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(null, null, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this._source);
        }
        this._changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this._changeSupport != null) {
            this._changeSupport.removePropertyChangeListener(l);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        if (this._vetoSupport == null) {
            this._vetoSupport = new VetoableChangeSupport(this._source);
        }
        this._vetoSupport.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        if (this._vetoSupport != null) {
            this._vetoSupport.removeVetoableChangeListener(l);
        }
    }

    public synchronized String toString() {
        String links = super.toString() + ", size is " + this.size() + ", Links:";
        Link currLink = this._firstLink;
        while (currLink != null) {
            links = links + currLink.toString() + "\n";
            currLink = currLink.nextLink;
        }
        return links;
    }

    private void _add(Object key, Object value) {
        Link newLink = new Link();
        newLink.key = key;
        newLink.value = value;
        newLink.prevLink = null;
        newLink.nextLink = this._firstLink;
        if (this._firstLink != null) {
            this._firstLink.prevLink = newLink;
        }
        this._firstLink = newLink;
        ++this._size;
    }

    private synchronized Link _find(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key can't be null");
        }
        Link currLink = this._firstLink;
        while (currLink != null) {
            if (currLink.key.equals(key)) {
                return currLink;
            }
            currLink = currLink.nextLink;
        }
        return null;
    }

    private static class ListEnumeration
    implements Enumeration {
        private Link _currLink;
        private boolean _enumerateKeys;

        public ListEnumeration(Link firstLink, boolean enumerateKeys) {
            this._enumerateKeys = enumerateKeys;
            this._currLink = firstLink;
        }

        public boolean hasMoreElements() {
            return this._currLink != null;
        }

        public Object nextElement() {
            if (this._currLink == null) {
                throw new NoSuchElementException();
            }
            Object returnee = this._enumerateKeys ? this._currLink.key : this._currLink.value;
            this._currLink = this._currLink.nextLink;
            return returnee;
        }
    }

    private static class Link {
        public Object key;
        public Object value;
        public Link nextLink;
        public Link prevLink;

        public String toString() {
            return "Key:" + this.key + ", Value:" + this.value;
        }
    }
}

