/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.geom.Point2D;

public class GlassPane
extends JComponent
implements KeyListener,
Accessible {
    private JLECanvas _canvas;
    private transient boolean _skipFocusGrab = false;

    protected GlassPane(JLECanvas canvas) {
        this._canvas = canvas;
        this.setName(canvas.getName() + ".glassComponent");
        long mask = 60L;
        this.enableEvents(mask);
    }

    public void keyTyped(KeyEvent key) {
        this._redispatchToTool(key);
    }

    public void keyPressed(KeyEvent key) {
        this._redispatchToTool(key);
    }

    public void keyReleased(KeyEvent key) {
        this._redispatchToTool(key);
    }

    public boolean isInteriorTransparent() {
        return true;
    }

    public Dimension getPreferredSize() {
        return this._canvas.getSize();
    }

    protected JLECanvas getCanvas() {
        return this._canvas;
    }

    protected void processEvent(AWTEvent e) {
        super.processEvent(e);
        if (e.getID() == 501) {
            if (!this._skipFocusGrab) {
                this.requestFocus();
            } else {
                this._skipFocusGrab = false;
            }
        }
        if (this._canvas.JLEEventEnabled(e.getID())) {
            this._redispatchToTool(e);
        }
    }

    public void skipFocusGrab() {
        this._skipFocusGrab = true;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new Access();
        }
        return this.accessibleContext;
    }

    private void _redispatchToTool(AWTEvent e) {
        JLEEvent redispatched = null;
        int id = e.getID();
        switch (id) {
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                MouseEvent mouse = (MouseEvent)e;
                int modifiers = mouse.getModifiers();
                if ((modifiers & 0xFFFFFFFC) == 0) {
                    modifiers = 0x10 | modifiers;
                }
                Point canvas = this._canvas.convertOuterToCanvas(mouse.getX(), mouse.getY());
                Point2D newPoint = this._canvas.deviceToContent(canvas.x, canvas.y);
                redispatched = new JLEEvent(this, id, mouse.getWhen(), modifiers, newPoint.getX(), newPoint.getY(), mouse.getClickCount());
                break;
            }
            case 400: 
            case 401: 
            case 402: {
                KeyEvent key = (KeyEvent)e;
                redispatched = new JLEEvent(this, id, key.getWhen(), key.getModifiers(), key.getKeyCode(), key.getKeyChar());
                break;
            }
            case 1004: 
            case 1005: {
                FocusEvent focus = (FocusEvent)e;
                redispatched = new JLEEvent(this, id);
            }
        }
        this._canvas.processJLEEvent(redispatched);
        if (redispatched.isConsumed() && e instanceof InputEvent) {
            ((InputEvent)e).consume();
        }
    }

    private class Access
    extends JComponent.AccessibleJComponent {
        private Access() {
            super(GlassPane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.GLASS_PANE;
        }
    }
}

