/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.db2;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.db2.DMDB2BasicPanel;
import oracle.ide.util.ResourceUtils;

public class DMDB2ConnectionPanel
extends IConnectionPanel {
    public static String SUBTYPE_DB2 = "DB2";
    public static String CONNECTION_TYPE = "DB2";
    private static final long serialVersionUID = -9116356172775367840L;
    private DMDB2BasicPanel m_basicPanel;
    private JPanel m_panel;
    private CardLayout m_layout;
    public static final String HOST = "localhost";
    public static final String PORT = "50000";

    public DMDB2ConnectionPanel() {
        this.setLayout(new GridBagLayout());
        this.m_basicPanel = new DMDB2BasicPanel(this);
        this.m_layout = new CardLayout(0, 0);
        this.m_panel = new JPanel(this.m_layout);
        JLabel typeLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)typeLbl, null, (String)ConnectionDialogArb.getString((String)"CONNECTION_TYPE"));
        this.m_panel.add((Component)this.m_basicPanel, "Basic");
        this.add(this.m_panel, new GridBagConstraints(0, 2, 8, 1, 1.0, 4.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.m_layout.show(this.m_panel, "Basic");
    }

    private CDComponentView getPanel() {
        return this.m_basicPanel;
    }

    public void clear() {
        this.m_basicPanel.clear();
    }

    public Properties getConnectionProperties() {
        return this.getInput(this.m_props);
    }

    public String getConnectionType() {
        return "DB2";
    }

    public String getDriver() {
        return this.m_basicPanel.getDriver();
    }

    public String[] getSupportedDrivers() {
        return new String[]{this.getDriver()};
    }

    public void setDefaultPrompts() {
        this.m_basicPanel.setDefaultPrompts();
    }

    public void updatePrompts(Properties cd) {
        String hostname = cd.getProperty("hostname");
        this.m_basicPanel.m_tfdHost.setText(hostname);
        String port = cd.getProperty("port");
        this.m_basicPanel.m_tfdPort.setText(port != null ? port : PORT);
        String dataSource = cd.getProperty("dataSourceName");
        if (dataSource != null) {
            this.m_basicPanel.m_db2DataSource.setText(dataSource);
        }
        cd.setProperty("ConnName", this.getConnectionName());
        cd.setProperty("dataSourceName", this.m_basicPanel.m_db2DataSource.getText());
    }

    private Properties getInput(Properties cd) {
        cd.setProperty("subtype", SUBTYPE_DB2);
        cd.setProperty("RaptorConnectionType", CONNECTION_TYPE);
        cd.setProperty("dataSourceName", this.m_basicPanel.m_db2DataSource.getText());
        CDComponentView cdv = this.getPanel();
        cdv.generateProperties(cd);
        return cd;
    }
}

