/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.print;

import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import oracle.dbtools.crest.util.print.PrinterName;

final class Area
extends MediaSizeName {
    private static final OrientationRequested[] ORIENTATION = new OrientationRequested[]{OrientationRequested.LANDSCAPE, OrientationRequested.PORTRAIT, OrientationRequested.REVERSE_LANDSCAPE};
    private static final OrientationRequested[] ORIENTATION_REQUESTED = new OrientationRequested[]{OrientationRequested.LANDSCAPE, OrientationRequested.PORTRAIT, OrientationRequested.REVERSE_LANDSCAPE, OrientationRequested.REVERSE_PORTRAIT};
    private static final double PT_TO_INCH = 72.0;
    public static final int ORIENTATION_OFFSET = 3;
    private PrintRequestAttributeSet myAttributes = new HashPrintRequestAttributeSet();

    Area(String paperMediaName, int orientation, float x, float y, float width, float height, String printerName) {
        super(0);
        if (printerName != null && !"".equalsIgnoreCase(printerName)) {
            this.myAttributes.add(new PrinterName(printerName));
        }
        PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
        if (0 <= (orientation -= 3) && orientation < ORIENTATION_REQUESTED.length) {
            this.myAttributes.add(ORIENTATION_REQUESTED[orientation]);
        } else {
            this.myAttributes.add(this.getOrientationFromPageFormat(pageFormat));
        }
        this.myAttributes.add(this.getMedia(paperMediaName));
        if (x >= 0.0f && y >= 0.0f && width >= 0.0f && height >= 0.0f) {
            if (this.isReverseOrientation()) {
                this.myAttributes.add(new MediaPrintableArea(x, y, height, width, 25400));
            } else {
                this.myAttributes.add(new MediaPrintableArea(x, y, width, height, 25400));
            }
        } else {
            this.myAttributes.add(new MediaPrintableArea(this.toInch(pageFormat.getImageableX()), this.toInch(pageFormat.getImageableY()), this.toInch(pageFormat.getImageableWidth()), this.toInch(pageFormat.getImageableHeight()), 25400));
        }
    }

    private Media getMedia(String paperMediaName) {
        if (paperMediaName != null) {
            PrintService[] printServices;
            for (PrintService printer : printServices = PrintServiceLookup.lookupPrintServices(null, null)) {
                Media[] objs = (Media[])printer.getSupportedAttributeValues(Media.class, null, null);
                if (objs == null) continue;
                for (Media media : objs) {
                    if (!(media instanceof MediaSizeName) || MediaSize.getMediaSizeForName((MediaSizeName)media) == null || !paperMediaName.equalsIgnoreCase(media.toString())) continue;
                    return media;
                }
            }
        }
        return MediaSizeName.ISO_A4;
    }

    PrintRequestAttributeSet getAttributes() {
        return this.myAttributes;
    }

    int getOrientation() {
        int value = ((OrientationRequested)this.myAttributes.get(OrientationRequested.class)).getValue();
        switch (value) {
            case 3: {
                return 1;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 2;
            }
        }
        return 1;
    }

    private boolean isReverseOrientation() {
        OrientationRequested orientation = (OrientationRequested)this.myAttributes.get(OrientationRequested.class);
        return orientation == OrientationRequested.LANDSCAPE || orientation == OrientationRequested.REVERSE_LANDSCAPE;
    }

    float getPaperWidth() {
        return this.isReverseOrientation() ? this.getMediaSize().getY(25400) : this.getMediaSize().getX(25400);
    }

    float getPaperHeight() {
        return this.isReverseOrientation() ? this.getMediaSize().getX(25400) : this.getMediaSize().getY(25400);
    }

    int getPaperMedia() {
        return ((EnumSyntax)((Object)this.myAttributes.get(Media.class))).getValue();
    }

    private MediaSize getMediaSize() {
        MediaSizeName name = (MediaSizeName)this.getEnumValueTable()[this.getPaperMedia()];
        return MediaSize.getMediaSizeForName(name);
    }

    float getX() {
        return this.getArea().getX(25400);
    }

    float getY() {
        return this.getArea().getY(25400);
    }

    float getWidth() {
        return this.isReverseOrientation() ? this.getArea().getHeight(25400) : this.getArea().getWidth(25400);
    }

    float getHeight() {
        return this.isReverseOrientation() ? this.getArea().getWidth(25400) : this.getArea().getHeight(25400);
    }

    private MediaPrintableArea getArea() {
        return (MediaPrintableArea)this.myAttributes.get(MediaPrintableArea.class);
    }

    private float toInch(double pt) {
        return (float)(pt / 72.0);
    }

    private OrientationRequested getOrientationFromPageFormat(PageFormat pageFormat) {
        if (pageFormat == null) {
            return OrientationRequested.PORTRAIT;
        }
        int orientation = pageFormat.getOrientation();
        if (0 <= orientation && orientation < ORIENTATION.length) {
            return ORIENTATION[orientation];
        }
        return OrientationRequested.PORTRAIT;
    }

    public String getPrinterName() {
        PrinterName printerName = (PrinterName)this.myAttributes.get(PrinterName.class);
        if (printerName != null) {
            return printerName.getPrinterName();
        }
        return "";
    }

    public String getPaperMediaName() {
        return this.myAttributes.get(Media.class).toString();
    }
}

