/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JTextFieldLimited
extends JTextField {
    public JTextFieldLimited(int limit) {
        super(1);
        this.setDocument(new TextDocumentLimited(limit));
    }

    public JTextFieldLimited(int limit, String text) {
        super(1);
        this.setDocument(new TextDocumentLimited(limit));
        this.setText(text);
    }

    static class TextDocumentLimited
    extends PlainDocument {
        private int limit;

        TextDocumentLimited(int limit) {
            this.limit = limit;
        }

        @Override
        public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
            if (string != null) {
                if (this.getLength() + string.length() <= this.limit) {
                    super.insertString(offset, string, attributes);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }
}

