/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Messages;

public class ColumnsSortOrderModel
extends AbstractTableModel {
    final String[] COL_NAMES = new String[]{Messages.getString("ColumnsSortOrderModel.ColumnName"), Messages.getString("ColumnsSortOrderModel.SortOrder")};
    private ArrayList columns = new ArrayList();

    public ColumnsSortOrderModel(Index index) {
        Column[] cols = (Column[])index.getElements();
        for (int i = 0; i < cols.length; ++i) {
            this.columns.add(new ColumnNode(index, cols[i]));
        }
    }

    @Override
    public int getColumnCount() {
        return this.COL_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.columns.size();
    }

    public void dataChanged() {
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return this.COL_NAMES[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        ColumnNode cn = (ColumnNode)this.columns.get(row);
        if (col == 0) {
            return cn;
        }
        return cn.sortOrder;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (ApplicationView.IS_VIEWER || ApplicationView.LOGICAL_MODEL_ONLY) {
            return false;
        }
        return col != 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        ColumnNode cn = (ColumnNode)this.columns.get(row);
        if (col == 1) {
            cn.sortOrder = (String)value;
            this.fireTableCellUpdated(row, col);
        }
    }

    public void setUpSortOrderColumn(TableColumn sortColumn) {
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("ASC");
        comboBox.addItem("DESC");
        sortColumn.setCellEditor(new DefaultCellEditor(comboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(Messages.getString("ColumnsSortOrderModel.ClickFoComboBox"));
        sortColumn.setCellRenderer(renderer);
        TableCellRenderer headerRenderer = sortColumn.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText(Messages.getString("ColumnsSortOrderModel.ClickSortOrder"));
        }
    }

    public Collection getColumnsSortOrederColl() {
        return this.columns;
    }

    public class ColumnNode {
        public String name;
        public String objectId;
        public String sortOrder;

        ColumnNode(Index index, Column column) {
            this.name = column.getName();
            this.objectId = column.getObjectID();
            this.sortOrder = index.getColumnSortOrder(column);
        }

        public String toString() {
            return this.name;
        }
    }
}

