/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;

public class ViewColumnDTParser {
    private static List<String> numerics = new ArrayList<String>();
    private static List<String> dates = new ArrayList<String>();

    public static void main(String[] args) {
        System.out.println(ViewColumnDTParser.getDataTypeFroExpr("CONVERT([Char](3),RMC.CODCODNUM)", "SQL Server"));
        System.out.println(ViewColumnDTParser.getDataTypeFroExpr("CONVERT([Char](10),RMI.ITMITMTYP),", "SQL Server"));
        System.out.println(ViewColumnDTParser.getDataTypeFroExpr("CONVERT(DATE,CONVERT([Char](10),RVC.RVCEFFDTE)) ", "SQL Server"));
        System.out.println(ViewColumnDTParser.getDataTypeFroExpr("CAST( '22-Aug-2003' AS varchar2(30) )", "Oracle"));
        String ss = "CAST(MULTISET(\nSELECT object_name as oname, object_type\nFROM user_objects\nWHERE rownum <10) AS t_uob_type)";
        System.out.println(ViewColumnDTParser.getDataTypeFroExpr(ss, "Oracle"));
        System.out.println(ViewColumnDTParser.getDataTypeFroExpr("CAST(3.14 * 0.152 AS NUMBER(10,7))", "Oracle"));
        System.out.println(ViewColumnDTParser.getDataTypeFroExpr("CAST(SYSDATE AS TIMESTAMP WITH LOCAL TIME ZONE)", "Oracle"));
    }

    public static String getDataTypeFroExpr(String expression, String dbType) {
        String ucname = dbType.toUpperCase();
        String expr = expression.replaceAll("[ \t\n\f\r\u000b]+", " ").toUpperCase().trim();
        if (ucname.indexOf("ORACLE") > -1) {
            if ("SYSDATE".equalsIgnoreCase(expr) || "CURRENT_DATE".equalsIgnoreCase(expr)) {
                return "DATE";
            }
            if ("SYSTIMESTAMP".equalsIgnoreCase(expr) || "LOCALTIMESTAMP".equalsIgnoreCase(expr) || "CURRENT_TIMESTAMP".equalsIgnoreCase(expr)) {
                return "TIMESTAMP";
            }
            int ind = expr.indexOf(40);
            if (ind > 0) {
                String pref = expr.substring(0, ind);
                if ("LOCALTIMESTAMP".equalsIgnoreCase(expr) || "CURRENT_TIMESTAMP".equalsIgnoreCase(expr)) {
                    return "TIMESTAMP";
                }
                if ("TO_CHAR".equalsIgnoreCase(expr)) {
                    return "VARCHAR2";
                }
                if ("CAST".equals(pref)) {
                    return ViewColumnDTParser.parseCast(expr);
                }
                if (numerics.contains(pref)) {
                    return "NUMBER";
                }
                if (dates.contains(pref)) {
                    return "DATE";
                }
            }
        } else {
            int ind = expr.indexOf(40);
            if (ind > 0) {
                String pref = expr.substring(0, ind);
                if ("CAST".equals(pref)) {
                    return ViewColumnDTParser.parseCast(expr);
                }
                if ("CONVERT".equals(pref)) {
                    return ViewColumnDTParser.parseConvert(expr);
                }
            }
        }
        return null;
    }

    private static String parseCast(String espr) {
        int ind;
        String part = Token.getValBetweenBrackets(espr, 1);
        if (part != null && !part.isEmpty() && (ind = part.lastIndexOf(" AS ")) > 0 && part.length() > ind + 4) {
            String part2 = part.substring(ind + 4);
            if (part2.indexOf(91) > -1) {
                return part2.replaceFirst("[", "").replaceFirst("]", "");
            }
            return part2;
        }
        return null;
    }

    private static String parseConvert(String espr) {
        int ind;
        String part = Token.getValBetweenBrackets(espr, 1);
        if (part != null && !part.isEmpty() && (ind = part.indexOf(",")) > 0) {
            String part2 = part.substring(0, ind);
            if (part2.indexOf(91) > -1) {
                part2 = part2.replaceFirst("\\[", "");
                part2 = part2.replaceFirst("\\]", "");
            }
            if (part2.indexOf(40) > 0) {
                return part2;
            }
            return part2;
        }
        return null;
    }

    static {
        numerics.add("TO_NUMBER");
        numerics.add("ABS");
        numerics.add("ACOS");
        numerics.add("ASIN");
        numerics.add("ATAN");
        numerics.add("ATAN2");
        numerics.add("BITAND");
        numerics.add("CEIL");
        numerics.add("COS");
        numerics.add("COSH");
        numerics.add("EXP");
        numerics.add("FLOOR");
        numerics.add("LN");
        numerics.add("LOG");
        numerics.add("MOD");
        numerics.add("NANVL");
        numerics.add("POWER");
        numerics.add("REMAINDER");
        numerics.add("SIGN");
        numerics.add("SIN");
        numerics.add("SINH");
        numerics.add("SQRT");
        numerics.add("TAN");
        numerics.add("TANH");
        numerics.add("ASCII");
        numerics.add("INSTR");
        numerics.add("LENGTH");
        numerics.add("WIDTH_BUCKET");
        dates.add("TO_DATE");
        dates.add("ADD_MONTHS");
        dates.add("LAST_DAY");
        dates.add("NEXT_DAY");
    }
}

