/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.undo.FormatTV_Edit;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.util.ColorChooserDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class TopViewColorDialog
extends JDialog
implements ItemListener,
AbstractEditorConstants {
    private Object[] topViews;
    private JCheckBox chbUseCustomFormat = new JCheckBox("<html><body><b>" + Messages.getString("TopViewColorDialog.UseCustomFormat") + "</b>" + "</body>" + "</html>");
    private JCheckBox chbUseDefault = new JCheckBox("<html><body><b>" + Messages.getString("TopViewColorDialog.UseDefaultFormat") + "</b>" + "</body>" + "</html>");
    private JButton bnBackground;
    private JButton bnBorder;
    private JButton bnFontColor;
    private Color backgroundColor = null;
    private Color borderColor = null;
    private JComboBox fontList;
    private JComboBox sizeList;
    private JComboBox styleList;
    private JLabel lbPreview;
    private boolean enableFonts = false;
    private JList efList;
    private FontObject currentFO = null;
    private boolean selected = true;
    private List tempFonts;
    private DefaultFontAndColor dfc = null;
    private JButton bnCancel;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TopViewColorDialog.this.bnCancel.doClick();
        }
    };

    public TopViewColorDialog(Object[] topViews) {
        this(topViews, false);
    }

    public TopViewColorDialog(Object[] topViews, boolean thisViewOnly) {
        super(((TopView)topViews[0]).getApplicationView().getFrame());
        this.topViews = topViews;
        this.setTitle(Messages.getString("TopViewColorDialog.FormatObject"));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TopViewColorDialog.this.dispose();
            }
        });
        JPanel pnButtons = new JPanel();
        JButton bnOK = new JButton(new OKAction(Messages.getString("TopViewColorDialog.OK")));
        bnOK.setMnemonic(79);
        JButton bnApply = new JButton(new ApplyAction(Messages.getString("TopViewColorDialog.Apply")));
        bnApply.setMnemonic(65);
        this.bnCancel = new JButton(new CancelAction(Messages.getString("TopViewColorDialog.Cancel")));
        this.bnCancel.setMnemonic(67);
        pnButtons.add(bnOK);
        pnButtons.add(bnApply);
        pnButtons.add(this.bnCancel);
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JTabbedPane pane = new JTabbedPane();
        pane.addTab(Messages.getString("TopViewColorDialog.Colors"), this.initColorPanel());
        if (((TopView)topViews[0]).getModel() instanceof EditableFonts) {
            pane.addTab(Messages.getString("TopViewColorDialog.Font"), this.initFontPanel());
            this.enableFonts = true;
        }
        JPanel pnOptions = new JPanel(new GridLayout(0, 1, 10, 10));
        pnOptions.setBorder(BorderFactory.createEtchedBorder());
        JPanel pnUCF = new JPanel(new FlowLayout(3));
        JPanel pnCHB = new JPanel(new FlowLayout(3));
        pnUCF.add(this.chbUseCustomFormat);
        pnCHB.add(this.chbUseDefault);
        if (!thisViewOnly) {
            pnOptions.add(pnUCF);
        }
        pnOptions.add(pnCHB);
        if (this.dfc == null) {
            this.getContentPane().add((Component)pnOptions, "North");
            this.chbUseCustomFormat.setSelected(((TopView)topViews[0]).useCustomFormat());
            this.chbUseDefault.setSelected(((TopView)topViews[0]).useDefaultColor());
        }
        this.getContentPane().add((Component)pane, "Center");
        this.getContentPane().add((Component)pnButtons, "South");
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escapeAction);
        this.pack();
        this.setResizable(false);
        this.setModal(true);
        CommonUtil.centerOnScreen(this);
    }

    public TopViewColorDialog(DefaultFontAndColor dfc) {
        this.dfc = dfc;
        this.setTitle(MessageFormat.format(Messages.getString("TopViewColorDialog.Format"), dfc.getClassName()));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TopViewColorDialog.this.dispose();
            }
        });
        JPanel pnButtons = new JPanel();
        JButton bnOK = new JButton(new OKAction(Messages.getString("TopViewColorDialog.OK")));
        bnOK.setMnemonic(79);
        this.bnCancel = new JButton(new CancelAction(Messages.getString("TopViewColorDialog.Cancel")));
        this.bnCancel.setMnemonic(67);
        pnButtons.add(bnOK);
        pnButtons.add(this.bnCancel);
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JPanel pnOptions = new JPanel(new GridLayout(0, 1, 10, 10));
        pnOptions.setBorder(BorderFactory.createEtchedBorder());
        JPanel pnUCF = new JPanel(new FlowLayout(3));
        JPanel pnCHB = new JPanel(new FlowLayout(3));
        pnUCF.add(this.chbUseCustomFormat);
        pnCHB.add(this.chbUseDefault);
        pnOptions.add(pnUCF);
        pnOptions.add(pnCHB);
        JTabbedPane pane = new JTabbedPane();
        pane.addTab(Messages.getString("TopViewColorDialog.Colors"), this.initColorPanel());
        pane.addTab(Messages.getString("TopViewColorDialog.Font"), this.initFontPanel());
        this.enableFonts = true;
        if (this.dfc == null) {
            this.getContentPane().add((Component)pnOptions, "North");
            this.chbUseCustomFormat.setSelected(((TopView)this.topViews[0]).useCustomFormat());
            this.chbUseDefault.setSelected(((TopView)this.topViews[0]).useDefaultColor());
        }
        this.getContentPane().add((Component)pane, "Center");
        this.getContentPane().add((Component)pnButtons, "South");
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escapeAction);
        this.pack();
        this.setResizable(false);
        this.setModal(true);
        CommonUtil.centerOnScreen(this);
    }

    private JPanel initColorPanel() {
        CellViewRenderer renderer;
        AbstractCellView cellView;
        CellViewRenderer renderer2;
        AbstractCellView cellView2;
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel pnTop = new JPanel(new GridLayout(0, 1, 10, 10));
        pnTop.setBorder(BorderFactory.createEtchedBorder());
        pnTop.add(new JPanel());
        this.chbUseDefault.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TopViewColorDialog.this.bnBackground.setEnabled(false);
                    TopViewColorDialog.this.bnBorder.setEnabled(false);
                    TopViewColorDialog.this.fontList.setEnabled(false);
                    TopViewColorDialog.this.sizeList.setEnabled(false);
                    TopViewColorDialog.this.styleList.setEnabled(false);
                    TopViewColorDialog.this.bnFontColor.setEnabled(false);
                } else {
                    TopViewColorDialog.this.bnBackground.setEnabled(true);
                    TopViewColorDialog.this.bnBorder.setEnabled(true);
                    TopViewColorDialog.this.bnFontColor.setEnabled(true);
                    if (TopViewColorDialog.this.currentFO != null) {
                        TopViewColorDialog.this.fontList.setEnabled(TopViewColorDialog.this.currentFO.isFontEnabled());
                        TopViewColorDialog.this.sizeList.setEnabled(TopViewColorDialog.this.currentFO.isFontEnabled());
                        TopViewColorDialog.this.styleList.setEnabled(TopViewColorDialog.this.currentFO.isFontEnabled());
                    } else {
                        TopViewColorDialog.this.fontList.setEnabled(true);
                        TopViewColorDialog.this.sizeList.setEnabled(true);
                        TopViewColorDialog.this.styleList.setEnabled(true);
                    }
                }
            }
        });
        this.bnBackground = new JButton();
        this.backgroundColor = this.dfc != null ? this.dfc.getBackgroundColor() : ((TopView)this.topViews[0]).getBackgroundColor();
        if (this.backgroundColor == null && (cellView2 = ((TopView)this.topViews[0]).getCellView()) != null && (renderer2 = cellView2.getRenderer()) != null) {
            this.backgroundColor = renderer2.getBGColor();
        }
        if (this.backgroundColor != null) {
            this.bnBackground.setBackground(this.backgroundColor);
        }
        this.bnBackground.setPreferredSize(new Dimension(140, 20));
        this.bnBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ColorChooserDialog colorDialog = new ColorChooserDialog((Dialog)TopViewColorDialog.this, Messages.getString("TopViewColorDialog.SelectBackgroundColor"), TopViewColorDialog.this.bnBackground.getBackground());
                Color newColor = colorDialog.showDialog();
                if (newColor != null) {
                    TopViewColorDialog.this.backgroundColor = newColor;
                    TopViewColorDialog.this.bnBackground.setBackground(TopViewColorDialog.this.backgroundColor);
                }
            }
        });
        JLabel lbBackground = new JLabel(Messages.getString("TopViewColorDialog.BackgroundColor"));
        lbBackground.setPreferredSize(new Dimension(140, 20));
        JPanel pnBackground = new JPanel(new FlowLayout(3));
        pnBackground.add(lbBackground);
        pnBackground.add(this.bnBackground);
        pnTop.add(pnBackground);
        this.bnBorder = new JButton();
        this.borderColor = this.dfc != null ? this.dfc.getForegroundColor() : ((TopView)this.topViews[0]).getForegroundColor();
        if (this.borderColor == null && (cellView = ((TopView)this.topViews[0]).getCellView()) != null && (renderer = cellView.getRenderer()) != null) {
            this.borderColor = renderer.getFGColor();
        }
        if (this.borderColor != null) {
            this.bnBorder.setBackground(this.borderColor);
        }
        this.bnBorder.setPreferredSize(this.bnBackground.getPreferredSize());
        this.bnBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ColorChooserDialog colorDialog = new ColorChooserDialog((Dialog)TopViewColorDialog.this, Messages.getString("TopViewColorDialog.SelectBorderColor"), TopViewColorDialog.this.bnBorder.getBackground());
                Color newColor = colorDialog.showDialog();
                if (newColor != null) {
                    TopViewColorDialog.this.borderColor = newColor;
                    TopViewColorDialog.this.bnBorder.setBackground(TopViewColorDialog.this.borderColor);
                }
            }
        });
        JLabel lbBorder = new JLabel(Messages.getString("TopViewColorDialog.BorderColor"));
        lbBorder.setPreferredSize(new Dimension(140, 20));
        JPanel pnForeground = new JPanel(new FlowLayout(3));
        pnForeground.add(lbBorder);
        pnForeground.add(this.bnBorder);
        pnTop.add(pnForeground);
        pnTop.add(new JPanel());
        jpanel.add(pnTop);
        return jpanel;
    }

    private JPanel initFontPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        Iterator efi = this.dfc != null ? this.dfc.getEditableFonts().iterator() : (((TopView)this.topViews[0]).getEditableFonts().size() > 0 ? ((TopView)this.topViews[0]).getEditableFonts().iterator() : ((TopView)this.topViews[0]).getDefaultEditableFonts().iterator());
        this.tempFonts = new ArrayList();
        while (efi.hasNext()) {
            FontObject next = (FontObject)efi.next();
            this.tempFonts.add(next.copy());
        }
        this.efList = new JList<Object>(this.tempFonts.toArray());
        this.efList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (TopViewColorDialog.this.efList.getSelectedIndex() > -1) {
                    TopViewColorDialog.this.selected = false;
                    TopViewColorDialog.this.currentFO = (FontObject)TopViewColorDialog.this.efList.getSelectedValue();
                    if (TopViewColorDialog.this.chbUseDefault.isSelected()) {
                        TopViewColorDialog.this.fontList.setEnabled(false);
                        TopViewColorDialog.this.sizeList.setEnabled(false);
                        TopViewColorDialog.this.styleList.setEnabled(false);
                    } else {
                        TopViewColorDialog.this.fontList.setEnabled(TopViewColorDialog.this.currentFO.isFontEnabled());
                        TopViewColorDialog.this.sizeList.setEnabled(TopViewColorDialog.this.currentFO.isFontEnabled());
                        TopViewColorDialog.this.styleList.setEnabled(TopViewColorDialog.this.currentFO.isFontEnabled());
                    }
                    TopViewColorDialog.this.fontList.setSelectedItem(TopViewColorDialog.this.currentFO.getFont().getName());
                    TopViewColorDialog.this.sizeList.setSelectedItem(new Integer(TopViewColorDialog.this.currentFO.getFont().getSize()));
                    TopViewColorDialog.this.styleList.setSelectedIndex(TopViewColorDialog.this.currentFO.getFont().getStyle());
                    TopViewColorDialog.this.bnFontColor.setBackground(TopViewColorDialog.this.currentFO.getColor());
                    TopViewColorDialog.this.lbPreview.setForeground(TopViewColorDialog.this.currentFO.getColor());
                    TopViewColorDialog.this.lbPreview.setFont(TopViewColorDialog.this.currentFO.getFont());
                    TopViewColorDialog.this.lbPreview.setText(TopViewColorDialog.this.currentFO.getFont().getName());
                    TopViewColorDialog.this.selected = true;
                }
            }
        });
        JPanel pnMain = new JPanel(new BorderLayout());
        JPanel pnLeft = new JPanel(new BorderLayout());
        pnLeft.setBorder(BorderFactory.createEtchedBorder());
        pnLeft.add((Component)new JLabel(Messages.getString("TopViewColorDialog.Symbol")), "North");
        JScrollPane sp = new JScrollPane(this.efList);
        sp.setPreferredSize(new Dimension(140, 140));
        pnLeft.add((Component)sp, "Center");
        pnMain.add((Component)pnLeft, "West");
        JPanel pnTop = new JPanel(new GridLayout(0, 1, 10, 10));
        pnTop.setBorder(BorderFactory.createEtchedBorder());
        this.fontList = new JComboBox();
        this.sizeList = new JComboBox();
        this.styleList = new JComboBox<Object>(new Object[]{Messages.getString("TopViewColorDialog.Regular"), Messages.getString("TopViewColorDialog.Bold"), Messages.getString("TopViewColorDialog.Italic"), Messages.getString("TopViewColorDialog.BoldItalic")});
        this.fontList.setPreferredSize(new Dimension(200, 20));
        this.fontList.setMaximumRowCount(20);
        this.sizeList.setPreferredSize(new Dimension(60, 20));
        this.styleList.setPreferredSize(new Dimension(70, 20));
        this.sizeList.setMaximumRowCount(20);
        JPanel pnName = new JPanel(new FlowLayout(3));
        JLabel lbName = new JLabel(Messages.getString("TopViewColorDialog.Name"));
        lbName.setPreferredSize(new Dimension(60, 20));
        pnName.add(lbName);
        pnName.add(this.fontList);
        pnTop.add(pnName);
        JPanel pnSize = new JPanel(new FlowLayout(3));
        JLabel lbSize = new JLabel(Messages.getString("TopViewColorDialog.Size"));
        lbSize.setPreferredSize(lbName.getPreferredSize());
        pnSize.add(lbSize);
        pnSize.add(this.sizeList);
        pnTop.add(pnSize);
        JPanel pnStyle = new JPanel(new FlowLayout(3));
        JLabel lbStyle = new JLabel(Messages.getString("TopViewColorDialog.Style"));
        lbStyle.setPreferredSize(lbName.getPreferredSize());
        pnStyle.add(lbStyle);
        pnStyle.add(this.styleList);
        pnTop.add(pnStyle);
        this.bnFontColor = new JButton();
        this.bnFontColor.setPreferredSize(new Dimension(140, 20));
        this.bnFontColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ColorChooserDialog colorDialog = new ColorChooserDialog((Dialog)TopViewColorDialog.this, Messages.getString("TopViewColorDialog.SelectFontColor"), TopViewColorDialog.this.bnFontColor.getBackground());
                Color newColor = colorDialog.showDialog();
                if (newColor != null) {
                    TopViewColorDialog.this.bnFontColor.setBackground(newColor);
                    TopViewColorDialog.this.lbPreview.setForeground(newColor);
                    if (TopViewColorDialog.this.currentFO != null) {
                        TopViewColorDialog.this.currentFO.setColor(newColor);
                    }
                }
            }
        });
        JLabel lbColor = new JLabel(Messages.getString("TopViewColorDialog.Color"));
        lbColor.setPreferredSize(lbName.getPreferredSize());
        JPanel pnColor = new JPanel(new FlowLayout(3));
        pnColor.add(lbColor);
        pnColor.add(this.bnFontColor);
        pnTop.add(pnColor);
        JPanel pnPreview = new JPanel(new BorderLayout());
        pnPreview.setPreferredSize(new Dimension(200, 80));
        this.lbPreview = new JLabel();
        this.lbPreview.setHorizontalAlignment(0);
        pnPreview.add(this.lbPreview);
        pnPreview.setBorder(BorderFactory.createTitledBorder(Messages.getString("TopViewColorDialog.Preview")));
        pnPreview.setBackground(Color.WHITE);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = ge.getAvailableFontFamilyNames();
        for (int i = 0; i < fonts.length; ++i) {
            this.fontList.addItem(fonts[i]);
        }
        for (int j = 6; j < 73; ++j) {
            this.sizeList.addItem(new Integer(j));
        }
        this.fontList.addItemListener(this);
        this.sizeList.addItemListener(this);
        this.styleList.addItemListener(this);
        this.efList.setSelectedIndex(0);
        pnMain.add((Component)pnTop, "Center");
        jpanel.add((Component)pnMain, "North");
        jpanel.add(pnPreview);
        return jpanel;
    }

    private void setTopView() {
        if (this.dfc != null) {
            if (!this.dfc.getBackgroundColor().equals(this.backgroundColor) || !this.dfc.getForegroundColor().equals(this.borderColor)) {
                DefaultFontAndColor.setModified(this.dfc.getClassName());
            }
            this.dfc.setBackgroundColor(this.backgroundColor);
            this.dfc.setForegroundColor(this.borderColor);
            for (FontObject next : this.tempFonts) {
                FontObject fo = this.dfc.getFontObject(next.getType());
                if (fo == null) continue;
                this.dfc.getEditableFonts().remove(fo);
                this.dfc.getEditableFonts().add(next.copy());
            }
        } else {
            TopView topView;
            int i;
            FormatTV_Edit fedit = null;
            fedit = this.enableFonts ? new FormatTV_Edit(this.topViews, this.chbUseCustomFormat.isSelected(), this.chbUseDefault.isSelected(), this.backgroundColor, this.borderColor, this.tempFonts) : new FormatTV_Edit(this.topViews, this.chbUseCustomFormat.isSelected(), this.chbUseDefault.isSelected(), this.backgroundColor, this.borderColor, new ArrayList());
            fedit.applyUpdates();
            fedit.end();
            ((TopView)this.topViews[0]).getModel().getDesignPart().postUndoableEdit(fedit);
            for (i = 0; i < this.topViews.length; ++i) {
                topView = (TopView)this.topViews[i];
                topView.getModel().setDirty(true);
            }
            for (i = 0; i < fedit.getTopViews().length; ++i) {
                topView = (TopView)fedit.getTopViews()[i];
                topView.getDesignPartView().setDirty(true);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.selected && this.currentFO != null) {
            String temp = (String)this.fontList.getSelectedItem();
            int size = (Integer)this.sizeList.getSelectedItem();
            int style = this.styleList.getSelectedIndex();
            Font currentFont = new Font(temp.trim(), style, size);
            this.currentFO.setFont(currentFont);
            this.lbPreview.setText(temp.trim());
            this.lbPreview.setFont(currentFont);
            this.lbPreview.repaint();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TopViewColorDialog.this.dispose();
        }
    }

    private class ApplyAction
    extends AbstractAction {
        public ApplyAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TopViewColorDialog.this.setTopView();
            if (TopViewColorDialog.this.dfc == null) {
                ((TopView)TopViewColorDialog.this.topViews[0]).getCellView().getDiagram().repaint();
            }
        }
    }

    private class OKAction
    extends AbstractAction {
        public OKAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TopViewColorDialog.this.setTopView();
            TopViewColorDialog.this.dispose();
        }
    }
}

