/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectVersionDialog
extends JDialog {
    private static final String KEY_ESCAPE = "ESCAPE";
    private JTable jtable;
    private JTable desTable;
    private AbstractRepositoryManager.DesignDescriptor result = null;
    private List elmList;
    private List desList;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectVersionDialog.this.dispose();
        }
    };

    public SelectVersionDialog(Frame owner) {
        super(owner, Messages.getString("SelectVersionDialog.SelectDesignAndRepositoryVersion"), true);
        this.getContentPane().add((Component)this.init(), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        this.setSize(new Dimension(700, 350));
        CommonUtil.centerOnScreen(this);
    }

    private void loadVersions(AbstractRepositoryManager.DesignDescriptor desObj) {
        this.elmList.clear();
        try {
            this.elmList.add(0, new Version(desObj.v_sequence, desObj.date_created, desObj.checkout_by));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jtable.updateUI();
        if (this.elmList.size() > 0) {
            this.jtable.setRowSelectionInterval(0, 0);
        }
    }

    private void loadDesigns(List list) {
        try {
            for (AbstractRepositoryManager.DesignDescriptor next : list) {
                this.desList.add(next);
            }
            this.desTable.updateUI();
            if (this.desList.size() > 0) {
                this.desTable.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JPanel init() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.desList = new ArrayList();
        this.desTable = new JTable(new DesignTableModel());
        this.desTable.setSelectionMode(0);
        this.desTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = SelectVersionDialog.this.desTable.getSelectedRow();
                if (row != -1 && SelectVersionDialog.this.desList.size() > 0 && row < SelectVersionDialog.this.desList.size()) {
                    AbstractRepositoryManager.DesignDescriptor desObj = (AbstractRepositoryManager.DesignDescriptor)SelectVersionDialog.this.desList.get(row);
                    SelectVersionDialog.this.loadVersions(desObj);
                }
            }
        });
        JScrollPane spd = new JScrollPane(this.desTable);
        this.elmList = new ArrayList();
        this.jtable = new JTable(new ElementTableModel());
        this.jtable.setSelectionMode(0);
        DefaultTableCellRenderer tcrColumn = new DefaultTableCellRenderer();
        tcrColumn.setHorizontalAlignment(0);
        this.jtable.getColumnModel().getColumn(0).setCellRenderer(tcrColumn);
        this.jtable.getColumnModel().getColumn(1).setCellRenderer(tcrColumn);
        this.jtable.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.jtable.getColumnModel().getColumn(0).setMaxWidth(60);
        this.jtable.getColumnModel().getColumn(1).setPreferredWidth(120);
        this.jtable.getColumnModel().getColumn(1).setMaxWidth(120);
        JScrollPane sp = new JScrollPane(this.jtable);
        JSplitPane splitPane = new JSplitPane(1, spd, sp);
        splitPane.setDividerLocation(342);
        jpanel.add(splitPane);
        return jpanel;
    }

    public JPanel getBottomPanel() {
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        JButton bnOK = new JButton(Messages.getString("SelectVersionDialog.OK"));
        bnOK.setMnemonic(79);
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractRepositoryManager.DesignDescriptor desObj = null;
                int rowA = SelectVersionDialog.this.desTable.getSelectedRow();
                if (rowA != -1 && SelectVersionDialog.this.desList.size() > 0 && rowA < SelectVersionDialog.this.desList.size()) {
                    desObj = (AbstractRepositoryManager.DesignDescriptor)SelectVersionDialog.this.desList.get(rowA);
                }
                SelectVersionDialog.this.result = desObj;
                SelectVersionDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(bnOK);
        bottomPanel.add(bnOK);
        JButton bnCancel = new JButton(Messages.getString("SelectVersionDialog.Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectVersionDialog.this.dispose();
            }
        });
        bottomPanel.add(bnCancel);
        return bottomPanel;
    }

    public AbstractRepositoryManager.DesignDescriptor getResult() {
        return this.result;
    }

    public static AbstractRepositoryManager.DesignDescriptor showDialog(Frame owner, List list) {
        SelectVersionDialog dialog = new SelectVersionDialog(owner);
        dialog.loadDesigns(list);
        dialog.setVisible(true);
        return dialog.getResult();
    }

    private class Version {
        int version;
        String date;
        String checkout_by;

        public Version(int version, String date, String checkoutby) {
            this.version = version;
            this.date = date;
            this.checkout_by = checkoutby == null ? "" : checkoutby;
        }
    }

    private class ElementTableModel
    extends AbstractTableModel {
        private ElementTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return SelectVersionDialog.this.elmList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SelectVersionDialog.Version");
            }
            if (column == 1) {
                return Messages.getString("SelectVersionDialog.Date");
            }
            if (column == 2) {
                return Messages.getString("SelectVersionDialog.SelectVersionDialog.CheckoutBy");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Version version = (Version)SelectVersionDialog.this.elmList.get(row);
            if (col == 0) {
                return version.version;
            }
            if (col == 1) {
                return version.date;
            }
            if (col == 2) {
                return version.checkout_by;
            }
            return new Integer(row * col);
        }
    }

    private class DesignTableModel
    extends AbstractTableModel {
        private DesignTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SelectVersionDialog.this.desList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SelectVersionDialog.DesignName");
            }
            if (column == 1) {
                return Messages.getString("SelectVersionDialog.Comment");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            AbstractRepositoryManager.DesignDescriptor desObj = (AbstractRepositoryManager.DesignDescriptor)SelectVersionDialog.this.desList.get(row);
            if (col == 0) {
                return desObj.name;
            }
            if (col == 1) {
                return desObj.short_description;
            }
            return new Integer(row * col);
        }
    }
}

