/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class SelectObjectDialog
extends CustomDialog {
    protected JDialog dialog;
    private JPanel mainPanel;
    private JPanel buttonsPanel;
    private JButton btnOk;
    private JButton btnClose;
    private JLabel lblFilter;
    private FilteredJList availableObjectsList = new FilteredJList();
    private Object selectedObject;
    private static final Logger LOGGER = new Logger(SelectObjectDialog.class);

    public SelectObjectDialog(ApplicationView appView, List lovList, Object selectedObject) {
        super(appView);
        this.initObjectsPanel();
        this.initButtonsPanel();
        this.availableObjectsList.addItem(" ");
        for (Object item : lovList) {
            if (item == null) continue;
            this.availableObjectsList.addItem(item);
        }
        if (selectedObject != null && selectedObject != "") {
            this.availableObjectsList.setSelectedValue(selectedObject, true);
        }
        this.availableObjectsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SelectObjectDialog.this.btnOk.doClick();
                }
            }
        });
    }

    private void initObjectsPanel() {
        this.mainPanel = new JPanel((LayoutManager)new MigLayout(new LC().fill().flowY()));
        this.mainPanel.setPreferredSize(new Dimension(300, 500));
        this.availableObjectsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SelectObjectDialog.this.availableObjectsList.getSelectedIndex() == -1) {
                    SelectObjectDialog.this.btnOk.setEnabled(false);
                } else {
                    SelectObjectDialog.this.btnOk.setEnabled(true);
                }
            }
        });
        JPanel pnList = new JPanel((LayoutManager)new MigLayout("fill", "0[]0", "0[]0[grow]0"));
        pnList.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectObjectDialog.AvailableObjects")));
        JScrollPane pane = new JScrollPane(this.availableObjectsList);
        pnList.add((Component)pane, new CC().grow().height("1000"));
        this.lblFilter = new JLabel(Messages.getString("SelectObjectDialog.Filter"));
        this.lblFilter.setPreferredSize(new Dimension(50, 20));
        this.lblFilter.setMinimumSize(new Dimension(50, 20));
        this.lblFilter.setMaximumSize(new Dimension(50, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        JTextField tf = this.availableObjectsList.getFilterField();
        tf.setPreferredSize(new Dimension(200, 20));
        tf.setMinimumSize(new Dimension(200, 20));
        tf.setMaximumSize(new Dimension(200, 20));
        toolBar.add(new JLabel("  "));
        toolBar.add(this.lblFilter);
        toolBar.add(tf);
        this.mainPanel.add((Component)toolBar, new CC().gapTop("5").dockNorth());
        this.mainPanel.add((Component)pnList, new CC().grow().gapTop("10"));
        this.add((Component)this.mainPanel, "Center");
    }

    private void initButtonsPanel() {
        this.buttonsPanel = new JPanel(new FlowLayout(1));
        this.btnOk = new JButton(Messages.getString("SelectObjectDialog.OK"));
        this.btnOk.setEnabled(false);
        this.btnOk.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnOk.addActionListener(new OKAction());
        this.btnOk.setMnemonic(79);
        this.buttonsPanel.add(this.btnOk);
        this.btnClose = new JButton(Messages.getString("SelectObjectDialog.Close"));
        this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnClose.addActionListener(new SoCloseAction());
        this.btnClose.setMnemonic(67);
        this.buttonsPanel.add(this.btnClose);
        this.mainPanel.add((Component)this.buttonsPanel, "South");
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectObjectDialog.SelectObject"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    public Object showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.selectedObject;
    }

    public Object getSelectedObject() {
        return this.selectedObject;
    }

    public DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.getSize() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                if (((ModelIDObject)list.get(i)).getName().compareTo(((ModelIDObject)list.get(i - 1)).getName()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private static boolean match(String string, String regex) {
        if ("*".equalsIgnoreCase(regex)) {
            return true;
        }
        if (regex.indexOf(42) > -1) {
            regex = regex.replaceAll("\\*", "\\.*");
        }
        Pattern p = null;
        try {
            p = Pattern.compile(regex, 2);
            Matcher m = p.matcher(string);
            return m.find();
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
    }

    public class FilteredJList
    extends JList {
        private FilterField filterField;
        private int DEFAULT_FIELD_WIDTH = 20;

        public FilteredJList() {
            this.setModel((ListModel)new FilterModel());
            this.filterField = new FilterField(this.DEFAULT_FIELD_WIDTH);
        }

        public void setModel(ListModel m) {
            if (!(m instanceof FilterModel)) {
                throw new IllegalArgumentException();
            }
            super.setModel(m);
        }

        public void addItem(Object o) {
            ((FilterModel)this.getModel()).addElement(o);
        }

        public JTextField getFilterField() {
            return this.filterField;
        }

        class FilterModel
        extends DefaultListModel {
            ArrayList items = new ArrayList();
            ArrayList filterItems = new ArrayList();

            @Override
            public Object getElementAt(int index) {
                if (index < this.filterItems.size()) {
                    return this.filterItems.get(index);
                }
                return null;
            }

            @Override
            public int getSize() {
                return this.filterItems.size();
            }

            public void addElement(Object o) {
                this.items.add(o);
                this.refilter();
            }

            private void refilter() {
                this.filterItems.clear();
                String term = FilteredJList.this.getFilterField().getText();
                for (int i = 0; i < this.items.size(); ++i) {
                    if (!SelectObjectDialog.match(this.items.get(i).toString(), term)) continue;
                    this.filterItems.add(this.items.get(i));
                }
                this.fireContentsChanged(this, 0, this.getSize());
                SelectObjectDialog.this.sort(this);
            }
        }

        class FilterField
        extends JTextField
        implements DocumentListener {
            public FilterField(int width) {
                super(width);
                this.getDocument().addDocumentListener(this);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ((FilterModel)FilteredJList.this.getModel()).refilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ((FilterModel)FilteredJList.this.getModel()).refilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ((FilterModel)FilteredJList.this.getModel()).refilter();
            }
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectObjectDialog.this.selectedObject = SelectObjectDialog.this.availableObjectsList.getSelectedValue();
            SelectObjectDialog.this.close();
        }
    }

    private class SoCloseAction
    implements ActionListener {
        private SoCloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectObjectDialog.this.close();
        }
    }
}

