/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import oracle.dbtools.crest.fcp.extension.EXTDropHandler;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ideri.util.Product;

public class Extension {
    public static final String EXTENSION_ID = "oracle.datamodeler";
    public static final String VIEWER_EXTENSION_ID = "oracle.datamodeler.viewer";
    public static final String SVN_EXTENSION_ID = "oracle.jdeveloper.subversion";
    public static final String URL_ENCODING_CHARSET = "UTF-8";
    public static boolean isExtension = true;
    private static String extVersion = null;
    public static final String FIRST_RUN_CHECK_FILE = ".dmfr";

    public static String getExtensionVersion() {
        if (extVersion == null) {
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            javax.ide.extension.Extension ext = er.findExtension(Extension.getExtensionID());
            extVersion = ext != null ? ext.getName() + " " + ext.getVersion().toString() : Messages.getString("Extension.Version");
        }
        return extVersion;
    }

    public static boolean isViewer() {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        javax.ide.extension.Extension ext = er.findExtension(VIEWER_EXTENSION_ID);
        return ext != null;
    }

    public static boolean isSVNExtensionLoaded() {
        ExtensionRegistry er;
        javax.ide.extension.Extension ext;
        ApplicationView appView = null;
        if (!ApplicationView.instantiating) {
            if (!Extension.isDataModeler()) {
                EXTDropHandler extDropHandler = new EXTDropHandler();
                appView = ApplicationView.getInstance(extDropHandler);
                extDropHandler.setApplicationView(appView);
            } else {
                appView = ApplicationView.getInstance();
            }
            if (appView != null && !appView.getSettings().isUseVersioningFunctionality()) {
                return false;
            }
        }
        return (ext = (er = ExtensionRegistry.getExtensionRegistry()).findExtension(SVN_EXTENSION_ID)) != null;
    }

    public static String getExtensionID() {
        if (Extension.isViewer()) {
            return VIEWER_EXTENSION_ID;
        }
        return EXTENSION_ID;
    }

    public static boolean isDataModeler() {
        return EXTENSION_ID.equals(Product.getProductID());
    }

    public static String getBaseDir() {
        if (!Extension.isDataModeler()) {
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            javax.ide.extension.Extension ext = er.findExtension(Extension.getExtensionID());
            if (ext != null) {
                String path = er.getInstallDirectory(ext).getAbsolutePath();
                try {
                    path = URLDecoder.decode(path, URL_ENCODING_CHARSET);
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                return path;
            }
        } else {
            File parent;
            File extJAR;
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            javax.ide.extension.Extension ext = er.findExtension(Extension.getExtensionID());
            if (ext != null && (extJAR = er.getExtensionJAR(ext)) != null && (parent = extJAR.getParentFile()) != null) {
                String path = parent.getParent();
                try {
                    path = URLDecoder.decode(path, URL_ENCODING_CHARSET);
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                return path;
            }
        }
        return null;
    }

    public static boolean isFirstRun() {
        String sysPath = Ide.getSystemDirectory();
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        javax.ide.extension.Extension ext = er.findExtension(Extension.getExtensionID());
        if (ext != null) {
            String dmPath = "o.datamodeler." + ext.getVersion().toString();
            File idePrefsFile = new File(sysPath, dmPath);
            if (!idePrefsFile.exists()) {
                idePrefsFile = new File(sysPath, "o.datamodeler");
            }
            return !(idePrefsFile = new File(idePrefsFile.getAbsolutePath(), FIRST_RUN_CHECK_FILE)).exists();
        }
        return false;
    }

    public static void createFurstRunCheckFile() {
        String sysPath = Ide.getSystemDirectory();
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        javax.ide.extension.Extension ext = er.findExtension(Extension.getExtensionID());
        if (ext != null) {
            String dmPath = "o.datamodeler." + ext.getVersion().toString();
            File frcFile = new File(sysPath, dmPath);
            if (!frcFile.exists()) {
                frcFile = new File(sysPath, "o.datamodeler");
            }
            if (!(frcFile = new File(frcFile.getAbsolutePath(), FIRST_RUN_CHECK_FILE)).exists()) {
                try {
                    frcFile.createNewFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }
}

