/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DBLoginDialog
extends JDialog {
    private static final String KEY_ESCAPE = "ESCAPE";
    private JTextField tfUserName;
    private JPasswordField pfPassword;
    private String userName = null;
    private String password = null;
    private boolean result = false;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DBLoginDialog.this.dispose();
        }
    };

    public DBLoginDialog(Frame owner) {
        super(owner, Messages.getString("DBLoginDialog.DBLoginDialog.ConnectionInformation"), true);
        this.getContentPane().add((Component)this.init(), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.setResizable(false);
        this.pack();
        CommonUtil.centerOnScreen(this);
    }

    public DBLoginDialog() {
        this(ApplicationView.frame);
    }

    protected JPanel newRow(JLabel lbName, Component field) {
        JPanel newRow = new JPanel();
        newRow.add(lbName);
        newRow.add(field);
        return newRow;
    }

    private JPanel init() {
        JPanel jpanel = new JPanel(new GridLayout(0, 1));
        JLabel lbUserName = new JLabel(Messages.getString("DBLoginDialog.DBLoginDialog.Username"));
        this.tfUserName = new JTextField();
        this.tfUserName.setPreferredSize(new Dimension(200, 20));
        jpanel.add(this.newRow(lbUserName, this.tfUserName));
        JLabel lbPassword = new JLabel(Messages.getString("PasswordDialog.Password"));
        this.pfPassword = new JPasswordField();
        this.pfPassword.setPreferredSize(new Dimension(200, 20));
        jpanel.add(this.newRow(lbPassword, this.pfPassword));
        return jpanel;
    }

    public JPanel getBottomPanel() {
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        JButton bnOK = new JButton(Messages.getString("PasswordDialog.OK"));
        bnOK.setMnemonic(79);
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean canExit = true;
                DBLoginDialog.this.userName = DBLoginDialog.this.tfUserName.getText();
                if ("".equalsIgnoreCase(DBLoginDialog.this.userName)) {
                    canExit = false;
                    MessageDialogs.showErrorMessage(Messages.getString("DBLoginDialog.DBLoginDialog.ValidationFailed"), Messages.getString("DBLoginDialog.DBLoginDialog.UsernameRequired"));
                    DBLoginDialog.this.tfUserName.requestFocus();
                    return;
                }
                DBLoginDialog.this.password = String.valueOf(DBLoginDialog.this.pfPassword.getPassword());
                if ("".equalsIgnoreCase(DBLoginDialog.this.password)) {
                    canExit = false;
                    MessageDialogs.showErrorMessage(Messages.getString("DBLoginDialog.DBLoginDialog.ValidationFailed"), Messages.getString("DBLoginDialog.DBLoginDialog.PasswordRequired"));
                    DBLoginDialog.this.pfPassword.requestFocus();
                    return;
                }
                if (canExit) {
                    DBLoginDialog.this.result = true;
                    DBLoginDialog.this.dispose();
                }
            }
        });
        this.getRootPane().setDefaultButton(bnOK);
        bottomPanel.add(bnOK);
        JButton bnCancel = new JButton(Messages.getString("PasswordDialog.Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBLoginDialog.this.userName = null;
                DBLoginDialog.this.password = null;
                DBLoginDialog.this.result = false;
                DBLoginDialog.this.dispose();
            }
        });
        bottomPanel.add(bnCancel);
        return bottomPanel;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean showDialog(String username) {
        return this.showDialog(username, true);
    }

    public boolean showDialog(String username, boolean canChangeUser) {
        if (username == null) {
            username = "";
        }
        this.tfUserName.setText(username);
        this.tfUserName.setEnabled(canChangeUser);
        if (!"".equalsIgnoreCase(username)) {
            this.pfPassword.requestFocus();
        }
        this.setVisible(true);
        return this.result;
    }
}

