/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import oracle.dbtools.crest.imports.metadata.DBMExtractionController;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.wizards.CustomWizard;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.AbstractDBMExtractionWizardImpl;
import oracle.dbtools.crest.swingui.wizards.metadata.ColorTableCellRenderer;
import oracle.dbtools.crest.swingui.wizards.metadata.DMConnectionModel;
import oracle.dbtools.crest.swingui.wizards.metadata.DefaultDBMExtractionWizard;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.FCPConnectionDialog;
import oracle.dbtools.crest.swingui.wizards.metadata.db2.DBMExtractionWizardDB2;
import oracle.dbtools.crest.swingui.wizards.metadata.db2.v80.DBMExtractionWizardDB2v80;
import oracle.dbtools.crest.swingui.wizards.metadata.odbc.DBMExtractionWizardODBC;
import oracle.dbtools.crest.swingui.wizards.metadata.oracle.DBMExtractionWizardOracle;
import oracle.dbtools.crest.swingui.wizards.metadata.sqlserver.DBMExtractionWizardSqlServer;
import oracle.dbtools.crest.swingui.wizards.metadata.udb.DBMExtractionWizardUDB;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.compare.CompareMappingDialog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class DBMExtractionWizard
extends CustomWizard {
    private static final Font fontGrey = new Font("Dialog", 2, 12);
    private static final Font fontBlue = new Font("Dialog", 1, 12);
    private static final String DESCRIPTION_1 = Messages.getString("DBMExtractionWizard.SelectDatabaseConnection");
    private static final String DESCRIPTION_2 = Messages.getString("DBMExtractionWizard.SelectSchema");
    private static final String DESCRIPTION_3 = Messages.getString("DBMExtractionWizard.SelectObjects");
    private static final String DESCRIPTION_4 = Messages.getString("DBMExtractionWizard.ViewSummaryGenerateDesign");
    private static final String FIRST_PAGE = "FIRST_PAGE";
    private static final String SECOND_PAGE = "SECOND_PAGE";
    private static final String THIRD_PAGE = "THIRD_PAGE";
    private static final String FOURTH_PAGE = "FOURTH_PAGE";
    private CardLayout cardLayout = new CardLayout();
    private JPanel pnMain;
    private JTextArea taDescription;
    private JLabel lbTask1;
    private JLabel lbTask2;
    private JLabel lbTask3;
    private JLabel lbTask4;
    private int taskNbr = 1;
    private JTable tbConnections;
    private DBMExtractionController controller;
    private JButton bnRemove;
    private JButton bnProperties;
    private JButton bnTestConnection;
    private JButton bnImport;
    private JButton bnExport;
    private JLabel taSummary;
    protected JPanel firstPanel;
    protected JPanel secondPanel;
    protected JPanel thirdPanel;
    protected JPanel forthPanel;
    private JComboBox cbImportTo;
    private JComboBox cbSite;
    private JCheckBox chbReverseTarget;
    private Connection connection = null;
    private static final Logger LOGGER = new Logger(DBMExtractionWizard.class);

    public DBMExtractionWizard(ApplicationView view) {
        super(view);
        this.clearInstances();
        this.pnMain.setLayout(this.cardLayout);
        this.handleButtons();
        this.refreshMainPanel();
    }

    @Override
    protected String getCaption() {
        return Messages.getString("DBMExtractionWizard.DataDictionaryImportWizard");
    }

    private void clearInstances() {
        DefaultDBMExtractionWizard.clearInstance();
        DBMExtractionWizardDB2.clearInstance();
        DBMExtractionWizardDB2v80.clearInstance();
        DBMExtractionWizardODBC.clearInstance();
        DBMExtractionWizardOracle.clearInstance();
        DBMExtractionWizardSqlServer.clearInstance();
        DBMExtractionWizardUDB.clearInstance();
    }

    public DBMExtractionController getController() {
        if (this.controller == null) {
            this.controller = new DBMExtractionController(this.view);
        }
        return this.controller;
    }

    @Override
    protected JPanel initMainPanel() {
        JPanel jpanel0 = new JPanel(new BorderLayout());
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel pnBanner = new JPanel(new BorderLayout());
        pnBanner.setBackground(Color.WHITE);
        ImageIcon imageIcon = (ImageIcon)GUIConfiguration.getInstance().getIcon("DBM_WIZARD_BANNER");
        pnBanner.add((Component)new JLabel(imageIcon), "West");
        this.taDescription = new JTextArea();
        this.taDescription.setEditable(false);
        this.taDescription.setFont(fontBlue);
        this.taDescription.setBackground(Color.WHITE);
        JPanel pnRight = new JPanel(new FlowLayout(1, 0, 25));
        pnRight.setBackground(Color.WHITE);
        pnRight.add(this.taDescription);
        pnBanner.add((Component)pnRight, "Center");
        jpanel.add((Component)pnBanner, "North");
        JPanel pnTasks = new JPanel(new GridLayout(0, 1));
        pnTasks.setBackground(Color.WHITE);
        pnTasks.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.lbTask1 = new JLabel(Messages.getString("DBMExtractionWizard.SectionConnectDatabase"));
        this.lbTask2 = new JLabel(Messages.getString("DBMExtractionWizard.SectionSelectSchemaDatabase"));
        this.lbTask3 = new JLabel(Messages.getString("DBMExtractionWizard.SectionSelectObjectsToImport"));
        this.lbTask4 = new JLabel(Messages.getString("DBMExtractionWizard.SectionGenerateDesign"));
        pnTasks.add(this.lbTask1);
        pnTasks.add(this.lbTask2);
        pnTasks.add(this.lbTask3);
        pnTasks.add(this.lbTask4);
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.setPreferredSize(new Dimension(220, 250));
        jpanel.add((Component)pnTasks, "West");
        this.pnMain = new JPanel();
        this.pnMain.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.pnMain.setPreferredSize(new Dimension(710, 450));
        this.firstPanel = this.initFirstTab();
        this.pnMain.add((Component)this.firstPanel, FIRST_PAGE);
        this.forthPanel = this.initFourthTab();
        this.pnMain.add((Component)this.forthPanel, FOURTH_PAGE);
        jpanel.add((Component)this.pnMain, "Center");
        jpanel0.add((Component)new JScrollPane(jpanel), "Center");
        return jpanel0;
    }

    private void updateConnections() {
        ((DMConnectionModel)this.tbConnections.getModel()).reReadConnections();
        this.bnExport.setEnabled(this.tbConnections.getRowCount() > 0);
    }

    private Properties getSelectedConnectionProperties() {
        Properties cd = null;
        try {
            cd = ((DMConnectionModel)this.tbConnections.getModel()).getRowData(this.tbConnections.getSelectedRow());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cd;
    }

    public Connection getSelectedConnection() {
        return this.connection;
    }

    public int getSelectedConnectionType() {
        return ConnectionInfo.getConnectionType(this.getSelectedConnectionProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initConnection() {
        block5: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.closeConnection();
                Properties cd = this.getSelectedConnectionProperties();
                if (cd == null) break block5;
                try {
                    this.connection = DatabaseConnections.getInstance().getConnection(cd);
                }
                catch (Exception e) {
                    MessageDialogs.showErrorMessage(e.getLocalizedMessage());
                    boolean bl = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return this.connection != null;
    }

    private JPanel initFirstTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.tbConnections = new JTable(new DMConnectionModel(DatabaseConnections.getInstance(), false));
        this.tbConnections.setSelectionMode(0);
        this.tbConnections.setDefaultRenderer(Object.class, new ColorTableCellRenderer());
        this.tbConnections.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DBMExtractionWizard.this.showConnectionProperties();
                } else {
                    boolean enabled = DBMExtractionWizard.this.tbConnections.getSelectedRow() > -1;
                    DBMExtractionWizard.this.bnNext.setEnabled(enabled);
                    DBMExtractionWizard.this.bnRemove.setEnabled(enabled);
                    DBMExtractionWizard.this.bnProperties.setEnabled(enabled);
                    DBMExtractionWizard.this.bnTestConnection.setEnabled(enabled);
                }
            }
        });
        this.tbConnections.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    DBMExtractionWizard.this.showConnectionProperties();
                }
                boolean enabled = DBMExtractionWizard.this.tbConnections.getSelectedRow() > -1;
                DBMExtractionWizard.this.bnNext.setEnabled(enabled);
                DBMExtractionWizard.this.bnRemove.setEnabled(enabled);
                DBMExtractionWizard.this.bnProperties.setEnabled(enabled);
                DBMExtractionWizard.this.bnTestConnection.setEnabled(enabled);
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        JScrollPane sp = new JScrollPane(this.tbConnections);
        jpanel.add((Component)sp, "Center");
        JPanel pnButtons = new JPanel(new FlowLayout(0));
        JButton bnAdd = new JButton(Messages.getString("DBMExtractionWizard.Add"));
        bnAdd.setMnemonic(65);
        bnAdd.addActionListener(new AddAction());
        this.bnRemove = new JButton(Messages.getString("DBMExtractionWizard.Remove"));
        this.bnRemove.setMnemonic(82);
        this.bnRemove.addActionListener(new RemoveAction());
        this.bnRemove.setEnabled(false);
        this.bnImport = new JButton(Messages.getString("DBMExtractionWizard.Import"));
        this.bnImport.setToolTipText(Messages.getString("DBMExtractionWizard.ImportSQLDeveloperDatabaseConnections"));
        this.bnImport.setMnemonic(73);
        this.bnImport.addActionListener(new ImportAction());
        this.bnExport = new JButton(Messages.getString("DBMExtractionWizard.Export"));
        this.bnExport.setToolTipText(Messages.getString("DBMExtractionWizard.ExportConnections"));
        this.bnExport.setMnemonic(69);
        this.bnExport.addActionListener(new ExportAction());
        this.bnProperties = new JButton(Messages.getString("DBMExtractionWizard.Properties"));
        this.bnProperties.setMnemonic(80);
        this.bnProperties.addActionListener(new PropertiesAction());
        this.bnProperties.setEnabled(false);
        this.bnTestConnection = new JButton(Messages.getString("DBMExtractionWizard.TestConnection"));
        this.bnTestConnection.setMnemonic(84);
        this.bnTestConnection.addActionListener(new TestAction());
        this.bnTestConnection.setEnabled(false);
        bnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnExport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnProperties.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnTestConnection.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        pnButtons.add(bnAdd);
        pnButtons.add(this.bnRemove);
        pnButtons.add(this.bnImport);
        pnButtons.add(this.bnExport);
        pnButtons.add(this.bnProperties);
        pnButtons.add(this.bnTestConnection);
        jpanel.add((Component)pnButtons, "South");
        this.updateConnections();
        return jpanel;
    }

    private void showConnectionProperties() {
        Properties cd = this.getSelectedConnectionProperties();
        if (cd != null) {
            String connName = ConnectionInfo.getConnectionName(cd);
            FCPConnectionDialog.showConnectionDialog(connName, false);
            this.updateConnections();
        }
    }

    @Override
    protected String getHelpIndex() {
        return "IMPORT_METADATA_WIZARD";
    }

    private AbstractDBMExtractionWizardImpl getImpl() {
        if (this.connection == null) {
            return DefaultDBMExtractionWizard.getInstance(this);
        }
        switch (this.getSelectedConnectionType()) {
            case 3: {
                if (ConnectionInfo.getDBMajorVersion(this.connection) == 7) {
                    return DBMExtractionWizardDB2.getInstance(this);
                }
                return DBMExtractionWizardDB2v80.getInstance(this);
            }
            case 4: {
                return DBMExtractionWizardUDB.getInstance(this);
            }
            case 1: {
                return DBMExtractionWizardOracle.getInstance(this);
            }
            case 2: {
                return DBMExtractionWizardSqlServer.getInstance(this);
            }
            case 0: {
                return DBMExtractionWizardODBC.getInstance(this);
            }
        }
        return DefaultDBMExtractionWizard.getInstance(this);
    }

    private void refreshMainPanel() {
        if (this.forthPanel != null) {
            this.pnMain.remove(this.forthPanel);
        }
        if (this.thirdPanel != null) {
            this.pnMain.remove(this.thirdPanel);
        }
        if (this.secondPanel != null) {
            this.pnMain.remove(this.secondPanel);
        }
        this.pnMain.remove(this.firstPanel);
        this.pnMain.add((Component)this.firstPanel, FIRST_PAGE);
        if (this.secondPanel != null) {
            this.pnMain.add((Component)this.secondPanel, SECOND_PAGE);
        }
        if (this.thirdPanel != null) {
            this.pnMain.add((Component)this.thirdPanel, THIRD_PAGE);
        }
        if (this.forthPanel != null) {
            this.pnMain.add((Component)this.forthPanel, FOURTH_PAGE);
        }
    }

    public void initSecondPanel() {
        if (this.secondPanel != null) {
            this.pnMain.remove(this.secondPanel);
        }
        this.secondPanel = this.getSecondTabChanged();
        this.refreshMainPanel();
    }

    public JPanel getSecondTabChanged() {
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.add((Component)this.getImpl().getSecondTab(), "Center");
        jpanel.add((Component)this.initOptionsPanel(), "South");
        return jpanel;
    }

    public void initThirdPanel() {
        if (this.thirdPanel != null) {
            this.pnMain.remove(this.thirdPanel);
        }
        this.thirdPanel = this.getImpl().getThirdTab();
        this.refreshMainPanel();
    }

    public void clearSecondTabFilter() {
        this.getImpl().clearSecondTabFilter();
    }

    public void clearThirdTabFilter() {
        this.getImpl().clearFilterMap();
        this.getImpl().clearThirdTabFilter();
    }

    public boolean initSchemas(boolean next) {
        return this.getImpl().getSchemas(next);
    }

    public boolean initDBObjects(boolean next) {
        return this.getImpl().getDBObjects(next);
    }

    public void initRDBMSSites(boolean next) {
        RDBMSSite site;
        if (next && (site = this.getController().getDBMExtractionHandler(this.getSelectedConnectionType()).getRDBMSSite()) != null) {
            RDBMSType selectedConnectionType = site.getType();
            Iterator iterator = this.getAppView().getCurrentDesign().getRDBMSSiteSet().iterator();
            while (iterator.hasNext()) {
                RDBMSSite rdbmsSite = (RDBMSSite)iterator.next();
                if (!selectedConnectionType.equals(rdbmsSite.getType())) continue;
                this.cbSite.addItem(rdbmsSite);
            }
            Object obj = this.cbSite.getSelectedItem();
            if (obj instanceof RDBMSSite) {
                this.getImpl().setRdbmsSite((RDBMSSite)obj);
            }
        }
    }

    protected JPanel initFourthTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.taSummary = new JLabel();
        this.taSummary.setFont(this.taSummary.getFont().deriveFont(0));
        this.taSummary.setVerticalAlignment(1);
        jpanel.add((Component)this.taSummary, "Center");
        jpanel.add((Component)new JPanel(), "East");
        jpanel.add((Component)new JPanel(), "West");
        jpanel.add((Component)new JPanel(), "North");
        return jpanel;
    }

    public JPanel initOptionsPanel() {
        Object obj;
        JPanel pnOptions = new JPanel(new FlowLayout(0));
        pnOptions.setBorder(BorderFactory.createTitledBorder(Messages.getString("DBMExtractionWizard.ImportTo")));
        Dimension defaultCBSize = new Dimension(170, 20);
        this.cbImportTo = new JComboBox();
        this.cbImportTo.setPreferredSize(defaultCBSize);
        pnOptions.add(this.cbImportTo);
        pnOptions.add(new JLabel());
        RelationalDesign empty = null;
        for (RelationalDesign rd : this.getAppView().getCurrentDesign().getRelationalDesigns()) {
            this.cbImportTo.addItem(rd);
            if (!rd.isEmpty() || empty != null) continue;
            empty = rd;
        }
        this.cbImportTo.addItem("New Relational Model");
        if (empty != null) {
            this.cbImportTo.setSelectedItem(empty);
        }
        if ((obj = this.cbImportTo.getSelectedItem()) != null && obj instanceof RelationalDesign) {
            this.getImpl().setRelationalDesign((RelationalDesign)obj);
        } else {
            this.getImpl().setRelationalDesign(null);
        }
        this.chbReverseTarget = new JCheckBox(Messages.getString("DBMExtractionWizard.SwapTargetModel"));
        this.chbReverseTarget.setPreferredSize(new Dimension(170, 20));
        this.chbReverseTarget.setEnabled(!this.emptySelected());
        pnOptions.add(this.chbReverseTarget);
        this.cbImportTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj;
                DBMExtractionWizard.this.chbReverseTarget.setEnabled(!DBMExtractionWizard.this.emptySelected());
                if (!DBMExtractionWizard.this.chbReverseTarget.isEnabled()) {
                    DBMExtractionWizard.this.chbReverseTarget.setSelected(false);
                }
                if ((obj = DBMExtractionWizard.this.cbImportTo.getSelectedItem()) != null && obj instanceof RelationalDesign) {
                    DBMExtractionWizard.this.getImpl().setRelationalDesign((RelationalDesign)obj);
                } else {
                    DBMExtractionWizard.this.getImpl().setRelationalDesign(null);
                }
            }
        });
        this.cbSite = new JComboBox();
        this.cbSite.setPreferredSize(defaultCBSize);
        pnOptions.add(this.cbSite);
        this.cbSite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = DBMExtractionWizard.this.cbSite.getSelectedItem();
                if (obj != null && obj instanceof RDBMSSite) {
                    DBMExtractionWizard.this.getImpl().setRdbmsSite((RDBMSSite)obj);
                }
            }
        });
        JButton bnMapping = new JButton(Messages.getString("DBMExtractionWizard.CompareMapping"));
        bnMapping.setPreferredSize(defaultCBSize);
        bnMapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareMappingDialog dialog = new CompareMappingDialog(DBMExtractionWizard.this.getAppView(), DBMExtractionWizard.this.getAppView().getCurrentDesign());
                dialog.show();
            }
        });
        pnOptions.add(bnMapping);
        return pnOptions;
    }

    private boolean emptySelected() {
        if (this.getSelectedConnectionProperties() != null && this.getSelectedConnectionType() != 1) {
            return true;
        }
        if (this.cbImportTo.getSelectedItem() instanceof RelationalDesign) {
            return ((RelationalDesign)this.cbImportTo.getSelectedItem()).isEmpty();
        }
        return true;
    }

    public RelationalDesign getSelectedModel() {
        Object selected = this.cbImportTo.getSelectedItem();
        if (selected instanceof RelationalDesign) {
            return (RelationalDesign)selected;
        }
        return null;
    }

    public boolean swapTargetModel() {
        return this.chbReverseTarget.isSelected();
    }

    protected JPanel createRow(Component leftComp, Component rightComp) {
        JPanel newRow = new JPanel(new BorderLayout());
        newRow.add(leftComp, "West");
        newRow.add(rightComp, "Center");
        return newRow;
    }

    private boolean performTask(boolean next) {
        switch (this.taskNbr) {
            case 1: {
                this.closeConnection();
            }
            case 2: {
                if (next) {
                    if (!this.initConnection()) {
                        return false;
                    }
                    if (this.connection != null) {
                        this.getController().getDBMExtractionHandler(this.getSelectedConnectionType()).init(this.connection);
                    }
                    this.initSecondPanel();
                    this.initThirdPanel();
                    this.chbReverseTarget.setEnabled(!this.emptySelected());
                    this.clearSecondTabFilter();
                    this.clearThirdTabFilter();
                } else {
                    this.clearThirdTabFilter();
                }
                boolean result = this.initSchemas(next);
                if (next) {
                    this.initRDBMSSites(next);
                }
                return result;
            }
            case 3: {
                return this.initDBObjects(next);
            }
            case 4: {
                return this.getSummary();
            }
        }
        return true;
    }

    private List getSelectedObjects() {
        return this.getImpl().getSelectedObjects();
    }

    private Map getSummaryList() {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (DBObject dbo : this.getSelectedObjects()) {
            if (!dbo.isSelected()) continue;
            if (map.containsKey(dbo.getType())) {
                Integer value = (Integer)map.get(dbo.getType());
                int count = value;
                map.put(dbo.getType(), new Integer(++count));
                continue;
            }
            map.put(dbo.getType(), new Integer(1));
        }
        return map;
    }

    private String addTableRow(String col1, String col2) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<tr>");
        buffer.append("<td width=\"150\">");
        buffer.append("<p>");
        buffer.append(col1);
        buffer.append("</p>");
        buffer.append("</td>");
        buffer.append("<td width=\"60\" align=\"right\">");
        buffer.append("<p>");
        buffer.append(col2);
        buffer.append("</p>");
        buffer.append("</td>");
        buffer.append("</tr>");
        return buffer.toString();
    }

    private boolean getSummary() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append("<body>");
        buffer.append("<p>");
        buffer.append("<b>");
        buffer.append(Messages.getString("DBMExtractionWizard.DatabaseName"));
        buffer.append("</b>");
        buffer.append(this.getController().getDBProductName(this.getSelectedConnectionType()));
        buffer.append("</p>");
        buffer.append("<p>");
        buffer.append("<b>");
        buffer.append(Messages.getString("DBMExtractionWizard.DatabaseVersion"));
        buffer.append("</b>");
        buffer.append(this.getController().getDBProductVersion(this.getSelectedConnectionType()));
        buffer.append("</p>");
        buffer.append("<p></p>");
        buffer.append("<p>");
        buffer.append("<b>");
        buffer.append(Messages.getString("DBMExtractionWizard.DBObjectsIimported"));
        buffer.append("</b>");
        buffer.append("</p>");
        buffer.append("<table border=\"0\" width=\"170\">");
        Map map = this.getSummaryList();
        Object[] keys = map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String objType = (String)keys[i];
            Integer count = (Integer)map.get(keys[i]);
            buffer.append(this.addTableRow(objType, count.toString()));
        }
        buffer.append("</table>");
        buffer.append("</body>");
        buffer.append("</html>");
        this.taSummary.setText(buffer.toString());
        return true;
    }

    @Override
    protected void doBack() {
        --this.taskNbr;
        try {
            if (this.performTask(false)) {
                this.handleButtons();
                switch (this.taskNbr) {
                    case 1: {
                        this.cardLayout.show(this.pnMain, FIRST_PAGE);
                        break;
                    }
                    case 2: {
                        this.cardLayout.show(this.pnMain, SECOND_PAGE);
                        break;
                    }
                    case 3: {
                        this.cardLayout.show(this.pnMain, THIRD_PAGE);
                    }
                }
            } else {
                ++this.taskNbr;
            }
        }
        catch (Throwable e) {
            ++this.taskNbr;
            JOptionPane.showMessageDialog(this, e.getMessage(), Messages.getString("DBMExtractionWizard.Error"), 0);
            LOGGER.error(e);
        }
    }

    @Override
    protected void doNext() {
        ++this.taskNbr;
        try {
            if (this.performTask(true)) {
                this.handleButtons();
                switch (this.taskNbr) {
                    case 2: {
                        this.cardLayout.show(this.pnMain, SECOND_PAGE);
                        break;
                    }
                    case 3: {
                        this.cardLayout.show(this.pnMain, THIRD_PAGE);
                        break;
                    }
                    case 4: {
                        this.cardLayout.show(this.pnMain, FOURTH_PAGE);
                    }
                }
            } else {
                --this.taskNbr;
            }
        }
        catch (Throwable e) {
            --this.taskNbr;
            JOptionPane.showMessageDialog(this, e.getMessage(), Messages.getString("DBMExtractionWizard.Error"), 0);
            LOGGER.error(e);
        }
    }

    @Override
    protected void doFinish() {
        try {
            this.getController().generateDesign(this.getSelectedConnection(), this.getSelectedConnectionProperties(), this.getSelectedObjects(), this.getSelectedModel(), this.swapTargetModel(), (RDBMSSite)this.cbSite.getSelectedItem());
        }
        catch (Throwable e) {
            MessageDialogs.showErrorMessage(this, e.getMessage());
            LOGGER.error(e);
        }
        this.dispose();
    }

    @Override
    protected void doCancel() {
        this.getController().doCancel();
        this.closeConnection();
        this.dispose();
    }

    @Override
    protected void doClosing() {
        this.closeConnection();
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
                this.connection = null;
            }
            catch (Exception e) {
                LOGGER.error("Unable to close the connection", e);
            }
        }
    }

    private void handleButtons() {
        this.handleLabels();
        this.handleDescription();
        switch (this.taskNbr) {
            case 1: {
                this.bnBack.setEnabled(false);
                this.bnNext.setEnabled(this.tbConnections.getSelectedRow() > -1);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 2: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(true);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 3: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(true);
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 4: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(false);
                this.bnFinish.setEnabled(true);
                this.bnCancel.setEnabled(true);
            }
        }
    }

    private void handleLabels() {
        switch (this.taskNbr) {
            case 1: {
                this.setBlueLabel(this.lbTask1);
                this.setGreyLabel(this.lbTask2);
                this.setGreyLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
                break;
            }
            case 2: {
                this.setBlackLabel(this.lbTask1);
                this.setBlueLabel(this.lbTask2);
                this.setGreyLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
                break;
            }
            case 3: {
                this.setBlackLabel(this.lbTask1);
                this.setBlackLabel(this.lbTask2);
                this.setBlueLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
                break;
            }
            case 4: {
                this.setBlackLabel(this.lbTask1);
                this.setBlackLabel(this.lbTask2);
                this.setBlackLabel(this.lbTask3);
                this.setBlueLabel(this.lbTask4);
                break;
            }
            default: {
                this.setBlueLabel(this.lbTask1);
                this.setGreyLabel(this.lbTask2);
                this.setGreyLabel(this.lbTask3);
                this.setGreyLabel(this.lbTask4);
            }
        }
    }

    private void setGreyLabel(JLabel label) {
        label.setForeground(Color.LIGHT_GRAY);
        label.setFont(fontGrey);
    }

    private void setBlueLabel(JLabel label) {
        label.setForeground(Color.BLUE);
        label.setFont(fontBlue);
    }

    private void setBlackLabel(JLabel label) {
        label.setForeground(Color.BLACK);
        label.setFont(fontBlue);
    }

    private void handleDescription() {
        switch (this.taskNbr) {
            case 1: {
                this.taDescription.setText(DESCRIPTION_1);
                break;
            }
            case 2: {
                this.taDescription.setText(DESCRIPTION_2);
                break;
            }
            case 3: {
                this.taDescription.setText(DESCRIPTION_3);
                break;
            }
            case 4: {
                this.taDescription.setText(DESCRIPTION_4);
                break;
            }
            default: {
                this.taDescription.setText(DESCRIPTION_1);
            }
        }
    }

    private class TestAction
    implements ActionListener {
        private TestAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FCPConnectionDialog.testConnection(DBMExtractionWizard.this.getSelectedConnectionProperties(), false);
        }
    }

    private class PropertiesAction
    implements ActionListener {
        private PropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DBMExtractionWizard.this.showConnectionProperties();
        }
    }

    private class ExportAction
    implements ActionListener {
        private ExportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FCPConnectionDialog.exportConnections();
        }
    }

    private class ImportAction
    implements ActionListener {
        private ImportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FCPConnectionDialog.importConnections();
            DBMExtractionWizard.this.updateConnections();
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Properties cd = DBMExtractionWizard.this.getSelectedConnectionProperties();
            if (cd != null) {
                try {
                    String connName = ConnectionInfo.getConnectionName(cd);
                    int result = JOptionPane.showConfirmDialog(DBMExtractionWizard.this, "Are you sure you want to delete: '" + connName + "' connection?", "Select an option", 0);
                    if (result == 0) {
                        DatabaseConnections.getInstance().removeConnection(connName);
                        DBMExtractionWizard.this.updateConnections();
                        DBMExtractionWizard.this.tbConnections.clearSelection();
                        DBMExtractionWizard.this.bnNext.setEnabled(false);
                        DBMExtractionWizard.this.bnRemove.setEnabled(false);
                        DBMExtractionWizard.this.bnProperties.setEnabled(false);
                        DBMExtractionWizard.this.bnTestConnection.setEnabled(false);
                    }
                }
                catch (ConnectionException e1) {
                    LOGGER.error("Unable to delete connection", e1);
                    MessageDialogs.showMessage(ApplicationView.frame, "Unable to delete connection");
                }
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FCPConnectionDialog.showConnectionDialog();
                DBMExtractionWizard.this.updateConnections();
            }
            catch (Exception e1) {
                LOGGER.error(e1);
            }
        }
    }
}

