/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.storage.distincttype;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeSetDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.storage.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DistinctTypesDialogDB2
extends CustomDialog {
    protected JPanel general;
    protected AbstractStorageDesignDB2 storageDesign;
    private DefaultListModel allDomainsModel;
    private DefaultListModel selectedDomainsModel;
    private JList allDomainsList;
    private JList selectedDomainsList;
    private JButton bnAdd;
    private JButton bnRemove;
    protected JDialog dialog;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();

    public DistinctTypesDialogDB2(ApplicationView view, AbstractStorageDesignDB2 storageDesign) {
        super(view);
        this.storageDesign = storageDesign;
        this.storageDesign.setDtDialogVisible(true);
        this.general = new JPanel();
        this.general.setLayout(new BoxLayout(this.general, 2));
        this.general.setPreferredSize(new Dimension(430, 270));
        this.initGeneralView();
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.add((Component)this.general, "Center");
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(Messages.getString("DistinctTypesDialogDB2.OK"));
        bnOK.addActionListener(new OKAction());
        bnOK.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setMnemonic(79);
        bottomPanel.add(bnOK);
        JButton bnApply = new JButton(Messages.getString("DistinctTypesDialogDB2.Apply"));
        bnApply.addActionListener(new ApplyAction());
        bnApply.setCursor(Cursor.getPredefinedCursor(12));
        bnApply.setMnemonic(65);
        bottomPanel.add(bnApply);
        JButton bnCancel = new JButton(Messages.getString("DistinctTypesDialogDB2.Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        bottomPanel.add(bnCancel);
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jpanel.add((Component)bottomPanel, "South");
        this.storageDesign.setDtDialogVisible(true);
        this.add((Component)jpanel, "Center");
    }

    public String getCaption() {
        return Messages.getString("DistinctTypesDialogDB2.DistinctTypes");
    }

    protected void initGeneralView() {
        this.initAllDomainsList();
        this.initButtons();
        this.initDistinctTypesList();
    }

    private void initAllDomainsList() {
        this.allDomainsModel = new DefaultListModel();
        this.allDomainsList = new JList(this.allDomainsModel);
        ListSelectionModel listSelectionModel = this.allDomainsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allDomainsList);
        sp.setBorder(BorderFactory.createTitledBorder(Messages.getString("DistinctTypesDialogDB2.Domains")));
        sp.setPreferredSize(new Dimension(200, 180));
        this.general.add(sp);
    }

    private void initDistinctTypesList() {
        this.selectedDomainsModel = new DefaultListModel();
        this.selectedDomainsList = new JList(this.selectedDomainsModel);
        ListSelectionModel listSelectionModel = this.selectedDomainsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedDomainsList);
        sp.setBorder(BorderFactory.createTitledBorder(Messages.getString("DistinctTypesDialogDB2.DistinctTypes")));
        sp.setPreferredSize(new Dimension(200, 180));
        this.general.add(sp);
    }

    private void initButtons() {
        this.bnAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.bnAdd.setToolTipText(Messages.getString("DistinctTypesDialogDB2.Add"));
        this.bnAdd.addActionListener(new AddDomainsActionListener());
        this.bnAdd.setEnabled(false);
        this.bnRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.bnRemove.setToolTipText(Messages.getString("DistinctTypesDialogDB2.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveDomainsActionListener());
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.bnAdd);
        verticalBox.add(this.bnRemove);
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.setPreferredSize(new Dimension(30, 180));
        this.general.add(verticalBox);
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    public void initProperties() {
        Iterator domains = this.storageDesign.getDesign().getDomainSet().iterator();
        DistinctTypeSetDB2 types = this.storageDesign.getDistinctTypeSet();
        while (domains.hasNext()) {
            Domain dom = (Domain)domains.next();
            if (types.getDistinctType(dom) != null) {
                this.selectedDomainsModel.addElement(dom);
                continue;
            }
            if ("Unknown".equalsIgnoreCase(dom.getName())) continue;
            this.allDomainsModel.addElement(dom);
        }
    }

    protected void setProperties() {
        Object[] selectedDomains = this.selectedDomainsModel.toArray();
        this.storageDesign.getDistinctTypeSet().removeAll();
        DistinctTypeDB2 type = null;
        for (int i = 0; i < selectedDomains.length; ++i) {
            Domain dom = (Domain)selectedDomains[i];
            type = this.storageDesign.getDistinctTypeSet().createDistinctType();
            type.setName(dom.getName());
            type.setDomain(dom.getName());
            type.setImplementedDomain(dom);
            type.setDirty(true);
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("DistinctTypesDialogDB2.DistinctTypes"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
        this.storageDesign.setDtDialogVisible(false);
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DistinctTypesDialogDB2.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DistinctTypesDialogDB2.this.setProperties();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DistinctTypesDialogDB2.this.setProperties();
            DistinctTypesDialogDB2.this.close();
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (DistinctTypesDialogDB2.this.selectedDomainsList.getSelectedIndex() == -1) {
                    DistinctTypesDialogDB2.this.bnRemove.setEnabled(false);
                } else {
                    DistinctTypesDialogDB2.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (DistinctTypesDialogDB2.this.allDomainsList.getSelectedIndex() == -1) {
                    DistinctTypesDialogDB2.this.bnAdd.setEnabled(false);
                } else {
                    DistinctTypesDialogDB2.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveDomainsActionListener
    implements ActionListener {
        private RemoveDomainsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DistinctTypesDialogDB2.this.selectedDomainsModel.isEmpty()) {
                Object[] selectedObjects = DistinctTypesDialogDB2.this.selectedDomainsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (DistinctTypesDialogDB2.this.allDomainsModel.contains(ob)) continue;
                    DistinctTypesDialogDB2.this.allDomainsModel.addElement(ob);
                    DistinctTypesDialogDB2.this.selectedDomainsModel.removeElement(ob);
                }
            }
        }
    }

    private class AddDomainsActionListener
    implements ActionListener {
        private AddDomainsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DistinctTypesDialogDB2.this.allDomainsModel.isEmpty()) {
                Object[] selectedObjects = DistinctTypesDialogDB2.this.allDomainsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (DistinctTypesDialogDB2.this.selectedDomainsModel.contains(ob)) continue;
                    DistinctTypesDialogDB2.this.selectedDomainsModel.addElement(ob);
                    DistinctTypesDialogDB2.this.allDomainsModel.removeElement(ob);
                }
            }
        }
    }
}

