/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Map;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectableObjectMultiple;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.relational.FKEdge;

public class TVFKRelation
extends TVConnector {
    private RelationSelection selectionWrapper = new RelationSelection();
    private Color pathColorSelected = Color.red;
    private Color pathColorNormal = Color.black;

    public TVFKRelation(ApplicationView appView, DesignPartView dpv) {
        super(appView, dpv);
    }

    @Override
    public boolean isConnection() {
        return true;
    }

    public void addConnection() {
        if (this.edge == null) {
            ContainerView sourceTV = this.getFKIndexAssociation().getSourceTV(this.getDesignPartView());
            ContainerView targetTV = this.getFKIndexAssociation().getTargetTV(this.getDesignPartView());
            if (sourceTV != null && targetTV != null && sourceTV.getCellView() != null && targetTV.getCellView() != null) {
                ContainerDiagramCell source = (ContainerDiagramCell)sourceTV.getCellView().getCell();
                ContainerDiagramCell target = (ContainerDiagramCell)targetTV.getCellView().getCell();
                this.edge = this.getDesignPartView().getWorkSpace().addConnection(source, target, Color.BLACK);
                this.edge.setTopView(this);
                this.setCellView(this.edge.getCellView());
                this.resetEdgeParams(this.edge, false);
                this.setLabelBoundsFor(new Rectangle(-1, -1, -1, -1), 1);
                this.displayLabels();
                if (!ApplicationView.loading) {
                    this.edge.straightLine();
                }
            }
        }
    }

    @Override
    public void displayLabels() {
        if (this.edge != null && this.edge.getDiagram().getDesignPartView().showLabels()) {
            if (this.edge != null && this.edge.getTopView() != null) {
                if (!"".equalsIgnoreCase(((FKEdge)this.edge).getName())) {
                    this.displayLabel(((FKEdge)this.edge).getName(), this.getLabelBounds(), 1);
                } else {
                    this.removeLabel(1);
                }
            }
        } else {
            this.removeLabel(1);
        }
    }

    public void addConnection(boolean newedge) {
        if (newedge) {
            this.edge = null;
        }
        this.addConnection();
    }

    @Override
    public void resetEdgeParams() {
        if (this.edge != null) {
            Label label = this.getLabel(1);
            if (label != null) {
                label.setText(this.getModel().getName());
            }
            this.resetEdgeParams(this.edge, true);
        }
    }

    public void resetEdgeParams(boolean repaint) {
        if (this.edge != null) {
            this.resetEdgeParams(this.edge, repaint);
        }
    }

    private void resetEdgeParams(DefaultEdge edge, boolean repaint) {
        Map edgeAttributes = edge.getAttributes();
        FKIndexAssociation fk = (FKIndexAssociation)this.getModel();
        boolean isOneToOneMandatory = fk.isOneToOne();
        if (this.getDesign().getAppView().getSettings().isFk2pkArrow()) {
            DiagramConstants.setLineBegin(edgeAttributes, 2);
            if (isOneToOneMandatory) {
                if ("CASCADE".equalsIgnoreCase(fk.getDeleteRule())) {
                    DiagramConstants.setLineEnd(edgeAttributes, 22);
                } else if ("RESTRICT".equalsIgnoreCase(fk.getDeleteRule())) {
                    DiagramConstants.setLineEnd(edgeAttributes, 8);
                } else if ("SET NULL".equalsIgnoreCase(fk.getDeleteRule())) {
                    DiagramConstants.setLineEnd(edgeAttributes, 23);
                } else {
                    DiagramConstants.setLineEnd(edgeAttributes, 8);
                }
            } else if ("CASCADE".equalsIgnoreCase(fk.getDeleteRule())) {
                DiagramConstants.setLineEnd(edgeAttributes, 21);
            } else if ("RESTRICT".equalsIgnoreCase(fk.getDeleteRule())) {
                DiagramConstants.setLineEnd(edgeAttributes, 17);
            } else if ("SET NULL".equalsIgnoreCase(fk.getDeleteRule())) {
                DiagramConstants.setLineEnd(edgeAttributes, 20);
            } else {
                DiagramConstants.setLineEnd(edgeAttributes, 17);
            }
            DiagramConstants.setBeginSize(edgeAttributes, 8);
            DiagramConstants.setEndSize(edgeAttributes, 6);
            DiagramConstants.setEndFill(edgeAttributes, false);
        } else {
            DiagramConstants.setLineBegin(edgeAttributes, 5);
            DiagramConstants.setLineEnd(edgeAttributes, 2);
            DiagramConstants.setBeginSize(edgeAttributes, 4);
            DiagramConstants.setEndSize(edgeAttributes, 8);
            DiagramConstants.setEndFill(edgeAttributes, true);
        }
        if (!this.getFKIndexAssociation().isMandatory()) {
            DiagramConstants.setDashPattern(edgeAttributes, FKIndexAssociation.dashpattern);
        } else {
            edgeAttributes.remove("dashPattern");
        }
        if (fk.isTransferable()) {
            DiagramConstants.setTransferable(edgeAttributes, true);
        } else {
            DiagramConstants.setTransferable(edgeAttributes, false);
        }
        edge.setAttributes(edgeAttributes);
        EdgeView cv = (EdgeView)edge.getDiagram().getDiagramLayoutCache().getMapping(edge, false);
        if (cv != null) {
            cv.update();
        }
        if (repaint && cv != null && DefaultDiagramModel.canUpdate) {
            cv.getDiagram().repaint();
        }
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.dpv == null) {
            if (ApplicationView.loading) {
                return this.getDesign().getRelationalDesign().getMainView();
            }
            return this.getApplicationView().getCurrentDPV();
        }
        return this.dpv;
    }

    public FKIndexAssociation getFKIndexAssociation() {
        return (FKIndexAssociation)this.getModel();
    }

    public FKIndexAssociation.FKConnection getFKConnection() {
        return ((FKIndexAssociation)this.getModel()).getFKConnection();
    }

    public void repairSelfReference(TopView tv) {
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
    }

    public boolean isSelected() {
        return this.selectionWrapper == this.getDesignPartView().getCurrentSelection();
    }

    @Override
    public SelectableObject getSelectableObject() {
        return this.selectionWrapper;
    }

    @Override
    public Object getLayerConstraint() {
        return RELATION_LAYER;
    }

    protected void setPathColorNormal(Color color) {
        this.pathColorNormal = color;
    }

    protected void setPathColorSelected(Color color) {
        this.pathColorSelected = color;
    }

    protected Color getPathColorNormal() {
        return this.pathColorNormal;
    }

    protected Color getPathColorSelected() {
        return this.pathColorSelected;
    }

    @Override
    public String toString() {
        return this.getModel().getName();
    }

    public void oneClick(MouseEvent e) {
        this.getDesignPartView().setCurrentSelection(this.selectionWrapper, this);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getModel().getDesign().getDesignLevelSettings().getDefaultLWCObject("Relational Foreign Key").getColor();
    }

    @Override
    public int getDefaultLineWidth() {
        return this.getModel().getDesign().getDesignLevelSettings().getDefaultLWCObject("Relational Foreign Key").getWidth();
    }

    class RelationSelection
    implements SelectableObject {
        RelationSelection() {
        }

        @Override
        public Object[] getSelectedContainedObject() {
            return null;
        }

        @Override
        public Object getSelectedObject() {
            return this.getSelectedDesignObject();
        }

        @Override
        public DesignObject getSelectedDesignObject() {
            return TVFKRelation.this.getModel();
        }

        @Override
        public boolean hasContainedArray() {
            return false;
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public SelectableObjectMultiple asMultiple() {
            throw new ClassCastException("Not a SelectableObjectMultiple");
        }
    }
}

