/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.fcp.SearchDockable;
import oracle.dbtools.crest.imports.SyncUtils;
import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.DenormalizerMergeTable;
import oracle.dbtools.crest.model.design.relational.DenormalizerSplitTable;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.undo.CreateDO_Edit;
import oracle.dbtools.crest.model.design.undo.GroupCreateEdit;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.metadata.XMLFromObjTransformer;
import oracle.dbtools.crest.model.metadata.XMLObjToStreamTransformer;
import oracle.dbtools.crest.model.metadata.XMLToObjectTransformer;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GlassComponent;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.PointsEnteredCallback;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectedObjectAction;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.TableDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.TableViewDiagramCell;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;
import oracle.dbtools.crest.swingui.editor.relational.ForeignKeyPropertiesDialogEx;
import oracle.dbtools.crest.swingui.engineeringcompare.EngineeringCompareDialog;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.Messages;
import oracle.dbtools.crest.swingui.relational.SplitTableWizard;
import oracle.dbtools.crest.swingui.search.SearchPanel;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.javatools.data.ChangeBuffer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.StructureChangeListener;
import org.xml.sax.InputSource;

public class ControllerRelational
extends AbstractController
implements Constants {
    private DockStation dockStation = null;
    private Select select;
    private ZoomIn zoomIn;
    private ZoomOut zoomOut;
    private FitScreen fitScreen;
    private ActualSize actualSize;
    private Search search;
    public RevEngineer revEngineer;
    private TableCollectorFKRelation fkCollector = null;
    private NewArc newArc;
    private AddToArc add2Arc;
    private RemoveFromArc removeFromArc;
    private NewTable newTable;
    private NewTableView newTableView;
    private SplitTable splitTable;
    private MergeTables mergeTables;
    private NewFKRelation newFK;
    private NewTypeSubstitution newTypeSubstitution;
    private NewNote newNote;
    private NewImage newImage;
    private Delete delete;
    private GenerateDDL generateDDL;
    private SyncModelWithDataDictionary syncModelWithDict;
    private SyncDataDictionaryWithModel syncDictWithModel;
    private static final Logger LOGGER = new Logger(ControllerRelational.class);
    DesignPartView designPV = null;
    private final String[] OBJECT_PHYSICAL_PATH = new String[]{AbstractController.OBJECT_CAPTION, AbstractController.PHYSICAL_CAPTION};
    private final String[] DESIGN_PATH = new String[]{AbstractController.DESIGN_CAPTION};
    private final String[] PHYSICAL_PATH = new String[]{AbstractController.PHYSICAL_CAPTION};

    public ControllerRelational(ApplicationView appView) {
        super(appView);
    }

    @Override
    public void initializeActions() {
        if (this.isEditable()) {
            this.select = new Select();
            this.newTable = new NewTable();
            this.newTableView = new NewTableView();
            this.splitTable = new SplitTable();
            this.mergeTables = new MergeTables();
            this.newFK = new NewFKRelation();
            this.newTypeSubstitution = new NewTypeSubstitution();
            this.newArc = new NewArc();
            this.add2Arc = new AddToArc();
            this.removeFromArc = new RemoveFromArc();
            this.newNote = new NewNote();
            this.newImage = new NewImage();
            this.delete = new Delete();
            this.revEngineer = new RevEngineer();
            this.add(this.select);
            this.add(this.newTable);
            this.add(this.newTableView);
            this.add(this.splitTable);
            this.add(this.mergeTables);
            this.add(this.newFK);
            this.add(this.newTypeSubstitution);
            this.add(this.newArc);
            this.add(this.add2Arc);
            this.add(this.removeFromArc);
            this.add(this.newNote);
            this.add(this.newImage);
            this.add(this.delete);
            this.add(this.revEngineer);
        }
        this.zoomIn = new ZoomIn();
        this.add(this.zoomIn);
        this.zoomOut = new ZoomOut();
        this.add(this.zoomOut);
        this.fitScreen = new FitScreen();
        this.add(this.fitScreen);
        this.actualSize = new ActualSize();
        this.add(this.actualSize);
        this.search = new Search();
        this.add(this.search);
        this.generateDDL = new GenerateDDL();
        this.add(this.generateDDL);
        if (ApplicationView.debugMode) {
            // empty if block
        }
        this.syncModelWithDict = new SyncModelWithDataDictionary();
        this.add(this.syncModelWithDict);
        this.syncDictWithModel = new SyncDataDictionaryWithModel();
        this.add(this.syncDictWithModel);
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerRelational.Relational");
    }

    public DPVRelational getDPVPhysical() {
        return (DPVRelational)this.designPV;
    }

    @Override
    public void setDesignPartView(DesignPartView dpv) {
        this.designPV = dpv;
    }

    @Override
    public DesignPartView getDesignPartView() {
        return this.getDPVPhysical();
    }

    public DesignPartView getCurrentDPV() {
        return this.designPV;
    }

    @Override
    public RelationalDesign getPhysicalDesign() {
        if (this.getCurrentDPV() != null && this.getCurrentDPV().getDesignPart() instanceof RelationalDesign) {
            return (RelationalDesign)this.getCurrentDPV().getDesignPart();
        }
        return super.getPhysicalDesign();
    }

    @Override
    public boolean canPaste() {
        for (Object obj : this.getApplicationView().getCopiedObjects()) {
            if (obj == null || !(obj instanceof Table) && !(obj instanceof TableView) && !(obj instanceof Note) && !(obj instanceof ImageObject)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paste(Point pt) {
        if (this.canPaste()) {
            RelationalDesign rd = this.getPhysicalDesign();
            try {
                Rectangle2D rect;
                ApplicationView.canLogging = false;
                int xx = 0;
                int yy = 0;
                Point2D pp = null;
                if (pt != null) {
                    pp = this.getDesignPartView().getWorkSpace().fromScreen(new Point2D.Double(pt.x, pt.y));
                }
                ArrayList<TopView> selectedTVs = this.getApplicationView().getCopiedTopViews();
                DesignPartView sdpv = null;
                if (selectedTVs.size() == 0) {
                    selectedTVs = new ArrayList<TopView>();
                    for (Object obj : this.getApplicationView().getCopiedObjects()) {
                        if (!(obj instanceof DesignObject)) continue;
                        selectedTVs.add(((DesignObject)obj).getTopView());
                    }
                }
                if (selectedTVs.size() > 0) {
                    sdpv = ((TopView)selectedTVs.get(0)).getDesignPartView();
                }
                if ((rect = this.getDesignPartView().getTopViewsBounds(selectedTVs)) != null && sdpv != null && sdpv == this.getDesignPartView()) {
                    xx = (int)(pp.getX() - rect.getX());
                    yy = (int)(pp.getY() - rect.getY());
                } else {
                    xx = (int)pp.getX();
                    yy = (int)pp.getY();
                }
                HashMap<String, Table> copiedMap = null;
                int num = this.getApplicationView().getCopiedObjects().size();
                GroupCreateEdit groupEdit = null;
                if (num > 0) {
                    DesignObject dob = (DesignObject)this.getApplicationView().getCopiedObjects().get(0);
                    if (!(dob.getDesignPart() instanceof RelationalDesign)) {
                        return;
                    }
                    groupEdit = num == 1 ? new GroupCreateEdit(dob, "Redo Paste of " + dob.getLongName(), "Undo Paste of " + dob.getLongName()) : new GroupCreateEdit(dob);
                } else {
                    return;
                }
                rd.getUndoManager().setLocked(true);
                try {
                    HashMap<DesignObject, DesignObject> map = new HashMap<DesignObject, DesignObject>();
                    for (TopView tv : selectedTVs) {
                        Rectangle r;
                        TopView ctv;
                        TopView topView;
                        MultiShapedDesignObject copied;
                        DesignObject obj = tv.getModel();
                        if (map.containsKey(obj)) continue;
                        map.put(obj, obj);
                        if (obj instanceof Table) {
                            ApplicationView.log(Messages.getString("ControllerRelational.CreateTable"));
                            copied = (Table)obj;
                            Table table = ((RelationalDesign)this.getDesignPartView().getDesignPart()).createTable();
                            if (copiedMap == null) {
                                copiedMap = new HashMap<String, Table>();
                            }
                            copiedMap.put(copied.getObjectID(), table);
                            ((Table)copied).copy(table, copiedMap);
                            topView = this.getDesignPartView().getViewFor(table);
                            if (topView == null || topView.getCellView() == null) continue;
                            ctv = tv;
                            if (ctv != null && ctv.getCellView() != null) {
                                r = new Rectangle(ctv.getCellView().getBounds().getBounds());
                                if (pp != null) {
                                    r.x += xx;
                                    r.y += yy;
                                } else {
                                    r.x += 30 + xx;
                                    r.y += 30 + yy;
                                }
                                topView.getCellView().setNewBounds(r);
                            }
                            CreateDO_Edit.addUndoableCreateEditForObject(groupEdit, table);
                            continue;
                        }
                        if (obj instanceof TableView) {
                            ApplicationView.log(Messages.getString("ControllerRelational.CreateView"));
                            copied = (TableView)obj;
                            TableView tableView = ((RelationalDesign)this.getDesignPartView().getDesignPart()).getTableViewSet().createTableView(null);
                            if (copiedMap == null) {
                                copiedMap = new HashMap();
                            }
                            copiedMap.put(copied.getObjectID(), (Table)((Object)tableView));
                            ((TableView)copied).copy(tableView, copiedMap);
                            topView = this.getDesignPartView().getViewFor(tableView);
                            if (topView == null || topView.getCellView() == null || (ctv = tv) == null || ctv.getCellView() == null) continue;
                            r = new Rectangle(ctv.getCellView().getBounds().getBounds());
                            if (pp != null) {
                                r.x += xx;
                                r.y += yy;
                            } else {
                                r.x += 30 + xx;
                                r.y += 30 + yy;
                            }
                            topView.getCellView().setNewBounds(r);
                            CreateDO_Edit.addUndoableCreateEditForObject(groupEdit, tableView);
                            continue;
                        }
                        if (obj instanceof Note) {
                            ApplicationView.log(Messages.getString("ControllerRelational.CreateNote"));
                            copied = (Note)obj;
                            Note note = ((RelationalDesign)this.getDesignPartView().getDesignPart()).createNote();
                            copied.copy(note);
                            topView = this.getDesignPartView().getViewFor(note);
                            if (topView == null || topView.getCellView() == null || (ctv = tv) == null || ctv.getCellView() == null) continue;
                            r = new Rectangle(ctv.getCellView().getBounds().getBounds());
                            if (pp != null) {
                                r.x += xx;
                                r.y += yy;
                            } else {
                                r.x += 30 + xx;
                                r.y += 30 + yy;
                            }
                            topView.getCellView().setNewBounds(r);
                            ctv.copy(topView);
                            CreateDO_Edit.addUndoableCreateEditForObject(groupEdit, note);
                            continue;
                        }
                        if (!(obj instanceof ImageObject)) continue;
                        ApplicationView.log(Messages.getString("ControllerRelational.CreateImage"));
                        copied = (ImageObject)obj;
                        ImageObject image = ((RelationalDesign)this.getDesignPartView().getDesignPart()).createImage();
                        ((ImageObject)copied).copy(image);
                        topView = this.getDesignPartView().getViewFor(image);
                        if (topView == null || topView.getCellView() == null || (ctv = tv) == null || ctv.getCellView() == null) continue;
                        r = new Rectangle(ctv.getCellView().getBounds().getBounds());
                        if (pp != null) {
                            r.x += xx;
                            r.y += yy;
                        } else {
                            r.x += 30 + xx;
                            r.y += 30 + yy;
                        }
                        topView.getCellView().setNewBounds(r);
                        CreateDO_Edit.addUndoableCreateEditForObject(groupEdit, image);
                    }
                    if (copiedMap != null) {
                        FKContainer oldTable;
                        Object newTable;
                        ApplyNamingStandards applyNS = new ApplyNamingStandards(this.getDesign().getDesignLevelSettings().getNamingStandardRule(), true, true, true, true, true, true, false, true, true);
                        for (DesignObject obj : this.getApplicationView().getCopiedObjects()) {
                            if (!(obj instanceof FKContainer) || !((newTable = copiedMap.get((oldTable = (FKContainer)obj).getObjectID())) instanceof FKContainer)) continue;
                            List<FKIndexAssociation> list = oldTable.copyForeignKeys((FKContainer)newTable, copiedMap);
                            if (oldTable.getDesignPart() == ((FKContainer)newTable).getDesignPart()) {
                                try {
                                    ApplyNamingStandards.inCopyPasteOperation = true;
                                    applyNS.apply((FKContainer)newTable);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                finally {
                                    ApplyNamingStandards.inCopyPasteOperation = false;
                                }
                            }
                            for (FKIndexAssociation fk : list) {
                                CreateDO_Edit.addUndoableCreateEditForObject(groupEdit, fk);
                            }
                        }
                        for (DesignObject obj : this.getApplicationView().getCopiedObjects()) {
                            if (!(obj instanceof FKContainer) || !((newTable = copiedMap.get((oldTable = (FKContainer)obj).getObjectID())) instanceof FKContainer)) continue;
                            for (FKArc arc : oldTable.getArcs()) {
                                FKArc newarc = ((FKContainer)newTable).getRelationalModel().createArc();
                                newarc.setTable((FKContainer)newTable);
                                arc.copy(newarc, copiedMap);
                                if (newarc.getFkeys().size() > 1) {
                                    ((FKContainer)newTable).addArc(newarc);
                                    CreateDO_Edit.addUndoableCreateEditForObject(groupEdit, newarc);
                                    continue;
                                }
                                newarc.remove();
                            }
                        }
                    }
                    this.getDesign().setDirty(true);
                }
                finally {
                    rd.getUndoManager().setLocked(false);
                }
                int size = groupEdit.getNumberOfEdits();
                groupEdit.end();
                if (size > 0) {
                    rd.postUndoableEdit(groupEdit);
                }
            }
            finally {
                ApplicationView.canLogging = true;
                this.getDesignPartView().getDesignPart().sortCollections();
            }
        }
    }

    public JMenu getObjectRelationalMenu() {
        return this.getApplicationView().getControllerSet().getMenuStructure().get(this.OBJECT_PHYSICAL_PATH);
    }

    @Override
    public void select_SelectAction() {
        if (this.fkCollector != null) {
            this.fkCollector.stopWaiting();
        }
        this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
        this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
    }

    public Select getSelectAction() {
        return this.select;
    }

    public NewTable getNewTableAction() {
        return this.newTable;
    }

    public NewTableView getNewTableViewAction() {
        return this.newTableView;
    }

    public SplitTable getSplitTableAction() {
        return this.splitTable;
    }

    public MergeTables getMergeTablesAction() {
        return this.mergeTables;
    }

    public NewFKRelation getNewFKAction() {
        return this.newFK;
    }

    public NewTypeSubstitution getNewTypeSubstitutionAction() {
        return this.newTypeSubstitution;
    }

    public NewArc getNewArcAction() {
        return this.newArc;
    }

    public AddToArc getAddToArcAction() {
        return this.add2Arc;
    }

    public RemoveFromArc getRemoveFromArcAction() {
        return this.removeFromArc;
    }

    public NewNote getNewNoteAction() {
        return this.newNote;
    }

    public NewImage getNewImageAction() {
        return this.newImage;
    }

    public Delete getDeleteAction() {
        return this.delete;
    }

    public RevEngineer getRevEngineerAction() {
        return this.revEngineer;
    }

    public ZoomIn getZoomInAction() {
        return this.zoomIn;
    }

    public ZoomOut getZoomOutAction() {
        return this.zoomOut;
    }

    public FitScreen getFitScreenAction() {
        return this.fitScreen;
    }

    public ActualSize getDefaultSizeAction() {
        return this.actualSize;
    }

    @Override
    public MDBAction getFindAction() {
        return this.search;
    }

    public GenerateDDL getGenerateDDLAction() {
        return this.generateDDL;
    }

    public SyncModelWithDataDictionary getSyncModelWithDictAction() {
        return this.syncModelWithDict;
    }

    public SyncDataDictionaryWithModel getSyncDictWithModelAction() {
        return this.syncDictWithModel;
    }

    @Override
    public void updateActions() {
        boolean enabled = true;
        if (this.getDesign().isLoadFromDB() && this.getDesignPartView().getDesignPart().getRepositoryOID() != null) {
            enabled = this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }
        this.getDesignPartView().getWorkSpace().updateReadOnlyStatus();
        this.setEnabled(this.newTable, enabled);
        this.setEnabled(this.newTableView, enabled);
        this.setEnabled(this.splitTable, enabled);
        this.setEnabled(this.mergeTables, enabled);
        this.setEnabled(this.newFK, enabled);
        this.setEnabled(this.newTypeSubstitution, enabled);
        this.setEnabled(this.newArc, enabled);
        this.setEnabled(this.add2Arc, enabled);
        this.setEnabled(this.removeFromArc, enabled);
        this.setEnabled(this.newNote, enabled);
        this.setEnabled(this.newImage, enabled);
        this.setEnabled(this.delete, enabled);
    }

    public DockStation getDockStation() {
        if (this.dockStation == null) {
            this.dockStation = DockStation.getDockStation();
        }
        return this.dockStation;
    }

    class Search
    extends MDBAction {
        private Search() {
            super(MenuUtils.getMnemonicStr(AbstractController.SEARCH_CAPTION), ControllerRelational.this.getConfiguration().getIcon("SEARCH_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SEARCH_CAPTION));
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPart dp = ControllerRelational.this.getDesignPartView().getDesignPart();
            SearchDockable lastNonPinnedView = dp.getLastNonPinnedSearchDockable();
            if (lastNonPinnedView == null) {
                ViewId vId = new ViewId(new GUID().toString(), Integer.toString(dp.getSearchDockableIdSequence()));
                SearchDockable sdNew = new SearchDockable(vId);
                dp.addSearchDockable(sdNew);
                ((SearchPanel)sdNew.getGUI()).resetItems(dp);
                sdNew.show();
            } else {
                ControllerRelational.this.getDockStation().activateDockable((Dockable)lastNonPinnedView);
            }
        }
    }

    class ActualSize
    extends MDBAction {
        private ActualSize() {
            super(MenuUtils.getMnemonicStr(AbstractController.ACTUAL_SIZE_CAPTION), ControllerRelational.this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ACTUAL_SIZE_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerRelational.this.getApplicationView().getCurrentDPV();
            dpv.actualSize();
        }
    }

    class FitScreen
    extends MDBAction {
        private FitScreen() {
            super(MenuUtils.getMnemonicStr(AbstractController.FIT_SCREEN_CAPTION), ControllerRelational.this.getConfiguration().getIcon("FIT_SCREEN_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.FIT_SCREEN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerRelational.this.getApplicationView().getCurrentDPV();
            dpv.fitScreen();
        }
    }

    class ZoomOut
    extends MDBAction {
        private ZoomOut() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_OUT_CAPTION), ControllerRelational.this.getConfiguration().getIcon("ZOOM_OUT_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_OUT_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerRelational.this.getApplicationView().getCurrentDPV();
            dpv.zoomOut();
        }
    }

    class ZoomIn
    extends MDBAction {
        private ZoomIn() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_IN_CAPTION), ControllerRelational.this.getConfiguration().getIcon("ZOOM_IN_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_IN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addToolbarSeparator() {
            return ControllerRelational.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerRelational.this.getApplicationView().getCurrentDPV();
            dpv.zoomIn();
        }
    }

    class TableCollectorMerge
    extends TableCollector {
        DenormalizerMergeTable denormalizer;

        TableCollectorMerge(DenormalizerMergeTable denormalizer) {
            this.denormalizer = null;
            this.denormalizer = denormalizer;
        }

        private String title() {
            return Messages.getString("ControllerRelational.MergeTables");
        }

        @Override
        public void pointsSelected(Point[] points) {
            ControllerRelational.this.select.actionPerformed(null);
            ContainerView source = this.getTVTableFor(points[0]);
            ContainerView target = this.getTVTableFor(points[1]);
            String errors = null;
            if (source == null) {
                errors = Messages.getString("ControllerRelational.NoSourceTableSelected");
            } else if (target == null) {
                errors = Messages.getString("ControllerRelational.NoTargetTableSelected");
            } else if (source == target) {
                errors = Messages.getString("ControllerRelational.SelectTwoDifferentTables");
            }
            if (errors == null) {
                this.doIt(source, target);
            } else {
                MessageDialogs.showErrorMessage(ControllerRelational.this.getApplicationView().getFrame(), errors);
            }
        }

        @Override
        public void doIt(ContainerView source, ContainerView target) {
            this.doMerge((Table)source.getModel(), (Table)target.getModel());
        }

        private void doMerge(Table source, Table target) {
            this.denormalizer.setSource(source);
            this.denormalizer.setTarget(target);
            if (this.denormalizer.canMerge()) {
                ArrayList<String> list = new ArrayList<String>(5);
                list.add(Messages.getString("ControllerRelational.AreYouSureMergeTables"));
                Object[] message = list.toArray();
                int choice = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), message, Messages.getString("ControllerRelational.MergeTables"), 0, 3);
                if (choice == 0) {
                    this.denormalizer.merge();
                }
            } else if (!this.denormalizer.isTargetable(target)) {
                ArrayList<String> errors = new ArrayList<String>(2);
                errors.add(Messages.getString("ControllerRelational.CanNotMergeTables"));
                if (!source.hasPK()) {
                    errors.add(Messages.getString("ControllerRelational.SourceTableDoesNotHavePK"));
                } else if (!target.hasFKAssociationFor(source.getPK())) {
                    errors.add(Messages.getString("ControllerRelational.TargetHasNoFKRelationToSource"));
                }
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), errors.toArray(), this.title(), 0);
            }
        }
    }

    class TableCollectorFKRelation
    extends TableCollector {
        TableCollectorFKRelation() {
        }

        @Override
        public void doIt(ContainerView source, ContainerView target) {
            FKIndexAssociation fk = this.createRelation(source, target);
            if (fk != null && fk.getDesign().getAppView().getSettings().showPropertiesDialogOnNew()) {
                ForeignKeyPropertiesDialogEx dialog = new ForeignKeyPropertiesDialogEx(ControllerRelational.this.getApplicationView(), fk);
                dialog.initProperties(fk);
                dialog.setModal(true);
                dialog.show();
            } else {
                fk.resetMandatoryUsingColumns();
            }
            if (source == target && !source.getDesignPartView().isAutoRoute()) {
                fk.createDefaultSelfReferencePoints();
            }
            if (fk.getDesignObjectSet() != DesignObjectSet.NULL_SET) {
                ((RelationalDesign)fk.getDesignPart()).postFKCreateEdit(fk);
                fk.resetEdgeParams();
            }
        }

        private FKIndexAssociation createRelation(ContainerView source, ContainerView target) {
            ApplicationView.log(Messages.getString("ControllerRelational.CreateFKRelation"));
            FKContainer child = (FKContainer)target.getModel();
            KeyObject index = ((FKContainer)source.getModel()).getPKorUnique();
            FKIndexAssociation fk = child.addFK(index);
            if (fk != null) {
                fk.setSourceTVTable(source);
                fk.setTargetTVTable(target);
                if (child == source.getModel()) {
                    fk.setMandatory(false);
                }
                fk.setName(FKUtilities.generateFKName(child, (FKContainer)source.getModel(), index));
                fk.addToAllDPVs();
                fk.resetEdgeParams();
            }
            return fk;
        }
    }

    abstract class TableCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;

        protected TableCollector() {
            this.startCollecting();
        }

        public void startCollecting() {
            ControllerRelational.this.getDesignPartView().getWorkSpace().clearSelection();
            this.collect();
        }

        protected void collect() {
            this.glassComp = ControllerRelational.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        private String title() {
            return Messages.getString("ControllerRelational.NewFKRelation");
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] points) {
            KeyObject pk;
            ContainerView sourceTVT = this.getTVTableFor(points[0]);
            ContainerView targetTVT = this.getTVTableFor(points[1]);
            FKContainer source = null;
            FKContainer target = null;
            if (sourceTVT != null) {
                source = (FKContainer)sourceTVT.getModel();
            }
            if (targetTVT != null) {
                target = (FKContainer)targetTVT.getModel();
            }
            ArrayList<String> errors = new ArrayList<String>(2);
            if (source == null) {
                errors.add(Messages.getString("ControllerRelational.NoSourceTableSelected"));
            } else if (!source.hasPK() && !source.hasUnique()) {
                errors.add(Messages.getString("ControllerRelational.SourceTabledoesNotHavePKorUC"));
            }
            if (target != null && target.isRemoteObject()) {
                errors.add(Messages.getString("ControllerRelational.TargetTableMustBeLocalTable"));
            }
            if (source != null && source.isBST() && (pk = source.getPK()) == null) {
                errors.add(Messages.getString("ControllerRelational.ParentTableShouldHavePK"));
            }
            if (target == null) {
                errors.add(Messages.getString("ControllerRelational.NoTargetTableSelected"));
            }
            if (source != null && target != null && (source.getTypeSubstitution() != null || target.getTypeSubstitution() != null)) {
                errors.add(Messages.getString("ControllerRelational.TableCannotParticipateInFKrelationship"));
            }
            this.checkFKPossibility(source, target, errors);
            if (errors.size() == 0) {
                this.doIt(sourceTVT, targetTVT);
            } else {
                JOptionPane.showMessageDialog(ControllerRelational.this.getDesignPartView(), errors.toArray(), this.title(), 0);
            }
            ControllerRelational.this.select_SelectAction();
        }

        private void checkFKPossibility(FKContainer parent, FKContainer child, List errors) {
            KeyObject parentPK;
            if (parent != null && child != null && child.isBST() && parent.isBST() && (parentPK = parent.getPK()) != null) {
                Iterator it = parentPK.getElementsCollection().iterator();
                while (it.hasNext()) {
                    FKElement col;
                    if (!((FKElement)it.next()).isOid() || (col = (FKElement)child.getRefToStructurtedType(parent.getBasedOnStructuredType(), parent)) != null) continue;
                    errors.add(Messages.getString("ControllerRelational.ChildTableDoesntHaveReferenceColumn"));
                }
            }
        }

        protected ContainerView getTVTableFor(Point point) {
            Object cell = ControllerRelational.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (cell != null && cell instanceof TableDiagramCell) {
                return (ContainerView)((TableDiagramCell)cell).getTopView();
            }
            if (cell != null && cell instanceof TableViewDiagramCell) {
                return (ContainerView)((TableViewDiagramCell)cell).getTopView();
            }
            return null;
        }

        public abstract void doIt(ContainerView var1, ContainerView var2);

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerRelational.this.getDesignPartView().getWorkSpace();
        }
    }

    class RemoveFromArc
    extends MDBAction {
        private RemoveFromArc() {
            super(MenuUtils.getMnemonicStr(AbstractController.REMOVE_FK_FROM_ARC), ControllerRelational.this.getConfiguration().getIcon("REMOVE_FROM_ARC_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.REMOVE_FK_FROM_ARC));
            this.setObjectAction(true);
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable && this.canHandle());
        }

        private boolean canHandle() {
            if (ControllerRelational.this.getDesign().isLoadFromDB() && !ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe()) {
                return false;
            }
            Object[] selectedObjects = ControllerRelational.this.getDesignPartView().getSelectedObjects();
            return ControllerRelational.this.getPhysicalDesign() != null && ControllerRelational.this.getPhysicalDesign().canRemoveFromArc(selectedObjects);
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Object[] selectedObjects = ControllerRelational.this.getDesignPartView().getSelectedObjects();
            ControllerRelational.this.getPhysicalDesign().removeFromArc(selectedObjects);
            ControllerRelational.this.getDesignPartView().fireSelectionChanged();
        }
    }

    class AddToArc
    extends MDBAction {
        private AddToArc() {
            super(MenuUtils.getMnemonicStr(AbstractController.ADD_FK_TO_ARC), ControllerRelational.this.getConfiguration().getIcon("ADD_TO_ARC_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ADD_FK_TO_ARC));
            this.setObjectAction(true);
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable && this.canHandle());
        }

        private boolean canHandle() {
            if (ControllerRelational.this.getDesign().isLoadFromDB() && !ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe()) {
                return false;
            }
            Object[] selectedObjects = ControllerRelational.this.getDesignPartView().getSelectedObjects();
            return ControllerRelational.this.getPhysicalDesign() != null && ControllerRelational.this.getPhysicalDesign().canAddToArc(selectedObjects);
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Object[] selectedObjects = ControllerRelational.this.getDesignPartView().getSelectedObjects();
            for (int i = 0; i < selectedObjects.length; ++i) {
                if (!(selectedObjects[i] instanceof FKIndexAssociation) || !((FKIndexAssociation)selectedObjects[i]).isMandatory()) continue;
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerRelational.MandatoryForeignKeyCannotBeInArc"), Messages.getString("ControllerRelational.ArcDefinition"), 0);
                return;
            }
            ControllerRelational.this.getPhysicalDesign().addToArc(selectedObjects);
            ControllerRelational.this.getDesignPartView().fireSelectionChanged();
        }
    }

    class NewArc
    extends MDBAction {
        private NewArc() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_ARC), ControllerRelational.this.getConfiguration().getIcon("NEW_ARC_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_ARC));
            this.setObjectAction(true);
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable && this.canHandle());
        }

        private boolean canHandle() {
            if (ControllerRelational.this.getDesign().isLoadFromDB() && !ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe()) {
                return false;
            }
            Object[] selectedObjects = ControllerRelational.this.getDesignPartView().getSelectedObjects();
            if (selectedObjects.length < 2) {
                return false;
            }
            return ControllerRelational.this.getPhysicalDesign() != null && (ControllerRelational.this.getPhysicalDesign().canCreateArc(selectedObjects) || ControllerRelational.this.getPhysicalDesign().canCreatereverseArc(selectedObjects));
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            Object[] selectedObjects = ControllerRelational.this.getDesignPartView().getSelectedObjects();
            FKArc arc = null;
            if (!ControllerRelational.this.getPhysicalDesign().canCreatereverseArc(selectedObjects)) {
                for (int i = 0; i < selectedObjects.length; ++i) {
                    if (!(selectedObjects[i] instanceof FKIndexAssociation) || !((FKIndexAssociation)selectedObjects[i]).isMandatory()) continue;
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerRelational.MandatoryForeignKeyCannotBeInArc"), Messages.getString("ControllerRelational.ArcDefinition"), 0);
                    return;
                }
            }
            arc = ControllerRelational.this.getPhysicalDesign().createArc(selectedObjects);
            ControllerRelational.this.getPhysicalDesign().postFKArcCreateEdit(arc);
            ControllerRelational.this.getDesignPartView().fireSelectionChanged();
        }
    }

    class TypedElementCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;

        protected TypedElementCollector() {
            this.collect();
        }

        protected void collect() {
            this.glassComp = ControllerRelational.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        private String title() {
            return Messages.getString("ControllerRelational.NewTypeSubstitution");
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] points) {
            ContainerView sourceTV = this.getContainerViewFor(points[0]);
            ContainerView targetTV = this.getContainerViewFor(points[1]);
            ContainerObject source = null;
            ContainerObject target = null;
            if (sourceTV != null) {
                source = (ContainerObject)sourceTV.getModel();
            }
            if (targetTV != null) {
                target = (ContainerObject)targetTV.getModel();
            }
            ArrayList<String> errors = new ArrayList<String>(2);
            if (source != null && target != null) {
                if (target == source) {
                    errors.add(Messages.getString("ControllerRelational.TwoDifferentObjectsMustBeSelected"));
                }
                if (source.getClass() != target.getClass()) {
                    errors.add(Messages.getString("ControllerRelational.TwoObjectsSameKindShouldBeSelected"));
                }
                if (!source.isBST() || !target.isBST()) {
                    errors.add(Messages.getString("ControllerRelational.ObjectsStructuredTypeCanBeSelected"));
                }
                if (source.isBST() && target.isBST()) {
                    if (source.getBasedOnStructuredType().getParentType() != target.getBasedOnStructuredType() && target.getBasedOnStructuredType().getParentType() != source.getBasedOnStructuredType()) {
                        errors.add(Messages.getString("ControllerRelational.ObjectsStructuredTypeDirectSubTypeCanBeSelected"));
                    } else if (source.getBasedOnStructuredType().getParentType() == target.getBasedOnStructuredType()) {
                        if (source.getTypeSubstitution() != null) {
                            errors.add(MessageFormat.format(Messages.getString("ControllerRelational.TypeSubstitutionDefined"), source.getName()));
                        }
                        if (source instanceof Table && ((Table)source).isReferencedByFKs()) {
                            errors.add(MessageFormat.format(Messages.getString("ControllerRelational.ChildTableReferenced"), source.getName()));
                        }
                    } else if (target.getBasedOnStructuredType().getParentType() == source.getBasedOnStructuredType()) {
                        if (target.getTypeSubstitution() != null) {
                            errors.add(MessageFormat.format(Messages.getString("ControllerRelational.TypeSubstitutionDefined"), target.getName()));
                        }
                        if (target instanceof Table && ((Table)target).isReferencedByFKs()) {
                            errors.add(MessageFormat.format(Messages.getString("ControllerRelational.ChildTableReferenced"), source.getName()));
                        }
                    }
                }
                if (errors.size() == 0) {
                    this.doIt(sourceTV, targetTV);
                } else {
                    JOptionPane.showMessageDialog(ControllerRelational.this.getDesignPartView(), errors.toArray(), this.title(), 0);
                }
            } else {
                errors.add(Messages.getString("ControllerRelational.ErrorInObjectSelection"));
                JOptionPane.showMessageDialog(ControllerRelational.this.getDesignPartView(), errors.toArray(), this.title(), 0);
            }
            ControllerRelational.this.select_SelectAction();
        }

        protected ContainerView getContainerViewFor(Point point) {
            Object cell = ControllerRelational.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (cell != null && cell instanceof ContainerDiagramCell) {
                return (ContainerView)((ContainerDiagramCell)cell).getTopView();
            }
            return null;
        }

        public void doIt(ContainerView sourceTV, ContainerView targetTV) {
            ContainerObject child = null;
            ContainerObject parent = null;
            ContainerObject source = null;
            ContainerObject target = null;
            ContainerView childTV = null;
            ContainerView parentTV = null;
            if (sourceTV != null) {
                source = (ContainerObject)sourceTV.getModel();
            }
            if (targetTV != null) {
                target = (ContainerObject)targetTV.getModel();
            }
            if (source != null && target != null) {
                if (source.getBasedOnStructuredType() == target.getBasedOnStructuredType().getParentType()) {
                    parent = source;
                    child = target;
                    parentTV = sourceTV;
                    childTV = targetTV;
                } else if (source.getBasedOnStructuredType().getParentType() == target.getBasedOnStructuredType()) {
                    child = source;
                    parent = target;
                    childTV = sourceTV;
                    parentTV = targetTV;
                }
                if (child != null && parent != null) {
                    TypeSubstitution ts = ControllerRelational.this.getDesign().getRelationalDesign().createTypeSubstitution();
                    ts.setChildCV(childTV);
                    ts.setParentCV(parentTV);
                    ts.addToAllDPVs();
                }
            }
        }

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerRelational.this.getDesignPartView().getWorkSpace();
        }
    }

    class GenerateXML
    extends MDBAction {
        private GenerateXML() {
            super(MenuUtils.getMnemonicStr(""), ControllerRelational.this.getConfiguration().getIcon("DDL_PREVIEW_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey("Generate XML"));
            this.setAccelerator(KeyStroke.getKeyStroke(71, 64, false));
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        void test() {
            RelationalDesign reldp = (RelationalDesign)ControllerRelational.this.getDPVPhysical().getDesignPart();
            ControllerRelational.this.getDesign().setRelationalDesign(reldp);
            Iterator it = reldp.getTableSet().iterator();
            String url1 = "file:///:D:/HS_IO_test/tab1.xml";
            String burl = "file:///:D:/HS_IO_test/";
            URL url = null;
            try {
                url = new URL(url1);
            }
            catch (MalformedURLException e2) {
                // empty catch block
            }
            URL b_url = null;
            try {
                b_url = new URL(burl);
            }
            catch (MalformedURLException e2) {
                // empty catch block
            }
            FileWriter outFile = null;
            try {
                outFile = new FileWriter("d:/HS_IO_test/HSio_Test.xml");
            }
            catch (IOException e1) {
                // empty catch block
            }
            HashStructureIO hio = new HashStructureIO(url1, "Table");
            PrintWriter out = new PrintWriter(outFile);
            boolean saved = false;
            while (it.hasNext()) {
                Table table = (Table)it.next();
                HashStructure hs = HashStructure.newInstance();
                hs.putString("name", table.getName());
                hs.putString("abbreviation", table.getAbbreviation());
                hs.putString("ID", table.getObjectID());
                hs.putString("class", table.getClass().getName());
                ListStructure columns = hs.getOrCreateListStructure("columns");
                ContainedObject[] cols = table.getElements();
                for (int i = 0; i < cols.length; ++i) {
                    Column col = (Column)cols[i];
                    HashStructure chs = HashStructure.newInstance();
                    ChangeBuffer cb = new ChangeBuffer();
                    chs.putString("type", "Column");
                    chs.putString("ID", col.getObjectID());
                    chs.putString("class", col.getClass().getName());
                    HashStructure chs2 = HashStructure.newInstance();
                    chs2.putString("name", col.getName());
                    chs2.putString("abbreviation", col.getAbbreviation());
                    chs2.putString("dataType", col.getDataType().toString());
                    chs2.putInt("position", i);
                    chs.putHashStructure("properties", chs2);
                    chs.markDirty(false);
                    columns.add((Object)chs);
                    chs.addStructureChangeListener((StructureChangeListener)cb);
                    chs.isDirty();
                    chs.removeStructureChangeListener((StructureChangeListener)cb);
                }
                if (!saved) {
                    try {
                        hio.save(url, (Object)hs);
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    saved = true;
                }
                try {
                    hio.write(hs, (Writer)out, b_url);
                }
                catch (IOException e1) {}
            }
            out.close();
            try {
                b_url = new URL("file:///:d:/HS_IO_test/HSio_Test.xml");
            }
            catch (MalformedURLException e2) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doActionPerformed(ActionEvent e) {
            MetaDataManager mdm = new MetaDataManager();
            MDTransformationManager trMan = new MDTransformationManager(mdm);
            trMan.registerTransformer(ModelIDObject.class, XMLFromObjTransformer.class, XMLToObjectTransformer.class, XMLObjToStreamTransformer.class);
            trMan.registerTransformer(Object.class, XMLFromObjTransformer.class, XMLToObjectTransformer.class, XMLObjToStreamTransformer.class);
            RelationalDesign design = (RelationalDesign)ControllerRelational.this.getDPVPhysical().getDesignPart();
            MDTransformer.SKP_DEFAULTS = true;
            boolean write = false;
            if (design != null) {
                String path = MDTransformer.SKP_DEFAULTS ? "d:/txml_ext/" : "d:/txmld_ext/";
                ControllerRelational.this.getDesign().setRelationalDesign(design);
                System.out.println("begin test: " + System.currentTimeMillis());
                if (write) {
                    ArrayList<Design> list = new ArrayList<Design>();
                    list.add(design.getDesign());
                    for (Object e2 : list) {
                        MDTransformationManager.TrObjects trs = trMan.getTransformersFor(e2.getClass());
                        String xml = "";
                        try {
                            if (trs.getFromObjectTransformer() != null) {
                                xml = ((XMLFromObjTransformer)trs.getFromObjectTransformer()).transformFromObjectToString(e2, true);
                            }
                        }
                        catch (Exception e22) {
                            // empty catch block
                        }
                        FileWriter outFile = null;
                        try {
                            String id;
                            String opath = path + this.getObjectType(e2) + "/";
                            if (e2 instanceof EntityView) {
                                opath = path + "EntityView/";
                            } else if (e2 instanceof ExtendedMap) {
                                opath = path + "mapping/";
                            }
                            if ("".equals(id = this.getObjectID(e2))) continue;
                            File file = new File(opath);
                            if (!file.exists()) {
                                file.mkdirs();
                            }
                            String fname = opath + id + ".xml";
                            outFile = new FileWriter(fname);
                            outFile.write(xml);
                            outFile.flush();
                            outFile.close();
                        }
                        catch (IOException e1) {}
                    }
                } else {
                    try {
                        ApplicationView.canLogging = false;
                        ControllerRelational.this.getDesign().setPropagatePKChahges(false);
                        ApplicationView.loading = true;
                        this.readFiles(path, trMan);
                        System.out.println("begin arrange: " + System.currentTimeMillis());
                    }
                    finally {
                        ControllerRelational.this.getDesign().setPropagatePKChahges(true);
                        ApplicationView.canLogging = true;
                        ApplicationView.loading = false;
                        ControllerRelational.this.getDesign().getAppView().getBrowserPanel().getNavigationTreeDesign().updateSubtree(ControllerRelational.this.getDesign());
                    }
                }
                System.out.println("end test: " + System.currentTimeMillis());
            }
        }

        private String getObjectID(Object object) {
            if (object instanceof ModelIDObject) {
                return ((ModelIDObject)object).getObjectID();
            }
            if (object instanceof DesignPartView) {
                DesignPartView dpv = (DesignPartView)object;
                return dpv.getDPVId();
            }
            if (object instanceof ExtendedMap) {
                return "ExtendedMap";
            }
            return "";
        }

        private String getObjectType(Object object) {
            if (object instanceof ModelIDObject) {
                return ((ModelIDObject)object).getObjectTypeName();
            }
            if (object instanceof DesignPartView) {
                DesignPartView dpv = (DesignPartView)object;
                if (dpv.getDesignPart() instanceof RelationalDesign) {
                    return "reldiagrams";
                }
                if (dpv.getDesignPart() instanceof LogicalDesign) {
                    return "logdiagrams";
                }
            }
            return "others";
        }

        private String getID(File file) {
            String name = file.getName();
            int ind = name.indexOf(".xml");
            if (ind > -1) {
                return name.substring(0, ind);
            }
            return null;
        }

        private void readFiles(String path, MDTransformationManager trMan) {
            this.readFiles(path, "Design", trMan);
        }

        private void readFiles(String path, String objectType, MDTransformationManager trMan) {
            File file = new File(path + "/" + objectType);
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    MDTransformationManager.TrObjects trs;
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(files[i]);
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                    if (is == null) continue;
                    InputStreamReader reader = null;
                    try {
                        reader = new InputStreamReader((InputStream)is, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                    if (reader == null) continue;
                    InputSource inputSource = new InputSource(reader);
                    String id = this.getID(files[i]);
                    Object object = null;
                    if (id != null) {
                        object = ControllerRelational.this.getDesign().getDesignObject(id);
                    }
                    if (objectType.equalsIgnoreCase("reldiagrams")) {
                        object = ControllerRelational.this.getDesign().getRelationalDesign().getMainView();
                    }
                    if (objectType.equalsIgnoreCase("RelationalModel")) {
                        object = ControllerRelational.this.getDesign().getRelationalDesign();
                    }
                    if (objectType.equalsIgnoreCase("Design")) {
                        object = ControllerRelational.this.getDesign();
                    }
                    if (object == null) {
                        object = this.createObject(objectType);
                    }
                    if (object == null || (trs = trMan.getTransformersFor(object.getClass())).getToObjectTransformer() == null) continue;
                    ((XMLToObjectTransformer)trs.getToObjectTransformer()).transformToObject(object, inputSource, true, null);
                    if (!(object instanceof FKIndexAssociation)) continue;
                }
            }
        }

        private Object createObject(String objectType) {
            if (objectType.equalsIgnoreCase("Table")) {
                return ControllerRelational.this.getDesign().getRelationalDesign().createTable();
            }
            if (objectType.equalsIgnoreCase("View")) {
                return ControllerRelational.this.getDesign().getRelationalDesign().createTableView();
            }
            if (objectType.equalsIgnoreCase("FKIndexAssociation")) {
                return new FKIndexAssociation(ControllerRelational.this.getDesign().getRelationalDesign());
            }
            if (objectType.equalsIgnoreCase("Entity")) {
                return ControllerRelational.this.getDesign().getLogicalDesign().createEntity();
            }
            if (objectType.equalsIgnoreCase("EntityView")) {
                return ControllerRelational.this.getDesign().getLogicalDesign().createEntityView();
            }
            if (objectType.equalsIgnoreCase("Relation")) {
                return ControllerRelational.this.getDesign().getLogicalDesign().createRelation();
            }
            if (objectType.equalsIgnoreCase("Hierarchy relation")) {
                return ControllerRelational.this.getDesign().getLogicalDesign().createNewInheritanceRelation();
            }
            if (objectType.equalsIgnoreCase("Arc")) {
                return ControllerRelational.this.getDesign().getLogicalDesign().createArc();
            }
            if (objectType.equalsIgnoreCase("FKArc")) {
                return ControllerRelational.this.getDesign().getRelationalDesign().createArc();
            }
            return null;
        }
    }

    class SyncDataDictionary
    extends MDBAction {
        private RelationalDesign relModel;
        private boolean syncMode;

        private SyncDataDictionary(String name, Icon icon, boolean syncMode) {
            super(name, icon);
            this.relModel = null;
            this.syncMode = syncMode;
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable && this.canHandle());
        }

        private boolean canHandle() {
            this.relModel = (RelationalDesign)ControllerRelational.this.getDPVPhysical().getDesignPart();
            if (this.relModel != null) {
                for (int i = 0; i < this.relModel.getImportConnectionStamps().size(); ++i) {
                    int connType = this.relModel.getImportConnectionStamp(i).getConnType();
                    if (connType != 1 && connType != 2 && connType != 3 && connType != 4) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            try {
                this.relModel = (RelationalDesign)ControllerRelational.this.getDPVPhysical().getDesignPart();
                if (this.relModel != null) {
                    SyncUtils.syncDataDictionary(this.relModel, this.syncMode, null);
                }
            }
            catch (Throwable ex) {
                MessageDialogs.showErrorMessage(ex.getMessage());
                LOGGER.error(ex);
            }
        }
    }

    class SyncDataDictionaryWithModel
    extends SyncDataDictionary {
        private SyncDataDictionaryWithModel() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerRelational.SyncDataDictionaryWithModel")), ControllerRelational.this.getConfiguration().getIcon("SYNC_DICT_WITH_MODEL", ControllerRelational.this.getPreferredIconSize()), true);
            this.setMenuPath(ControllerRelational.this.PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerRelational.SyncDataDictionaryWithModel")));
        }

        @Override
        public boolean addToolbarSeparator() {
            return false;
        }
    }

    class SyncModelWithDataDictionary
    extends SyncDataDictionary {
        private SyncModelWithDataDictionary() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerRelational.SyncModelWithDataDictionary")), ControllerRelational.this.getConfiguration().getIcon("SYNC_MODEL_WITH_DICT", ControllerRelational.this.getPreferredIconSize()), false);
            this.setMenuPath(ControllerRelational.this.PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerRelational.SyncModelWithDataDictionary")));
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }
    }

    class GenerateDDL
    extends MDBAction {
        private GenerateDDL() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerRelational.GenerateDDL")), ControllerRelational.this.getConfiguration().getIcon("DDL_FILE_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerRelational.GenerateDDL")));
            this.setAccelerator(KeyStroke.getKeyStroke(71, 64, false));
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            RelationalDesign design = (RelationalDesign)ControllerRelational.this.getDPVPhysical().getDesignPart();
            if (design != null) {
                ControllerRelational.this.getDesign().setRelationalDesign(design);
                ControllerRelational.this.getApplicationView().setCurrentDesign(ControllerRelational.this.getDesign());
                ControllerRelational.this.getApplicationView().setDDLFileMakerEditorVisible(true);
            }
        }
    }

    class MergeTables
    extends SelectedObjectAction {
        private MergeTables() {
            super(MenuUtils.getMnemonicStr(AbstractController.MERGE_TABLES_CAPTION), ControllerRelational.this.getConfiguration().getIcon("MERGE_TABLE_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.MERGE_TABLES_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.updateToolbar(this);
            ApplicationView.log(Messages.getString("ControllerRelational.MergeTables"));
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(Diagram.MERGE_CURSOR);
            DenormalizerMergeTable denormalizer = new DenormalizerMergeTable();
            new TableCollectorMerge(denormalizer);
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable && this.canHandle());
        }

        private boolean canHandle() {
            return !ControllerRelational.this.getDesign().isLoadFromDB() || ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }

        @Override
        public boolean canHandle(SelectableObject selected) {
            return !ControllerRelational.this.getDesign().isLoadFromDB() || ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }
    }

    class SplitTable
    extends SelectedObjectAction {
        private SplitTable() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerRelational.SplitTable")), ControllerRelational.this.getConfiguration().getIcon("SPLIT_TABLE_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerRelational.SplitTable")));
            this.setObjectAction(true);
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.updateToolbar(this);
            DenormalizerSplitTable denormalizer = new DenormalizerSplitTable();
            Table table = (Table)ControllerRelational.this.getDesignPartView().getCurrentSelection().getSelectedObject();
            if (table != null) {
                ApplicationView.log(MessageFormat.format(Messages.getString("ControllerRelational.SplitTable1"), table.getName()));
            } else {
                ApplicationView.log(Messages.getString("ControllerRelational.SplitTable"));
            }
            denormalizer.setOriginalTable(table);
            if (denormalizer.canSplit()) {
                SplitTableWizard stw = new SplitTableWizard(ControllerRelational.this.getApplicationView(), denormalizer);
                stw.showDialog();
            }
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable && this.canHandle());
        }

        private boolean canHandle() {
            return !ControllerRelational.this.getDesign().isLoadFromDB() || ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }

        @Override
        public boolean canHandle(SelectableObject selected) {
            if (ControllerRelational.this.getDesign().isLoadFromDB() && !ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe()) {
                return false;
            }
            if (selected == null) {
                return false;
            }
            boolean result = selected.getSelectedDesignObject() instanceof Table;
            return result;
        }
    }

    public class RevEngineer
    extends MDBAction {
        private RevEngineer() {
            super(MenuUtils.getMnemonicStr(AbstractController.REVERSE_ENGINEER_CAPTION), ControllerRelational.this.getConfiguration().getIcon("REVERSE_ENGINEER_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.DESIGN_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.REVERSE_ENGINEER_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(82, 192, false));
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable && this.canHandle());
        }

        private boolean canHandle() {
            return !ControllerRelational.this.getDesign().isLoadFromDB() || ControllerRelational.this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            EngineeringCompareDialog engDial = new EngineeringCompareDialog(ControllerRelational.this.getApplicationView(), ControllerRelational.this.getApplicationView().getCurrentDPV().getDesignPart());
            engDial.setModal(true);
            engDial.show();
        }
    }

    class NewTypeSubstitution
    extends MDBAction {
        TypedElementCollector collector;

        private NewTypeSubstitution() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_TYPE_SUBSTITUTION_CAPTION), ControllerRelational.this.getConfiguration().getIcon("RAGGED_LINK_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_TYPE_SUBSTITUTION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerRelational.this.getDesignPartView().getWorkSpace().setDrawnObjectID(18);
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerRelational.this.updateToolbar(this);
            this.collector = new TypedElementCollector();
        }
    }

    class NewFKRelation
    extends MDBAction {
        private NewFKRelation() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_FK_RELATION_CAPTION), ControllerRelational.this.getConfiguration().getIcon("FK_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_FK_RELATION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerRelational.this.getDesignPartView().getWorkSpace().setDrawnObjectID(3);
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerRelational.this.updateToolbar(this);
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.fkCollector = new TableCollectorFKRelation();
        }
    }

    class NewImage
    extends MDBAction {
        private NewImage() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_IMAGE_CAPTION), ControllerRelational.this.getConfiguration().getIcon("IMAGE_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_IMAGE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.getDesignPartView().getWorkSpace().setDrawnObjectID(25);
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerRelational.this.updateToolbar(this);
        }
    }

    class NewNote
    extends MDBAction {
        private NewNote() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_NOTE_CAPTION), ControllerRelational.this.getConfiguration().getIcon("NOTE_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_NOTE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.getDesignPartView().getWorkSpace().setDrawnObjectID(5);
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerRelational.this.updateToolbar(this);
        }
    }

    class NewTableView
    extends MDBAction {
        private NewTableView() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_VIEW_CAPTION), ControllerRelational.this.getConfiguration().getIcon("VIEW_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_VIEW_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.getDesignPartView().getWorkSpace().setDrawnObjectID(4);
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerRelational.this.updateToolbar(this);
        }
    }

    class NewTable
    extends MDBAction {
        private NewTable() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_TABLE_CAPTION), ControllerRelational.this.getConfiguration().getIcon("TABLE_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_TABLE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.getDesignPartView().getWorkSpace().setDrawnObjectID(2);
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerRelational.this.updateToolbar(this);
        }
    }

    class Delete
    extends MDBAction {
        private Delete() {
            super(MenuUtils.getMnemonicStr(AbstractController.DELETE_CAPTION), ControllerRelational.this.getConfiguration().getIcon("DELETE_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DELETE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.getDesignPartView().getWorkSpace().setDrawnObjectID(6);
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(Diagram.DELETE_CURSOR);
            ControllerRelational.this.updateToolbar(this);
        }
    }

    class Select
    extends MDBAction {
        private Select() {
            super(MenuUtils.getMnemonicStr(AbstractController.SELECT_CAPTION), ControllerRelational.this.getConfiguration().getIcon("SELECT_ICON", ControllerRelational.this.getPreferredIconSize()));
            this.setMenuPath(ControllerRelational.this.OBJECT_PHYSICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SELECT_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerRelational.this.fkCollector != null) {
                ControllerRelational.this.fkCollector.stopWaiting();
            }
            ControllerRelational.this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
            ControllerRelational.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
            ControllerRelational.this.updateToolbar(this);
        }
    }
}

